/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.faces;

import java.util.ArrayList;
import java.util.List;
import oracle.adf.model.adapter.dataformat.AccessorDef;
import oracle.adf.model.adapter.dataformat.AttributeDef;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.provider.ModelProvider;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.adfdtinternal.view.rich.binding.provider.ADFSelectionModelProvider;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.NamedDefinition;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlChild;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructuredTypeObject;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.binding.pattern.selection.SelectOneOptions;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.bind.BindCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IDataControlStructureObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.ObjectImplUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.DefaultOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.faces.SelectOneOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.IObjectTranslator;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.OEPEContextImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.BindOperationType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.IOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.ISelectOneOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.ComponentOptionsPageProvider;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.faces.SelectOneOptionsPageProvider;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SelectOneOptionsMapper
extends DefaultOptionsMapper<SelectOneOptions> {
    private ISelectOneOptionsModel _model;
    private final BindCommand _bindCommand;

    public SelectOneOptionsMapper(BindOperationType opType, Widget<SelectOneOptions> widget, CreatorParams<SelectOneOptions> params, BindCommand bindCommand) {
        super(opType, widget, params);
        this._bindCommand = bindCommand;
    }

    public ISelectOneOptionsModel getModel() {
        if (this._model == null) {
            NamedDefinition namedDef = this.getDefinition();
            if (namedDef != null && namedDef.getDefinitionType() == 30) {
                List dataControls = DTRTObjectUtil.getDataControls((IDataControlProvider)this._bindCommand.getCommandStack());
                this._model = new SelectOneOptionsModel((AttributeDefinition)namedDef, dataControls, this.getValidator(namedDef));
            }
            if (this._model != null) {
                this.initModel(this._model);
            }
        }
        return this._model;
    }

    private NamedDefinition getDefinition() {
        ModelProvider modelProvider = this.getParams().getModelProvider();
        if (modelProvider instanceof ADFSelectionModelProvider) {
            return ((ADFSelectionModelProvider)modelProvider).getDefinition();
        }
        return null;
    }

    private IValidator getValidator(NamedDefinition namedDef) {
        ArrayList<IValidator> validators = new ArrayList<IValidator>();
        validators.add(new SelectionIsCollectionAccessorValidator());
        return new CompositeValidator(validators);
    }

    private void initModel(ISelectOneOptionsModel model) {
    }

    @Override
    public ComponentOptionsPageProvider createPageProvider() {
        return new SelectOneOptionsPageProvider((IOptionsMapper)this);
    }

    @Override
    public IStatus validateModel() {
        IStatus status = this.validateNamedDefinition(this.getModel().getListDataSource(), 40, Messages.error_missingListDataSource);
        if (status == null) {
            status = this.checkForSameAccessor(this.getModel().getListDataSource());
        }
        if (status == null) {
            status = this.validateNamedDefinition(this.getModel().getListAttribute(), 30, Messages.error_missingListAttribute);
        }
        if (status == null) {
            status = this.validateNamedDefinition(this.getModel().getDisplayAttribute(), 30, Messages.error_missingDisplayAttribute);
        }
        return status;
    }

    private IStatus checkForSameAccessor(IDataControlObject listDataSource) {
        IStatus status = null;
        NamedDefinition targetNamedDef = this.getDefinition();
        if (targetNamedDef != null) {
            Definition baseDataSourceDef = targetNamedDef.getDefinitionParent();
            NamedDefinition listSourceNamedDef = ObjectImplUtil.getNamedDefinition((IStructuredTypeObject)listDataSource);
            if (baseDataSourceDef != null && listSourceNamedDef != null && baseDataSourceDef.getDefinitionType() == 40 && listSourceNamedDef.getDefinitionType() == 40 && baseDataSourceDef.equals(listSourceNamedDef)) {
                return new Status(4, "oracle.eclipse.tools.adf.dtrt.v110101", Messages.error_sameIteratorUsedForBaseDataSourceAndList);
            }
        }
        return status;
    }

    private IStatus validateNamedDefinition(IDataControlObject dcObject, int expectedType, String errorMsg) {
        NamedDefinition namedDef = ObjectImplUtil.getNamedDefinition((IStructuredTypeObject)dcObject);
        if (namedDef == null || namedDef.getDefinitionType() != expectedType) {
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v110101", errorMsg);
        }
        return null;
    }

    @Override
    public void updateOptions() {
        SelectOneOptions options = (SelectOneOptions)((Object)this.getPatternOptions());
        IDataControlObject dcObject = this.getModel().getListDataSource();
        options.setListDataSourceDC(this.getDataControl(dcObject));
        options.setListDataSource((AccessorDef)ObjectImplUtil.getNamedDefinition((IStructuredTypeObject)dcObject));
        dcObject = this.getModel().getListAttribute();
        options.setListAttribute((AttributeDef)ObjectImplUtil.getNamedDefinition((IStructuredTypeObject)dcObject));
        dcObject = this.getModel().getDisplayAttribute();
        options.setDisplayAttribute((AttributeDef)ObjectImplUtil.getNamedDefinition((IStructuredTypeObject)dcObject));
    }

    private DataControl getDataControl(IDataControlObject dataControlObject) {
        DataControl dataControl = null;
        if (dataControlObject instanceof IDataControlChild && ((IDataControlChild)dataControlObject).getStructureObject() != null) {
            IObjectTranslator translator = OEPEContextImpl.getTranslator((IOEPEContext)this._bindCommand.getCommandStack());
            dataControl = (DataControl)translator.toADFObject((IObject)DTRTObjectUtil.getDataControl((IDataControlObject)dataControlObject));
        }
        return dataControl;
    }

    private static class CompositeValidator
    implements IValidator {
        private List<IValidator> composeThese;

        public CompositeValidator(List<IValidator> composeThese) {
            this.composeThese = composeThese;
        }

        public IStatus validate(Object value) {
            for (IValidator validator : this.composeThese) {
                IStatus result = validator.validate(value);
                if (result.isOK()) continue;
                return result;
            }
            return Status.OK_STATUS;
        }
    }

    private static class Messages
    extends NLS {
        public static String error_missingListDataSource;
        public static String error_missingListAttribute;
        public static String error_missingDisplayAttribute;
        public static String error_sameIteratorUsedForBaseDataSourceAndList;

        static {
            NLS.initializeMessages((String)SelectOneOptionsMapper.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }

    private static class SelectionIsCollectionAccessorValidator
    implements IValidator {
        private SelectionIsCollectionAccessorValidator() {
        }

        public IStatus validate(Object dcObject) {
            Object decoratedObject;
            if (dcObject instanceof IDataControlStructureObject && (decoratedObject = ((IDataControlStructureObject)dcObject).getDecoratedObject()) instanceof NamedDefinition && ((NamedDefinition)decoratedObject).getDefinitionType() == 40 && ((AccessorDef)decoratedObject).isCollection()) {
                return Status.OK_STATUS;
            }
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v110101", "select a collection");
        }
    }
}

