/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.faces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.provider.ModelProvider;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.adfdt.view.rich.binding.pattern.form.Field;
import oracle.adfdt.view.rich.binding.pattern.form.FormOptions;
import oracle.adfdtinternal.view.rich.binding.provider.ADFIteratorModelProvider;
import oracle.binding.meta.NamedDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.faces.AbstractTableFormOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.util.BindingUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.BindOperationType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.IFormOptionsModelElement;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.INamedDefinitionModelElement;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.IValueBindingModelElement;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ExecutableElement;

public class FormOptionsMapper
extends AbstractTableFormOptionsMapper<Field, FormOptions> {
    public FormOptionsMapper(BindOperationType opType, Widget<FormOptions> widget, CreatorParams<FormOptions> params) {
        super(opType, widget, params);
    }

    @Override
    protected ExecutableElement createModel() {
        IFormOptionsModelElement model = (IFormOptionsModelElement)IFormOptionsModelElement.TYPE.instantiate();
        if (((FormOptions)this.getPatternOptions()).isReadOnly()) {
            model.setReadOnly(Boolean.TRUE);
        }
        if (((FormOptions)this.getPatternOptions()).isCreateNavigation()) {
            model.setCreateNavigation(Boolean.TRUE);
        }
        if (((FormOptions)this.getPatternOptions()).isCreateSubmitButton()) {
            model.setCreateSubmitButton(Boolean.TRUE);
        }
        if (this.showNavOptions()) {
            model.setShowNavOptions(Boolean.TRUE);
        }
        this.initPossibleNamedDefs(model);
        List<Field> fields = ((FormOptions)this.getPatternOptions()).getFields();
        if (fields.isEmpty()) {
            fields = this.getFields();
        }
        for (Field field : fields) {
            Widget preferredWidget;
            IValueBindingModelElement vbModelElem;
            NamedDefinition namedDef = field.getDefinition();
            if (namedDef == null || (vbModelElem = (IValueBindingModelElement)model.getFields().insert()) == null) continue;
            vbModelElem.setDisplayLabel(FormOptionsMapper.computeUILabel(field.getLabel(), namedDef.getName()));
            vbModelElem.setValueBinding(namedDef.getFullName());
            Widget widget = field.getWidget();
            if (widget != null) {
                vbModelElem.setComponentToUse(widget.getId());
                continue;
            }
            Collection<String> inclusionContexts = null;
            if (((FormOptions)this.getPatternOptions()).isReadOnly()) {
                inclusionContexts = this.getReadOnlyInclusionContexts();
            }
            if ((preferredWidget = this.getPreferredWidget(field, inclusionContexts)) == null) continue;
            vbModelElem.setComponentToUse(preferredWidget.getId());
        }
        return model;
    }

    @Override
    public void updateOptions() {
        IFormOptionsModelElement model = (IFormOptionsModelElement)this.getModel();
        FormOptions options = (FormOptions)this.getPatternOptions();
        ArrayList<Field> fields = new ArrayList<Field>();
        ElementList fieldElems = model.getFields();
        for (IValueBindingModelElement colModelElem : fieldElems) {
            String componentToUse;
            String attrId = (String)colModelElem.getValueBinding().content();
            Field field = this.createField(attrId, componentToUse = (String)colModelElem.getComponentToUse().content());
            if (field == null) continue;
            String label = (String)colModelElem.getDisplayLabel().content();
            field.setLabel(FormOptionsMapper.computeOptionsLabel(label));
            fields.add(field);
        }
        options.setFields(fields);
        options.setReadOnly(model.isReadOnly().content() == Boolean.TRUE);
        options.setCreateNavigation(model.isCreateNavigation().content() == Boolean.TRUE);
        options.setCreateSubmitButton(model.isCreateSubmitButton().content() == Boolean.TRUE);
    }

    private boolean showNavOptions() {
        NamedDefinition namedDef;
        ModelProvider modelProvider = this.getParams().getModelProvider();
        return modelProvider instanceof ADFIteratorModelProvider && BindingUtil.isAccessorDefinition(namedDef = ((ADFIteratorModelProvider)modelProvider).getDefinition());
    }

    private void initPossibleNamedDefs(IFormOptionsModelElement model) {
        for (Field field : this.getFields()) {
            INamedDefinitionModelElement namedDefModelElem;
            NamedDefinition namedDef = field.getDefinition();
            if (namedDef == null || (namedDefModelElem = (INamedDefinitionModelElement)model.getNamedDefs().insert()) == null) continue;
            namedDefModelElem.setFullName(namedDef.getFullName());
            namedDefModelElem.setName(FormOptionsMapper.getNamedDefQualifiedName(namedDef));
            this.initPossibleNamedDefWidgets(field, namedDefModelElem);
        }
    }

    private Field createField(String attrId, String componentToUse) {
        if (attrId != null) {
            for (Field c : this.getFields()) {
                NamedDefinition namedDef = c.getDefinition();
                if (namedDef == null || !attrId.equals(namedDef.getFullName())) continue;
                Field field = Field.create((NamedDefinition)namedDef);
                if (componentToUse != null) {
                    for (Widget widget : this.getAvailableWidgets(c)) {
                        if (!componentToUse.equals(widget.getId())) continue;
                        field.setWidget(widget);
                        return field;
                    }
                }
                return field;
            }
        }
        return null;
    }

    private List<Field> getFields() {
        if (this.getCreatePatternOptions() != null) {
            return ((FormOptions)this.getCreatePatternOptions()).getFields();
        }
        return new ArrayList<Field>();
    }

    @Override
    protected List<Widget> getAvailableWidgets(Field field) {
        if (this.getCreatePatternOptions() != null && field != null) {
            return ((FormOptions)this.getCreatePatternOptions()).getAvailableWidgets(field);
        }
        return new ArrayList<Widget>();
    }

    @Override
    public String getDefinitionPath() {
        return "form.options.wizard";
    }
}

