/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import oracle.adf.model.dvt.binding.common.DataItemDefinition;
import oracle.adf.model.dvt.binding.common.LayerDefinition;
import oracle.adf.model.dvt.binding.common.RowsetDataLayerDefinition;
import oracle.adfdt.view.common.binding.creator.v2.BinderParams;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.provider.ModelProvider;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphFootnote;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphOptions;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphSubtitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphTitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.LegendArea;
import oracle.adfdt.view.dvt.binding.pattern.graph.LegendTitle;
import oracle.adfdt.view.dvt.binding.provider.DvtCoreProvider;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.binding.creator.CreatorPresentationManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.DefaultOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.GraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.GraphOptionsResources;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.ICommonGraphOptions;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.util.BindingUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.ICreatorPresentation;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.PresentationLayout;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.BindOperationType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.IOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GraphType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.ComponentOptionsPageProvider;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph.GraphOptionsPageProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class GraphOptionsMapper<O extends GraphOptions>
extends DefaultOptionsMapper<O> {
    protected static final String DVT_NS_URI = "http://xmlns.oracle.com/dss/adf/faces";
    protected static final String AUTOMATICPLACEMENT_ATTR_NAME = "automaticPlacement";
    protected static final String AUTOMATICPLACEMENT_NEVER = "AP_NEVER";
    protected static final String BACKGROUND_TAG_NAME = "background";
    protected static final String CUSTOMLAYOUT_ATTR_NAME = "customLayout";
    protected static final String CUSTOMLAYOUT_NONE = "CL_NONE";
    protected static final String HORIZ_ALIGNMENT_CENTER = "CENTER";
    protected static final String LAP_BOTTOM = "LAP_BOTTOM";
    protected static final String LAP_TOP = "LAP_TOP";
    protected static final String LEGENDAREA_TAG_NAME = "legendArea";
    protected static final String POSITION_ATTR_NAME = "position";
    protected static final String QUICKLAYOUT_QL1 = "QL1_default";
    protected static final String RENDERED_ATTR_NAME = "rendered";
    protected static final String SERIES_TAG_NAME = "series";
    protected static final String SERIESSET_TAG_NAME = "seriesSet";
    protected static final String SPECIALEFFECTS_TAG_NAME = "specialEffects";
    protected static final String Y1AXIS_TAG_NAME = "y1Axis";
    private static final String UNKNOWN_QUICK_LAYOUT = "unknown";
    private IGraphOptionsModel _model;

    public GraphOptionsMapper(BindOperationType opType, Widget<O> widget, CreatorParams<O> params) {
        super(opType, widget, params);
    }

    public IGraphOptionsModel getModel() {
        if (this._model == null) {
            NamedDefinition namedDef = this.getDefinition();
            if (BindingUtil.isAccessorDefinition(namedDef)) {
                AccessorDefinition accessorDef = (AccessorDefinition)namedDef;
                StructureDefinition structureDef = accessorDef.getStructure();
                List<AttributeDefinition> attrDefs = BindingUtil.getAttributeDefinitions(structureDef, false);
                this._model = this.createModel(this.getType(), CreatorPresentationManager.getInstance().getCreatorPresentation(this.getType().toString()), attrDefs);
            }
            if (this._model != null) {
                this.initModel(this._model);
            }
        }
        return this._model;
    }

    protected IGraphOptionsModel createModel(GraphType type, ICreatorPresentation creatorPresentation, List<AttributeDefinition> attrDefs) {
        return new GraphOptionsModel(type, creatorPresentation, attrDefs);
    }

    @Override
    public ComponentOptionsPageProvider createPageProvider() {
        return new GraphOptionsPageProvider((IOptionsMapper)this);
    }

    protected abstract GraphType getType();

    protected abstract ICommonGraphOptions getCommonGraphOptions();

    protected void initModel(IGraphOptionsModel model) {
        NodeList legendAreaElements;
        Element graphElement;
        Node bindRoot;
        ICommonGraphOptions options = this.getCommonGraphOptions();
        PresentationLayout layout = null;
        if (this.getBindingContextType() != BindOperationType.CREATE) {
            layout = new PresentationLayout(options.getGraphSubType(), UNKNOWN_QUICK_LAYOUT);
        }
        model.setPresentationLayout(layout);
        List<LayerDefinition> series = null;
        List<LayerDefinition> groups = null;
        if (this.getBindingContextType() == BindOperationType.EDIT) {
            series = options.getSeriesEdge();
            groups = options.getGroupsEdge();
        }
        model.setSeriesItemContexts(this.getEdgeItemContexts(series));
        List<EdgeItemContext> groupsItemCtxts = this.getEdgeItemContexts(groups);
        model.setGroupsItemContexts(groupsItemCtxts);
        model.setDataOnSeries(!GraphOptionsMapper.contextsIncludeDataItems(groupsItemCtxts));
        model.setRowSelection(options.isRowSelection());
        if (this.getBindingContextType() != BindOperationType.CREATE && (bindRoot = ((BinderParams)this.getParams()).getBindRoots()) != null && (graphElement = GraphOptionsMapper.getSingleBindRoot(bindRoot)) != null && graphElement.getLocalName().equals(options.getGraphType()) && (legendAreaElements = graphElement.getElementsByTagNameNS(DVT_NS_URI, LEGENDAREA_TAG_NAME)) != null && legendAreaElements.getLength() == 1) {
            Attr renderedAttr;
            Element legendAreaElement = (Element)legendAreaElements.item(0);
            LegendArea legendArea = new LegendArea();
            Attr positionAttr = legendAreaElement.getAttributeNode(POSITION_ATTR_NAME);
            if (positionAttr != null) {
                legendArea.setPosition(positionAttr.getValue());
            }
            if ((renderedAttr = legendAreaElement.getAttributeNode(RENDERED_ATTR_NAME)) != null) {
                legendArea.setRendered(Boolean.valueOf(renderedAttr.getValue()).booleanValue());
            }
            options.setLegendArea(legendArea);
        }
    }

    protected List<EdgeItemContext> getEdgeItemContexts(List<LayerDefinition> edge) {
        ArrayList<EdgeItemContext> itemContexts = new ArrayList<EdgeItemContext>();
        if (edge != null) {
            for (LayerDefinition layerDef : edge) {
                if (layerDef instanceof RowsetDataLayerDefinition) {
                    RowsetDataLayerDefinition dataLayerDef = (RowsetDataLayerDefinition)layerDef;
                    for (DataItemDefinition diDef : dataLayerDef.getDataItems()) {
                        EdgeItemContext itemContext = this.getModel().findEdgeItemContext(diDef.getValue());
                        if (itemContext == null) continue;
                        itemContext.setDataItem(true);
                        itemContext.setTreatAsText(false);
                        itemContext.setLabel(diDef.getLabel());
                        itemContexts.add(itemContext);
                    }
                    continue;
                }
                EdgeItemContext itemContext = this.getModel().findEdgeItemContext(layerDef.getValueAttribute());
                if (itemContext == null) continue;
                itemContext.setDataItem(false);
                itemContext.setTreatAsText(true);
                itemContext.setLabel(layerDef.getLabelAttribute());
                itemContexts.add(itemContext);
            }
        }
        return itemContexts;
    }

    private NamedDefinition getDefinition() {
        ModelProvider modelProvider = this.getParams().getModelProvider();
        if (modelProvider instanceof DvtCoreProvider) {
            return ((DvtCoreProvider)modelProvider).getDefinition();
        }
        return null;
    }

    protected static boolean contextsIncludeDataItems(List<EdgeItemContext> itemContexts) {
        EdgeItemContext context;
        return itemContexts != null && !itemContexts.isEmpty() && (context = itemContexts.get(0)).isDataItem();
    }

    protected static boolean edgeHasDataItemCount(List<EdgeItemContext> edge, int expectedDataItemsCount) {
        if (edge != null && edge.size() >= expectedDataItemsCount) {
            int count = 0;
            for (EdgeItemContext item : edge) {
                if (!item.isNumeric() || item.isTreatAsText() || ++count < expectedDataItemsCount) continue;
                return true;
            }
        }
        return false;
    }

    protected void update(ICommonGraphOptions options) {
        boolean dataOnSeries = this.getModel().isDataOnSeries();
        options.setSeriesEdge(GraphOptionsMapper.updateEdge(this.getModel().getSeriesItemContexts(), dataOnSeries));
        options.setGroupsEdge(GraphOptionsMapper.updateEdge(this.getModel().getGroupsItemContexts(), !dataOnSeries));
        options.setRowSelection(this.getModel().isRowSelection());
    }

    protected static List<LayerDefinition> updateEdge(List<EdgeItemContext> itemContexts, boolean isDataLayer) {
        LinkedList<LayerDefinition> edge = new LinkedList<LayerDefinition>();
        if (itemContexts != null && !itemContexts.isEmpty()) {
            if (isDataLayer) {
                RowsetDataLayerDefinition dataLayerDef = new RowsetDataLayerDefinition();
                for (EdgeItemContext itemContext : itemContexts) {
                    String label = itemContext.getLabel();
                    if (label != null && "__NO_LABEL".equals(label)) {
                        label = "__NO_LABEL";
                    }
                    if (itemContext.isNumeric() && !itemContext.isTreatAsText()) {
                        DataItemDefinition diDef = new DataItemDefinition(itemContext.getName());
                        diDef.setLabel(label);
                        dataLayerDef.addDataItem(diDef);
                        continue;
                    }
                    LayerDefinition layerDef = new LayerDefinition(itemContext.getName());
                    layerDef.setLabelAttribute(label);
                    edge.add(layerDef);
                }
                EdgeItemContext lastItem = itemContexts.get(itemContexts.size() - 1);
                if (lastItem.isNumeric() && !lastItem.isTreatAsText()) {
                    edge.add((LayerDefinition)dataLayerDef);
                } else {
                    edge.add(0, (LayerDefinition)dataLayerDef);
                }
            } else {
                for (EdgeItemContext itemContext : itemContexts) {
                    String label = itemContext.getLabel();
                    if (label != null && "__NO_LABEL".equals(label)) {
                        label = "__NO_LABEL";
                    }
                    LayerDefinition layerDef = new LayerDefinition(itemContext.getName());
                    layerDef.setLabelAttribute(label);
                    edge.add(layerDef);
                }
            }
        }
        return edge;
    }

    protected static void configureQuickLayout2(ICommonGraphOptions options) {
        LegendArea legendArea = new LegendArea();
        options.setLegendArea(legendArea);
        LegendTitle legendTitle = new LegendTitle();
        legendTitle.setText(GraphOptionsResources.quickLayout_legendTitle);
        options.setLegendTitle(legendTitle);
        GraphFootnote graphFootnote = new GraphFootnote();
        graphFootnote.setText(GraphOptionsResources.quickLayout_graphFootnote);
        options.setGraphFootnote(graphFootnote);
        GraphSubtitle graphSubtitle = new GraphSubtitle();
        graphSubtitle.setText(GraphOptionsResources.quickLayout_graphSubtitle);
        options.setGraphSubtitle(graphSubtitle);
        GraphTitle graphTitle = new GraphTitle();
        graphTitle.setText(GraphOptionsResources.quickLayout_graphTitle);
        options.setGraphTitle(graphTitle);
    }

    protected static Element addBackgroundTag(Element graph) {
        Element background = null;
        NodeList children = graph.getElementsByTagNameNS(DVT_NS_URI, BACKGROUND_TAG_NAME);
        if (children == null || children.getLength() == 0) {
            Document doc = graph.getOwnerDocument();
            background = doc.createElementNS(DVT_NS_URI, BACKGROUND_TAG_NAME);
            Node firstChild = graph.getFirstChild();
            if (firstChild == null) {
                graph.appendChild(background);
            } else {
                graph.insertBefore(background, firstChild);
            }
            Element se = doc.createElementNS(DVT_NS_URI, SPECIALEFFECTS_TAG_NAME);
            background.appendChild(se);
        } else if (children.getLength() == 1) {
            background = (Element)children.item(0);
        }
        return background;
    }

    protected static Element addSeriesSetTag(Element graph, Element refChild) {
        Element seriesSet = GraphOptionsMapper.addTag(graph, SERIESSET_TAG_NAME, refChild);
        if (seriesSet != null) {
            GraphOptionsMapper.addTag(seriesSet, SERIES_TAG_NAME, null);
        }
        return seriesSet;
    }

    protected static Element addTag(Element parent, String localName, Element refChild) {
        Element tag = null;
        NodeList children = parent.getElementsByTagNameNS(DVT_NS_URI, localName);
        if (children == null || children.getLength() == 0) {
            Document doc = parent.getOwnerDocument();
            tag = doc.createElementNS(DVT_NS_URI, localName);
            if (refChild == null || refChild.getNextSibling() == null) {
                parent.appendChild(tag);
            } else {
                parent.insertBefore(tag, refChild.getNextSibling());
            }
        }
        return tag;
    }

    protected void updateLegendAreaAutomaticPlacementAttr(Element graph) {
        NodeList children = graph.getElementsByTagNameNS(DVT_NS_URI, LEGENDAREA_TAG_NAME);
        Element legendArea = null;
        if (children == null || children.getLength() == 0) {
            Document doc = graph.getOwnerDocument();
            legendArea = doc.createElementNS(DVT_NS_URI, LEGENDAREA_TAG_NAME);
            graph.appendChild(legendArea);
        } else if (children.getLength() == 1) {
            legendArea = (Element)children.item(0);
        }
        if (legendArea != null) {
            legendArea.setAttribute(AUTOMATICPLACEMENT_ATTR_NAME, AUTOMATICPLACEMENT_NEVER);
        }
    }
}

