/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.object;

import oracle.adfdt.model.objects.IteratorBinding;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.NamedDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IDataControlStructureObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.util.DtrtSwitch;

public class ADFTypeResolver {
    public static final ADFTypeResolver INSTANCE = new ADFTypeResolver();

    public boolean isSimpleCollection(Definition def) {
        Boolean result = (Boolean)new DtrtSwitch<Boolean>(){

            @Override
            protected Boolean doSwitch(AccessorDefinition obj) {
                if (obj.getJavaTypeString() != null && obj.isCollection()) {
                    return true;
                }
                return false;
            }
        }.doSwitch((Object)def);
        if (result != null) {
            return result;
        }
        return false;
    }

    public boolean isAccessor(IDataControlObject dataControlObject) {
        Object decoratedObject;
        return dataControlObject instanceof IDataControlStructureObject && (decoratedObject = ((IDataControlStructureObject)dataControlObject).getDecoratedObject()) instanceof AccessorDefinition;
    }

    public boolean isAttribute(IDataControlObject dataControlObject) {
        Object decoratedObject;
        return dataControlObject instanceof IDataControlStructureObject && (decoratedObject = ((IDataControlStructureObject)dataControlObject).getDecoratedObject()) instanceof AttributeDefinition;
    }

    public boolean isSimpleTypeAttribute(IDataControlObject dataControlObject) {
        Object decoratedObject;
        if (dataControlObject instanceof IDataControlStructureObject && (decoratedObject = ((IDataControlStructureObject)dataControlObject).getDecoratedObject()) instanceof AttributeDefinition) {
            return ((AttributeDefinition)decoratedObject).getDefinitionType() == 30;
        }
        return false;
    }

    public boolean isCollection(Object obj) {
        Boolean result = (Boolean)new DtrtSwitch<Boolean>(){

            @Override
            protected Boolean doSwitch(IteratorBinding obj) {
                NamedDefinition namedDefinition = obj.getNamedDefinition();
                if (namedDefinition != null) {
                    return (Boolean)this.doSwitch((Object)namedDefinition);
                }
                return false;
            }

            @Override
            protected Boolean doSwitch(AccessorDefinition obj) {
                if (obj != null && (obj.isCollection() || obj.isScalarCollection())) {
                    return true;
                }
                return false;
            }
        }.doSwitch(obj);
        if (result != null) {
            return result;
        }
        return false;
    }
}

