/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl;

import java.beans.PropertyVetoException;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.adfdt.model.managers.FactoryManager;
import oracle.adfdt.model.objects.Application;
import oracle.adfdt.model.objects.BaseElementObject;
import oracle.adfdt.model.objects.BaseObject;
import oracle.adfdt.model.objects.BeanStructure;
import oracle.adfdt.model.objects.Configuration;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfdt.model.objects.ElementObjectFactory;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.adfdt.model.objects.PageDefinitionUsage;
import oracle.adfdt.model.objects.PageMap;
import oracle.adfdt.model.objects.PageMapEntry;
import oracle.eclipse.tools.adf.common.util.ProjectUtils;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IFileMarker;
import oracle.eclipse.tools.adf.dtrt.util.JavaUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DTRTvContextUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.WebApplication;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.ADFmRegistry;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.ElementData;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.ElementType;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.ManagedXMLFile;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.PersistenceManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.UnsupportedElementObjectFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.boundsource.BoundSourceUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.boundsource.WebPageBoundSourceSubType;
import oracle.eclipse.tools.adf.dtrt.vcommon.manager.LocatorUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonUtil;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IType;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class DTRTManagerImpl
extends PersistenceManager {
    static final String VERSION_ATT = "version";
    static final String VERSION_VALUE = "11.1.1.6.2";
    private static final String DEFAULT_CONFIGURATION = "model.DataControls";
    private static final String DEFAULT_APPLICATION = "view.DataBindings";
    private static final String BUILT_IN_BEAN_STRUCTURES_FOLDER = "builtinBeanStructures/";
    private static final Set<String> BUILT_IN_BEAN_STRUCTURE_FULL_NAMES;
    private IProject earProject;
    private IProject webProject;
    private IProject modelProject;
    private IPageDefinition.IBoundSource boundSource;
    private Document webPageDocument;

    static {
        HashSet<String> set = new HashSet<String>(3);
        set.add("ReadOnlySingleValue");
        set.add("UpdateableCollection");
        set.add("UpdateableSingleValue");
        BUILT_IN_BEAN_STRUCTURE_FULL_NAMES = Collections.unmodifiableSet(set);
    }

    DTRTManagerImpl(IProject modelProject) throws IllegalArgumentException {
        if (!DTRTUtil.isModelProject((IProject)modelProject)) {
            throw new IllegalArgumentException("The specified project is not a model project.");
        }
        this.modelProject = modelProject;
    }

    DTRTManagerImpl(IProject earProject, IProject webProject) throws IllegalArgumentException {
        if (!DTRTUtil.isEARProject((IProject)earProject)) {
            throw new IllegalArgumentException(String.format("'%s' is not an EAR project (web project: '%s')", earProject, webProject));
        }
        if (!DTRTUtil.isWebProject((IProject)webProject)) {
            throw new IllegalArgumentException(String.format("'%s' is not a web project (ear project: '%s')", webProject, earProject));
        }
        this.earProject = earProject;
        this.webProject = webProject;
    }

    @Override
    public void dispose() {
        this.earProject = null;
        this.webProject = null;
        this.modelProject = null;
        this.boundSource = null;
        this.webPageDocument = null;
        super.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.webProject == null && this.modelProject == null;
    }

    @Override
    public IProject getEARProject() {
        return this.earProject;
    }

    @Override
    public boolean initializedWithModelProject() {
        return this.getProject() == this.modelProject;
    }

    @Override
    public boolean initializedWithEARWebProjects() {
        return this.getProject() == this.webProject;
    }

    private void checkInitilisedWithEARWebProjects() {
        if (!this.initializedWithEARWebProjects()) {
            throw new IllegalStateException("To support this method the manager must be initialized with an EAR and web projects.");
        }
    }

    private void checkManaged(BaseElementObject element) {
        boolean managed = this.isManagedElement(element);
        if (!managed) {
            throw new IllegalStateException("The specified element was not created by this manager: " + element);
        }
    }

    private void checkBoundSource() {
        if (this.getBoundSource() == null) {
            throw new IllegalStateException("The bound source must be set.");
        }
        if (!this.getBoundSource().getFile().isAccessible()) {
            throw new IllegalStateException("This is not a valid source for ADF binding.");
        }
    }

    @Override
    public IProject getProject() {
        return this.modelProject != null ? this.modelProject : this.webProject;
    }

    @Override
    public void setBoundSource(IPageDefinition.IBoundSource boundSource) {
        this.checkInitilisedWithEARWebProjects();
        if (boundSource != null && !boundSource.getFile().isAccessible()) {
            throw new IllegalArgumentException("The bound source file must exist.");
        }
        this.boundSource = boundSource;
    }

    @Override
    public IPageDefinition.IBoundSource getBoundSource() {
        this.checkInitilisedWithEARWebProjects();
        return this.boundSource;
    }

    @Override
    public void setWebPageDocument(Document document) {
        this.checkInitilisedWithEARWebProjects();
        this.webPageDocument = document;
    }

    @Override
    public Document getWebPageDocument() {
        this.checkInitilisedWithEARWebProjects();
        return this.webPageDocument;
    }

    private List<? extends PageDefinitionUsage> getPageDefinitionUsages(Application application, PageDefinition pageDefinition) {
        String fullName = pageDefinition.getFullName();
        HashMap pageDefinitionUsages = application.getPageDefinitionUsages();
        if (pageDefinitionUsages != null && !pageDefinitionUsages.isEmpty()) {
            ArrayList<PageDefinitionUsage> list = new ArrayList<PageDefinitionUsage>(pageDefinitionUsages.size());
            for (PageDefinitionUsage pageDefinitionUsage : pageDefinitionUsages.values()) {
                if (!fullName.equals(pageDefinitionUsage.getPath())) continue;
                list.add(pageDefinitionUsage);
            }
            if (!list.isEmpty()) {
                return Collections.unmodifiableList(list);
            }
        }
        return Collections.emptyList();
    }

    private List<IPageDefinition.IBoundSource> computeRegisteredBoundSources(Application application, PageDefinition pageDefinition, Set<String> boundSourcePaths) {
        String fullName = pageDefinition.getFullName();
        HashMap pageDefinitionUsages = application.getPageDefinitionUsages();
        if (pageDefinitionUsages != null && !pageDefinitionUsages.isEmpty()) {
            ArrayList<IPageDefinition.IBoundSource> boundSources = null;
            PageMap pageMap = application.getPageMap();
            boolean usesPageDefinition = false;
            for (PageDefinitionUsage pageDefinitionUsage : pageDefinitionUsages.values()) {
                String usageId;
                if (!fullName.equals(pageDefinitionUsage.getPath()) || (usageId = pageDefinitionUsage.getId()) == null) continue;
                if (pageMap == null) {
                    return Collections.emptyList();
                }
                usesPageDefinition = true;
                for (PageMapEntry entry : pageMap.getEntries()) {
                    String path;
                    if (!usageId.equals(entry.getPageDefinitionId()) || (path = entry.getPath()) == null || !boundSourcePaths.add(path)) continue;
                    if (boundSources == null) {
                        boundSources = new ArrayList<IPageDefinition.IBoundSource>(5);
                    }
                    WebPageBoundSourceSubType[] supportedSubTypes = DTRTvContextUtil.SUPPORTED_WEB_PAGE_BOUND_SOURCE_SUB_TYPES.toArray(new WebPageBoundSourceSubType[0]);
                    IPageDefinition.IBoundSource boundSource = BoundSourceUtil.createBoundSource((IProject)this.getProject(), (String)path, (WebPageBoundSourceSubType[])supportedSubTypes);
                    if (boundSource == null) continue;
                    if (boundSource.equals((Object)this.boundSource)) {
                        boundSources.add(0, boundSource);
                        continue;
                    }
                    boundSources.add(boundSource);
                }
            }
            if (boundSources != null) {
                return Collections.unmodifiableList(boundSources);
            }
            if (usesPageDefinition) {
                return Collections.emptyList();
            }
        }
        return null;
    }

    @Override
    public List<? extends IPageDefinition.IBoundSource> computeRegisteredBoundSources(PageDefinition pageDefinition) {
        if (pageDefinition != null) {
            this.checkInitilisedWithEARWebProjects();
            HashSet<String> boundSourcePaths = new HashSet<String>(5);
            ArrayList<IPageDefinition.IBoundSource> boundSources = new ArrayList<IPageDefinition.IBoundSource>(5);
            String fullName = pageDefinition.getFullName();
            if (fullName != null) {
                for (Application application : this.getApplications()) {
                    List<IPageDefinition.IBoundSource> sources = this.computeRegisteredBoundSources(application, pageDefinition, boundSourcePaths);
                    if (sources == null) continue;
                    boundSources.addAll(sources);
                }
                if (!boundSources.isEmpty()) {
                    return Collections.unmodifiableList(boundSources);
                }
            }
        }
        return Collections.emptyList();
    }

    public <E> E loadRegisteredElement(ElementType<E> elementType, URI uri) throws Exception {
        if (elementType != null && uri != null) {
            E element = this.getElement(elementType, uri);
            if (element == null) {
                Configuration managedElement;
                E loadedElement;
                IFile file = ElementData.computeElementFile(elementType, uri);
                if (!this.isAccessible(file)) {
                    throw new FileNotFoundException(file.getFullPath().toString());
                }
                if (elementType == ElementType.APPLICATION || elementType == ElementType.PAGE_DEFINITION) {
                    this.checkInitilisedWithEARWebProjects();
                    if (!this.getProject().equals((Object)file.getProject())) {
                        throw new IllegalArgumentException(String.format("The file must be located in the web project used to initialize the manager%n(web project: '%s', file: '%s')", this.getProject().getFullPath(), file.getFullPath()));
                    }
                }
                if ((loadedElement = this.initializeElement(elementType, file, false)) == null) {
                    throw new IllegalStateException(String.format("Unable to load the '%s' from '%s'.", elementType.getType().getSimpleName(), file.getFullPath()));
                }
                String fullName = ElementType.getFullName(loadedElement);
                if (DTRTUtil.isEmpty((String)ElementType.getFullName(loadedElement))) {
                    throw new IllegalStateException(String.format("Invalid '%s' in '%s'.", elementType.getType().getSimpleName(), file.getFullPath()));
                }
                switch (elementType.ordinal()) {
                    case 0: 
                    case 5: {
                        this.manage(loadedElement);
                        managedElement = (Configuration)loadedElement;
                        break;
                    }
                    case 1: {
                        managedElement = this.getConfiguration(fullName, false);
                        break;
                    }
                    case 2: {
                        managedElement = this.getApplication(fullName, false);
                        break;
                    }
                    case 3: {
                        managedElement = this.getBeanStructure(fullName, false);
                        break;
                    }
                    case 4: {
                        managedElement = this.getPageDefinition(fullName, false);
                        break;
                    }
                    default: {
                        managedElement = null;
                    }
                }
                element = elementType.getType().cast(managedElement);
            }
            return element;
        }
        return null;
    }

    @Override
    public PageDefinition loadRegisteredPageDefinition(IFile pageDefinitionFile) throws Exception {
        if (pageDefinitionFile != null) {
            return this.loadRegisteredElement(ElementType.PAGE_DEFINITION, DTRTvCommonUtil.getPlatformResourceURI((IResource)pageDefinitionFile));
        }
        return null;
    }

    @Override
    public PageDefinition loadRegisteredPageDefinition(URI pageDefinitionURI) throws Exception {
        return this.loadRegisteredElement(ElementType.PAGE_DEFINITION, pageDefinitionURI);
    }

    @Override
    public Application loadRegisteredApplication(IFile applicationFile) throws Exception {
        if (applicationFile != null) {
            return this.loadRegisteredElement(ElementType.APPLICATION, DTRTvCommonUtil.getPlatformResourceURI((IResource)applicationFile));
        }
        return null;
    }

    @Override
    public PageDefinition getPageDefinition(boolean create) {
        this.checkInitilisedWithEARWebProjects();
        this.checkBoundSource();
        Application application = this.getApplication(create);
        return application != null ? this.getPageDefinition(application, create) : null;
    }

    @Override
    public Map<Application, List<IPageDefinition.IBoundSource>> getApplications(PageDefinition pageDefinition) {
        this.checkInitilisedWithEARWebProjects();
        if (this.isManagedElement(pageDefinition)) {
            LinkedHashMap<Application, List<IPageDefinition.IBoundSource>> map = new LinkedHashMap<Application, List<IPageDefinition.IBoundSource>>(5);
            String fullName = pageDefinition.getFullName();
            if (fullName != null) {
                HashSet<String> boundSourcePaths = new HashSet<String>(5);
                for (Application application : this.getApplications()) {
                    List<IPageDefinition.IBoundSource> boundSources;
                    PageDefinitionUsage usage = application.getPageDefinitionUsageWithPath(fullName);
                    if (usage == null || (boundSources = this.computeRegisteredBoundSources(application, pageDefinition, boundSourcePaths)) == null) continue;
                    map.put(application, boundSources);
                }
                if (!map.isEmpty()) {
                    return Collections.unmodifiableMap(map);
                }
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public List<? extends DataControl> getDataControls() {
        return Collections.unmodifiableList(this.findDataControls(null, null));
    }

    public List<ADFmRegistry> getRegistries() {
        List<ADFmRegistry> registries = this.getManagedElements(ElementType.REGISTRY);
        if (registries.isEmpty()) {
            if (this.initializedWithModelProject()) {
                ADFmRegistry registry = this.getRegistry(LocatorUtil.getADFmRegistryFile((IProject)this.modelProject), false);
                if (registry != null) {
                    registries = new ArrayList<ADFmRegistry>(1);
                    registries.add(registry);
                }
            } else {
                List registryFiles = LocatorUtil.getADFmRegistryFiles((IProject)this.earProject, (IProject)this.webProject);
                registries = new ArrayList<ADFmRegistry>(registryFiles.size());
                for (IFile registryFile : registryFiles) {
                    ADFmRegistry registry = this.getRegistry(registryFile, false);
                    if (registry == null) continue;
                    registries.add(registry);
                }
            }
            if (!registries.isEmpty()) {
                registries = Collections.unmodifiableList(registries);
            }
        }
        return registries;
    }

    @Override
    protected boolean manageNewADFmRegistries(IResourceDelta rootDelta) {
        if (this.initializedWithModelProject()) {
            return this.modelProject.isAccessible() ? this.manageNewADFmRegistry(rootDelta, LocatorUtil.getADFmRegistryFile((IProject)this.modelProject)) : false;
        }
        boolean managed = false;
        if (this.earProject.isAccessible() && this.webProject.isAccessible()) {
            List registryFiles = LocatorUtil.getADFmRegistryFiles((IProject)this.earProject, (IProject)this.webProject);
            for (IFile registryFile : registryFiles) {
                managed |= this.manageNewADFmRegistry(rootDelta, registryFile);
            }
        }
        return managed;
    }

    private boolean manageNewADFmRegistry(IResourceDelta rootDelta, IFile registryFile) {
        IResourceDelta resourceDelta;
        if (registryFile != null && this.getManagedRegistry(registryFile) == null && (resourceDelta = rootDelta.findMember(registryFile.getFullPath())) != null && resourceDelta.getKind() == 1) {
            return this.getRegistry(registryFile, false) != null;
        }
        return false;
    }

    private ADFmRegistry getManagedRegistry(IFile file) {
        if (file != null) {
            for (ADFmRegistry registry : this.getManagedElements(ElementType.REGISTRY)) {
                if (!file.equals((Object)registry.getFile())) continue;
                return registry;
            }
        }
        return null;
    }

    public ADFmRegistry getLocalRegistry(boolean create) {
        ADFmRegistry registry;
        if (!this.getRegistries().isEmpty() && this.isLocalRegistry(registry = this.getRegistries().get(0))) {
            return registry;
        }
        return create ? (this.initializedWithModelProject() ? this.getRegistry(LocatorUtil.getADFmRegistryFile((IProject)this.modelProject), create) : this.getRegistry((IFile)LocatorUtil.getADFmRegistryFiles((IProject)this.earProject, (IProject)this.webProject).get(0), create)) : null;
    }

    private boolean isLocalRegistry(ADFmRegistry registry) {
        return registry != null && this.getProject().equals((Object)registry.getFile().getProject());
    }

    private ADFmRegistry getRegistry(IFile file, boolean create) {
        ADFmRegistry registry = null;
        if (file != null) {
            if (this.isAccessible(file)) {
                registry = this.initializeElement(ElementType.REGISTRY, file, false);
            } else if (create) {
                registry = this.initializeElement(ElementType.REGISTRY, file, true);
                ElementType.initializeCreatedElement((Object)registry, null);
            }
            if (registry != null) {
                this.manage((Object)registry);
            }
        }
        return registry;
    }

    @Override
    public Configuration getLocalConfiguration(boolean create) {
        ADFmRegistry registry = this.getLocalRegistry(create);
        if (registry != null) {
            List<String> paths = registry.getConfigurationPaths();
            for (String path : paths) {
                Configuration configuration2;
                IFile file = JavaUtil.getSourceFile((IProject)registry.getFile().getProject(), (String)path, (boolean)true, (String)"adfmsrc");
                for (Configuration configuration2 : this.getManagedElements(ElementType.CONFIGURATION)) {
                    if (!file.equals((Object)ElementType.getElementData(configuration2).getFile())) continue;
                    return configuration2;
                }
                configuration2 = this.initializeElement(ElementType.CONFIGURATION, file, false);
                if (configuration2 == null) continue;
                this.manage(configuration2);
                return configuration2;
            }
            if (create) {
                return this.createConfiguration(DEFAULT_CONFIGURATION);
            }
        }
        return null;
    }

    public Configuration getConfiguration(String sFullName, boolean create) {
        ADFmRegistry registry2;
        assert (sFullName != null);
        Collection<Configuration> managedConfigurations = this.getManagedElements(ElementType.CONFIGURATION, sFullName);
        for (Configuration configuration : managedConfigurations) {
            if (!this.isFromManagerProject(configuration)) continue;
            return configuration;
        }
        if (!create) {
            if (!managedConfigurations.isEmpty()) {
                return managedConfigurations.iterator().next();
            }
            for (ADFmRegistry registry2 : this.getRegistries()) {
                Configuration configuration = this.findConfiguration(registry2, sFullName);
                if (configuration == null) continue;
                this.manage(configuration);
                return configuration;
            }
            return null;
        }
        registry2 = this.getLocalRegistry(true);
        Configuration configuration = this.findConfiguration(registry2, sFullName);
        if (configuration != null) {
            this.manage(configuration);
        } else {
            configuration = this.createConfiguration(sFullName);
        }
        return configuration;
    }

    private Configuration createConfiguration(String sFullName) {
        ADFmRegistry registry = this.getLocalRegistry(true);
        IFile configurationFile = JavaUtil.getClasspathEntryFile((IProject)registry.getFile().getProject(), (String)sFullName, (String)ElementType.CONFIGURATION.getFileExtension(), (boolean)true, (String)"adfmsrc");
        Configuration configuration = this.initializeElement(ElementType.CONFIGURATION, configurationFile, true);
        if (configuration != null) {
            ElementType.initializeCreatedElement(configuration, sFullName);
            String registryPath = JavaUtil.computeSourcePath((IFile)configurationFile, (String)"adfmsrc");
            assert (registryPath != null);
            registry.addConfigurationReference(registryPath);
            this.manage(configuration);
        }
        return configuration;
    }

    private Configuration findConfiguration(ADFmRegistry registry, String sFullName) {
        for (String configurationPath : registry.getConfigurationPaths()) {
            String fullName;
            Configuration configuration;
            IFile configurationFile = JavaUtil.getSourceFile((IProject)registry.getFile().getProject(), (String)configurationPath, (boolean)false, (String)"adfmsrc");
            if (configurationFile == null || (configuration = this.initializeElement(ElementType.CONFIGURATION, configurationFile, false)) == null || (fullName = configuration.getFullName()) == null || !sFullName.equals(configuration.getFullName())) continue;
            return configuration;
        }
        return null;
    }

    private List<DataControl> findDataControls(String dataControlName, String dataControlPath) {
        ArrayList<DataControl> dataControls = new ArrayList<DataControl>();
        for (ADFmRegistry registry : this.getRegistries()) {
            List<String> configurationPaths = registry.getConfigurationPaths();
            if (configurationPaths.isEmpty()) continue;
            for (Configuration configuration : this.getManagedElements(ElementType.CONFIGURATION)) {
                String configurationPath = registry.getPath(configurationPaths, configuration);
                if (configurationPath == null) continue;
                configurationPaths.remove(configurationPath);
                if (dataControlName != null || dataControlPath != null) {
                    DataControl dataControl = this.findDataControl(configuration, dataControlName, dataControlPath);
                    if (dataControl == null) continue;
                    dataControls.add(dataControl);
                    return dataControls;
                }
                dataControls.addAll(configuration.getDataControls());
            }
            for (String configurationPath : configurationPaths) {
                String fullName;
                Configuration configuration;
                IFile configurationFile = JavaUtil.getSourceFile((IProject)registry.getFile().getProject(), (String)configurationPath, (boolean)false, (String)"adfmsrc");
                if (configurationFile == null || (configuration = this.initializeElement(ElementType.CONFIGURATION, configurationFile, false)) == null || (fullName = configuration.getFullName()) == null) continue;
                if (dataControlName != null || dataControlPath != null) {
                    DataControl dataControl = this.findDataControl(configuration, dataControlName, dataControlPath);
                    if (dataControl == null) continue;
                    this.manage(configuration);
                    dataControls.add(dataControl);
                    return dataControls;
                }
                this.manage(configuration);
                dataControls.addAll(configuration.getDataControls());
            }
        }
        return dataControls;
    }

    private DataControl findDataControl(Configuration configuration, String dataControlName, String dataControlPath) {
        if (dataControlName != null) {
            return configuration.findDataControl(dataControlName);
        }
        if (dataControlPath != null) {
            for (DataControl dataControl : configuration.getDataControls()) {
                if (!dataControlPath.equals(dataControl.getReferencePath())) continue;
                return dataControl;
            }
        }
        return null;
    }

    public DataControl getDataControl(String sName) {
        List<DataControl> dataControls = this.findDataControls(sName, null);
        return dataControls.isEmpty() ? null : dataControls.get(0);
    }

    @Override
    public DataControl getDataControlByPath(String sPath) {
        List<DataControl> dataControls = this.findDataControls(null, sPath);
        return dataControls.isEmpty() ? null : dataControls.get(0);
    }

    public Application getApplication(boolean create) {
        return this.getApplication(null, create);
    }

    public Application getApplication(String sFullName, boolean create) {
        ADFmRegistry registry;
        this.checkInitilisedWithEARWebProjects();
        Application application = null;
        if (sFullName != null) {
            application = (Application)DTRTUtil.getFirstElement(this.getManagedElements(ElementType.APPLICATION, sFullName));
        } else {
            for (Application app : this.getManagedElements(ElementType.APPLICATION)) {
                if (this.isValidUnnamedApplication(app)) {
                    application = app;
                    break;
                }
                if (application != null) continue;
                application = app;
            }
        }
        if (application == null && (registry = this.getLocalRegistry(create)) != null) {
            application = this.findApplication(registry, sFullName);
            if (application == null && create) {
                application = this.createApplication(sFullName);
            }
            if (application != null) {
                this.manage(application);
            }
        }
        return application;
    }

    private boolean isValidUnnamedApplication(Application application) {
        assert (application != null);
        if (this.boundSource == null) {
            return true;
        }
        PageMap pageMap = application.getPageMap();
        if (pageMap != null) {
            for (PageMapEntry entry : pageMap.getEntries()) {
                String path = entry.getPath();
                if (!this.boundSource.getPagePath().equals(path)) continue;
                return true;
            }
        }
        return false;
    }

    private Application createApplication(String sFullName) {
        ADFmRegistry registry;
        IFile applicationFile;
        Application application;
        if (sFullName == null) {
            sFullName = DEFAULT_APPLICATION;
        }
        if ((application = this.initializeElement(ElementType.APPLICATION, applicationFile = JavaUtil.getClasspathEntryFile((IProject)(registry = this.getLocalRegistry(true)).getFile().getProject(), (String)sFullName, (String)ElementType.APPLICATION.getFileExtension(), (boolean)true, (String)"adfmsrc"), true)) != null) {
            String applicationPath = JavaUtil.computeSourcePath((IFile)applicationFile, (String)"adfmsrc");
            assert (applicationPath != null);
            registry.addApplicationReference(applicationPath);
            ElementType.initializeCreatedElement(application, sFullName);
        }
        return application;
    }

    private Application findApplication(ADFmRegistry registry, String sFullName) {
        if (sFullName != null) {
            Application application;
            String applicationPath;
            IFile applicationFile = JavaUtil.getClasspathEntryFile((IProject)registry.getFile().getProject(), (String)sFullName, (String)ElementType.APPLICATION.getFileExtension(), (boolean)false, (String)"adfmsrc");
            if (applicationFile != null && registry.findApplicationReference(applicationPath = JavaUtil.computeSourcePath((IFile)applicationFile, (String)"adfmsrc")) != null && (application = this.initializeElement(ElementType.APPLICATION, applicationFile, false)) != null && sFullName.equals(application.getFullName())) {
                return application;
            }
            return null;
        }
        Application application = null;
        List<String> paths = registry.getApplicationPaths();
        for (String path : paths) {
            IFile applicationFile = JavaUtil.getSourceFile((IProject)registry.getFile().getProject(), (String)path, (boolean)false, (String)"adfmsrc");
            if (applicationFile == null) {
                throw new IllegalStateException(String.format("The registry has an application path that cannot be located%n(registry:'%s' - path:'%s')", registry.getFile(), path));
            }
            Application app = this.initializeElement(ElementType.APPLICATION, applicationFile, false);
            if (this.isValidUnnamedApplication(app)) {
                application = app;
                return application;
            }
            if (application != null) continue;
            application = app;
        }
        return application;
    }

    public List<Application> getApplications() {
        List<String> applicationPaths;
        this.checkInitilisedWithEARWebProjects();
        ADFmRegistry registry = this.getLocalRegistry(false);
        if (registry != null && !(applicationPaths = registry.getApplicationPaths()).isEmpty()) {
            HashMap<String, Application> applicationMap = new HashMap<String, Application>(applicationPaths.size());
            ArrayList<String> applicationPathsCopy = new ArrayList<String>(applicationPaths);
            for (Application application : this.getManagedElements(ElementType.APPLICATION)) {
                String applicationPath = registry.getPath(applicationPaths, application);
                assert (applicationPath != null);
                assert (applicationPaths.contains(applicationPath)) : applicationPath;
                applicationPaths.remove(applicationPath);
                applicationMap.put(applicationPath, application);
            }
            for (String applicationPath : applicationPaths) {
                Application application;
                IFile applicationFile = JavaUtil.getSourceFile((IProject)registry.getFile().getProject(), (String)applicationPath, (boolean)false, (String)"adfmsrc");
                if (applicationFile == null || (application = this.initializeElement(ElementType.APPLICATION, applicationFile, false)) == null) continue;
                applicationMap.put(applicationPath, application);
                this.manage(application);
            }
            if (!applicationMap.isEmpty()) {
                ArrayList<Application> applications = new ArrayList<Application>(applicationMap.size());
                for (String applicationPath : applicationPathsCopy) {
                    applications.add((Application)applicationMap.get(applicationPath));
                }
                return applications;
            }
        }
        return new ArrayList<Application>(0);
    }

    @Override
    public List<? extends PageDefinition> getPageDefinitions() {
        LinkedHashMap map = new LinkedHashMap();
        for (Application application : this.getApplications()) {
            for (PageDefinition pageDefinition : this.getPageDefinitions(application)) {
                this.putIfAbsent(map, pageDefinition);
            }
        }
        return DTRTUtil.toUnmodifiablePrunedList(map.values());
    }

    private <T> boolean putIfAbsent(Map<URI, T> map, T element) {
        URI uri = this.getElementURI(element);
        if (uri != null && !map.containsKey(uri)) {
            map.put(uri, element);
            return true;
        }
        return false;
    }

    @Override
    public List<? extends PageDefinition> getPageDefinitions(Application application) {
        HashMap pageDefinitionUsages = application.getPageDefinitionUsages();
        if (pageDefinitionUsages != null) {
            Collection usages = pageDefinitionUsages.values();
            LinkedHashMap map = new LinkedHashMap();
            for (PageDefinitionUsage pageDefinitionUsage : usages) {
                String pageDefinitionFullName = pageDefinitionUsage.getPath();
                PageDefinition pageDefinition = (PageDefinition)DTRTUtil.getFirstElement(this.getManagedElements(ElementType.PAGE_DEFINITION, pageDefinitionFullName));
                if (pageDefinition == null) {
                    pageDefinition = this.getPageDefinition(application, pageDefinitionUsage, pageDefinitionFullName, false);
                }
                this.putIfAbsent(map, pageDefinition);
            }
            return DTRTUtil.toUnmodifiablePrunedList(map.values());
        }
        return Collections.emptyList();
    }

    public PageDefinition getPageDefinition(Application application, boolean create) {
        if (application != null) {
            String fullName;
            PageDefinitionUsage pageDefinitionUsage;
            this.checkInitilisedWithEARWebProjects();
            this.checkManaged((BaseElementObject)application);
            this.checkBoundSource();
            String usageId = application.findPageMapEntry(this.boundSource.getPagePath());
            if (usageId != null && (pageDefinitionUsage = application.findPageDefinitionUsage(usageId)) != null) {
                String pageDefinitionFullName = pageDefinitionUsage.getPath();
                PageDefinition pageDefinition = (PageDefinition)DTRTUtil.getFirstElement(this.getManagedElements(ElementType.PAGE_DEFINITION, pageDefinitionFullName));
                if (pageDefinition == null) {
                    pageDefinition = this.getPageDefinition(application, pageDefinitionUsage, pageDefinitionFullName, create);
                }
                if (pageDefinition != null) {
                    return pageDefinition;
                }
            }
            if (create && (fullName = this.computeUniquePageDefinitionFullName()) != null) {
                PageDefinition pageDefinition = (PageDefinition)DTRTUtil.getFirstElement(this.getManagedElements(ElementType.PAGE_DEFINITION, fullName));
                assert (pageDefinition == null);
                PageDefinitionUsage pageDefinitionUsage2 = application.getPageDefinitionUsageWithPath(fullName);
                pageDefinition = this.getPageDefinition(application, pageDefinitionUsage2, fullName, true);
                return pageDefinition;
            }
        }
        return null;
    }

    public String computeUniquePageDefinitionFullName() {
        this.checkBoundSource();
        String fullName = this.getBoundSource().getPreferredPageDefinitionFullName();
        if (fullName != null) {
            IFile pageDefinitionFile;
            String aux = fullName;
            int counter = 0;
            while (this.isAccessible(pageDefinitionFile = JavaUtil.getClasspathEntryFile((IProject)this.getProject(), (String)aux, (String)ElementType.PAGE_DEFINITION.getFileExtension(), (boolean)true, (String)"adfmsrc"))) {
                aux = String.valueOf(fullName) + "_" + ++counter;
            }
            return aux;
        }
        return null;
    }

    public PageDefinition getPageDefinition(String sFullName, boolean create) {
        this.checkInitilisedWithEARWebProjects();
        PageDefinition pageDefinition = (PageDefinition)DTRTUtil.getFirstElement(this.getManagedElements(ElementType.PAGE_DEFINITION, sFullName));
        if (pageDefinition == null) {
            Application application = null;
            PageDefinitionUsage pageDefinitionUsage = null;
            for (Application app : this.getApplications()) {
                PageDefinitionUsage usage = app.getPageDefinitionUsageWithPath(sFullName);
                if (usage != null) {
                    application = app;
                    pageDefinitionUsage = usage;
                    break;
                }
                if (application != null) continue;
                application = app;
            }
            pageDefinition = this.getPageDefinition(application, pageDefinitionUsage, sFullName, create);
        }
        return pageDefinition;
    }

    private PageDefinition getPageDefinition(Application application, PageDefinitionUsage pageDefinitionUsage, String sFullName, boolean create) {
        assert (sFullName != null);
        PageDefinition pageDefinition = null;
        ADFmRegistry registry = this.getLocalRegistry(false);
        if (registry != null) {
            IFile pageDefinitionFile = JavaUtil.getClasspathEntryFile((IProject)registry.getFile().getProject(), (String)sFullName, (String)ElementType.PAGE_DEFINITION.getFileExtension(), (boolean)true, (String)"adfmsrc");
            if (pageDefinitionUsage != null && this.isAccessible(pageDefinitionFile)) {
                pageDefinition = this.initializeElement(ElementType.PAGE_DEFINITION, pageDefinitionFile, false);
            }
        }
        boolean newApplication = false;
        if (pageDefinition == null && create) {
            this.checkBoundSource();
            String usageId = null;
            if (application == null) {
                application = this.createApplication(null);
                newApplication = true;
                if (pageDefinitionUsage == null) {
                    usageId = DTRTvUtil.computePageDefinitionUsageId(application, false);
                }
            } else if (pageDefinitionUsage == null) {
                usageId = DTRTvUtil.computePageDefinitionUsageId(application, true);
            }
            if (pageDefinitionUsage == null) {
                pageDefinitionUsage = application.createPageDefinitionUsage();
                try {
                    pageDefinitionUsage.setId(usageId);
                }
                catch (PropertyVetoException e) {
                    throw new RuntimeException(e);
                }
                pageDefinitionUsage.setPath(sFullName);
                application.addPageDefinitionUsage(pageDefinitionUsage);
            } else {
                usageId = pageDefinitionUsage.getId();
            }
            application.addPageMapEntry(this.boundSource.getPagePath(), usageId);
            registry = this.getLocalRegistry(false);
            assert (registry != null);
            IFile pageDefinitionFile = JavaUtil.getClasspathEntryFile((IProject)registry.getFile().getProject(), (String)sFullName, (String)ElementType.PAGE_DEFINITION.getFileExtension(), (boolean)true, (String)"adfmsrc");
            pageDefinition = this.initializeElement(ElementType.PAGE_DEFINITION, pageDefinitionFile, true);
            ElementType.initializeCreatedElement(pageDefinition, sFullName);
            pageDefinitionUsage.setPageDefinition(pageDefinition);
        }
        if (pageDefinition != null) {
            this.manage(pageDefinition);
            if (newApplication) {
                this.manage(application);
            }
        }
        return pageDefinition;
    }

    public DataControl getDataControl(Application application, String dcName) {
        String path;
        this.checkManaged((BaseElementObject)application);
        Element dcUsageElement = application.findDataControlElement(dcName);
        if (dcUsageElement != null && !DTRTUtil.isEmpty((String)(path = dcUsageElement.getAttributeNS(null, "path")))) {
            return this.getDataControlByPath(path);
        }
        return null;
    }

    @Override
    public void registerUnknownElementObjectFactories(PageDefinition pageDefinition) {
        Set<String> namespaces = this.getNamespaces(pageDefinition);
        for (String namespace : namespaces) {
            try {
                FactoryManager.getInstance().findFactory(namespace);
            }
            catch (Exception exception) {
                FactoryManager.getInstance().registerFactory(this.getUnsupportedElementObjectFactory(namespace));
            }
        }
    }

    private ElementObjectFactory getUnsupportedElementObjectFactory(String namespace) {
        UnsupportedElementObjectFactory factory = new UnsupportedElementObjectFactory(namespace);
        return factory;
    }

    private Set<String> getNamespaces(PageDefinition pageDefinition) {
        HashSet<String> namespaces = new HashSet<String>();
        this.collectNamespaces(pageDefinition.getDocument().getDocumentElement(), true, namespaces);
        return namespaces;
    }

    private void collectNamespaces(Element element, boolean isDocumentElement, Set<String> namespaces) {
        if (!isDocumentElement && element.hasAttribute(BaseObject.XML_NAMESPACE_TAG)) {
            namespaces.add(element.getAttribute(BaseObject.XML_NAMESPACE_TAG));
        }
        int i = 0;
        while (i < element.getChildNodes().getLength()) {
            Node childNode = element.getChildNodes().item(i);
            if (childNode instanceof Element) {
                Element child = (Element)childNode;
                this.collectNamespaces(child, false, namespaces);
            }
            ++i;
        }
    }

    @Override
    protected void handleAboutToBeDeleted(Object element, IFile file) throws Exception {
        if (!this.getProject().equals((Object)file.getProject())) {
            throw new IllegalArgumentException("Cannot delete an element from another project (element file: " + file + " - current project: " + this.getProject());
        }
        if (element instanceof PageDefinition) {
            this.removePageDefinitionFromApplication((PageDefinition)element);
        } else if (element instanceof Application) {
            this.removeApplicationFromRegistry((Application)element);
            this.unmanageAllPageDefinitions((Application)element);
        } else if (element instanceof Configuration) {
            this.removeConfigurationFromRegistry((Configuration)element);
        } else if (element instanceof ADFmRegistry) {
            this.unmanageAllApplications((ADFmRegistry)((Object)element));
            this.unmanageAllConfigurations((ADFmRegistry)((Object)element));
        }
    }

    private void unmanageAllConfigurations(ADFmRegistry registry) {
        List<String> configurationPaths = registry.getConfigurationPaths();
        for (Configuration configuration : this.getManagedElements(ElementType.CONFIGURATION)) {
            String path = registry.getPath(configurationPaths, configuration);
            if (path == null) continue;
            this.unmanage(configuration);
            configurationPaths.remove(path);
            if (configurationPaths.isEmpty()) break;
        }
    }

    private void unmanageAllApplications(ADFmRegistry registry) {
        List<String> applicationPaths = registry.getApplicationPaths();
        for (Application application : this.getManagedElements(ElementType.APPLICATION)) {
            String path = registry.getPath(applicationPaths, application);
            if (path == null) continue;
            this.unmanage(application);
            applicationPaths.remove(path);
            if (applicationPaths.isEmpty()) break;
        }
    }

    private void unmanageAllPageDefinitions(Application application) {
        for (PageDefinitionUsage pageDefinitionUsage : application.getPageDefinitionUsages().values()) {
            this.unmanage((PageDefinition)DTRTUtil.getFirstElement(this.getManagedElements(ElementType.PAGE_DEFINITION, pageDefinitionUsage.getPath())));
        }
    }

    private void removePageDefinitionFromApplication(PageDefinition pageDefinition) throws Exception {
        String fullName = pageDefinition.getFullName();
        if (fullName != null) {
            for (Application application : this.getApplications()) {
                PageDefinitionUsage usage = application.getPageDefinitionUsageWithPath(fullName);
                if (usage == null) continue;
                application.removePageMapEntriesWithUsageId(usage.getId());
                application.removePageDefinitionUsage(usage);
                if (!this.isEmpty(application)) continue;
                this.delete(application);
            }
        }
    }

    private void removeApplicationFromRegistry(Application application) throws Exception {
        String path;
        ADFmRegistry registry = this.getLocalRegistry(false);
        if (registry != null && (path = registry.getPath(application)) != null) {
            registry.removeApplicationReference(path);
            if (this.isEmpty(registry)) {
                this.delete((Object)registry);
            }
        }
    }

    private void removeConfigurationFromRegistry(Configuration configuration) throws Exception {
        String path;
        ADFmRegistry registry = this.getLocalRegistry(false);
        if (registry != null && (path = registry.getPath(configuration)) != null) {
            registry.removeConfigurationReference(path);
            if (this.isEmpty(registry)) {
                this.delete((Object)registry);
            }
        }
    }

    private boolean isEmpty(Application application) {
        return application.getPageDefinitionUsages().isEmpty();
    }

    private boolean isEmpty(ADFmRegistry registry) {
        return registry.getDocument() == null || registry.getApplicationPaths().isEmpty() && registry.getConfigurationPaths().isEmpty();
    }

    private boolean isFromManagerProject(Object element) {
        assert (this.getProject() != null);
        IFile file = this.getElementFile(element);
        return file != null && file.getProject().equals((Object)this.getProject());
    }

    @Override
    public WebApplication getWebApplication() {
        if (this.initializedWithEARWebProjects()) {
            IResource resource;
            IContainer webContentContainer;
            WebApplication webApplication = null;
            for (WebApplication webApp : this.getManagedElements(ElementType.WEB_APPLICATION)) {
                if (!this.getProject().equals((Object)webApp.getFile().getProject())) continue;
                webApplication = webApp;
                break;
            }
            if (webApplication == null && (webContentContainer = ProjectUtils.getWebContentContainer((IProject)this.getProject())) != null && (resource = webContentContainer.findMember((IPath)new Path("WEB-INF/web.xml"))) instanceof IFile) {
                webApplication = this.initializeElement(ElementType.WEB_APPLICATION, (IFile)resource, false);
                this.manage((Object)webApplication);
            }
            if (webApplication != null) {
                return webApplication;
            }
        }
        return null;
    }

    @Override
    protected boolean shouldBeSourceFile(Object element) {
        return element != null && !(element instanceof WebApplication);
    }

    @Override
    public List<? extends IFileMarker> getAccessibleDeclarations(Object element) {
        return element instanceof Configuration ? this.getAccessibleDeclarations((Configuration)element) : (element instanceof Application ? this.getAccessibleDeclarations((Application)element) : (element instanceof PageDefinition ? this.getAccessibleDeclarations((PageDefinition)element) : Collections.emptyList()));
    }

    private List<? extends IFileMarker> getAccessibleDeclarations(Configuration configuration) {
        if (this.isManagedElement(configuration)) {
            IFile configurationFile = this.getElementFile(configuration);
            assert (configurationFile != null);
            for (ADFmRegistry registry : this.getRegistries()) {
                String configurationPath;
                Node reference;
                IFile file;
                String sFullName;
                IFile registryFile;
                if (!configurationFile.getProject().equals((Object)registry.getFile().getProject()) || !this.isAccessible(registryFile = this.getElementFile((Object)registry)) || (sFullName = configuration.getFullName()) == null || (file = JavaUtil.getClasspathEntryFile((IProject)registry.getFile().getProject(), (String)sFullName, (String)ElementType.CONFIGURATION.getFileExtension(), (boolean)false, (String)"adfmsrc")) == null || (reference = registry.findConfigurationReference(configurationPath = JavaUtil.computeSourcePath((IFile)file, (String)"adfmsrc"))) == null) continue;
                return Collections.singletonList(DTRTvUtil.createTextFileMarker(registryFile, reference));
            }
        }
        return Collections.emptyList();
    }

    private List<? extends IFileMarker> getAccessibleDeclarations(Application application) {
        if (this.isManagedElement(application)) {
            String applicationPath;
            Node reference;
            IFile applicationFile;
            String sFullName;
            ADFmRegistry registry = this.getLocalRegistry(false);
            assert (registry != null) : application;
            IFile registryFile = this.getElementFile((Object)registry);
            if (this.isAccessible(registryFile) && (sFullName = application.getFullName()) != null && (applicationFile = JavaUtil.getClasspathEntryFile((IProject)registry.getFile().getProject(), (String)sFullName, (String)ElementType.APPLICATION.getFileExtension(), (boolean)false, (String)"adfmsrc")) != null && (reference = registry.findApplicationReference(applicationPath = JavaUtil.computeSourcePath((IFile)applicationFile, (String)"adfmsrc"))) != null) {
                return Collections.singletonList(DTRTvUtil.createTextFileMarker(registryFile, reference));
            }
        }
        return Collections.emptyList();
    }

    private List<? extends IFileMarker> getAccessibleDeclarations(PageDefinition pageDefinition) {
        this.checkInitilisedWithEARWebProjects();
        if (this.isManagedElement(pageDefinition)) {
            ArrayList<IFileMarker> fileMarkers = new ArrayList<IFileMarker>(5);
            String fullName = pageDefinition.getFullName();
            if (fullName != null) {
                for (Application application : this.getApplications()) {
                    IFile applicationFile;
                    List<? extends PageDefinitionUsage> pageDefinitionUsages;
                    PageDefinitionUsage usage = application.getPageDefinitionUsageWithPath(fullName);
                    if (usage == null || (pageDefinitionUsages = this.getPageDefinitionUsages(application, pageDefinition)).isEmpty() || !this.isAccessible(applicationFile = this.getElementFile(application))) continue;
                    for (PageDefinitionUsage pageDefinitionUsage : pageDefinitionUsages) {
                        fileMarkers.add(DTRTvUtil.createTextFileMarker(applicationFile, pageDefinitionUsage.getElement()));
                    }
                }
                if (!fileMarkers.isEmpty()) {
                    return Collections.unmodifiableList(fileMarkers);
                }
            }
        }
        return Collections.emptyList();
    }

    @Override
    public IType findType(String className) throws CoreException {
        IType type = this.getTypeHelper().findType(this.getProject(), className);
        if (type != null && type.exists()) {
            IProject typeProject = type.getJavaProject().getProject();
            if (this.getProject().equals((Object)typeProject)) {
                return type;
            }
            if (this.initializedWithEARWebProjects()) {
                Set projects = WtpProjectUtil.findProjectsReferencedByEar((IProject)this.getEARProject());
                if (projects.contains(typeProject)) {
                    return type;
                }
            } else {
                return type;
            }
        }
        return null;
    }

    @Override
    public BeanStructure getBeanStructure(String sFullName, boolean create) {
        return this.getClasspathElement(ElementType.BEAN_STRUCTURE, sFullName, create);
    }

    private <E> E getClasspathElement(ElementType<E> elementType, String fullName, boolean create) {
        assert (fullName != null);
        assert (elementType != null);
        Collection<E> managedElements = this.getManagedElements(elementType, fullName);
        if (!managedElements.isEmpty()) {
            E firstElement = null;
            for (E element : managedElements) {
                if (this.isFromManagerProject(element)) {
                    return element;
                }
                if (firstElement != null) continue;
                firstElement = element;
            }
            return firstElement;
        }
        E element = this.findClasspathElement(elementType, this.getProject(), fullName);
        if (element == null && this.initializedWithEARWebProjects()) {
            for (IProject project : WtpProjectUtil.findProjectsReferencedByEar((IProject)this.getEARProject())) {
                if (!this.getProject().equals((Object)project) && (element = this.findClasspathElement(elementType, project, fullName)) != null) break;
            }
        }
        if (element != null) {
            this.manage(element);
        } else if (create) {
            IFile file = JavaUtil.getClasspathEntryFile((IProject)this.getProject(), (String)fullName, (String)elementType.getFileExtension(), (boolean)true, (String)"adfmsrc");
            element = this.initializeElement(elementType, file, true);
            if (elementType == ElementType.BEAN_STRUCTURE) {
                this.handleBuiltInBeanStructure((BeanStructure)element, fullName);
            }
            ElementType.initializeCreatedElement(element, fullName);
            this.manage(element);
        }
        return element;
    }

    private <E> E findClasspathElement(ElementType<E> elementType, IProject project, String sFullName) {
        E element;
        IFile file = JavaUtil.getClasspathEntryFile((IProject)project, (String)sFullName, (String)elementType.getFileExtension(), (boolean)false, (String)"adfmsrc");
        if (this.isAccessible(file) && (element = this.initializeElement(elementType, file, false)) != null) {
            assert (file.getProject().equals((Object)project)) : project + " - " + file;
            ElementType.setFullName(element, sFullName);
            return element;
        }
        return null;
    }

    private void handleBuiltInBeanStructure(BeanStructure beanStructure, String sFullName) {
        if (BUILT_IN_BEAN_STRUCTURE_FULL_NAMES.contains(sFullName)) {
            Path path = new Path(BUILT_IN_BEAN_STRUCTURES_FOLDER + sFullName + '.' + ElementType.BEAN_STRUCTURE.getFileExtension());
            InputStream inputStream = null;
            try {
                try {
                    inputStream = FileLocator.openStream((Bundle)Platform.getBundle((String)"oracle.eclipse.tools.adf.dtrt.v110101"), (IPath)path, (boolean)false);
                    assert (inputStream != null);
                    Document loadedDocument = ManagedXMLFile.getDocumentBuilder().parse(inputStream);
                    assert (loadedDocument.getDocumentElement() != null) : sFullName;
                    Element loadedElement = loadedDocument.getDocumentElement();
                    assert (loadedElement != null) : sFullName;
                    Document beanStructureDocument = beanStructure.getDocument();
                    beanStructureDocument.removeChild(beanStructureDocument.getDocumentElement());
                    beanStructureDocument.adoptNode(loadedElement);
                    beanStructureDocument.appendChild(loadedElement);
                    assert (beanStructureDocument.getDocumentElement() == loadedElement) : sFullName;
                    beanStructure.initializeFromElement(beanStructure.getTransactionManager(), beanStructureDocument.getDocumentElement());
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to load build-in bean structure " + sFullName, e);
            }
        }
    }
}

