/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl;

import java.util.ArrayList;
import java.util.List;
import oracle.adfdt.model.objects.Application;
import oracle.adfdt.model.objects.BaseElementObject;
import oracle.adfdt.model.objects.Configuration;
import oracle.adfdt.transaction.ConditionalTask;
import oracle.adfdt.transaction.FetchingTask;
import oracle.adfdt.transaction.Task;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.JavaUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.DTRTBaseElementObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.ElementData;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.ElementType;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ADFmRegistry
extends DTRTBaseElementObject {
    public ADFmRegistry(IFile file) {
        super(file);
    }

    public String getXMLElementTag() {
        return "MetadataDirectory";
    }

    public String getNameSpaceUrl() {
        return "http://xmlns.oracle.com/adfm/metainf";
    }

    @Override
    protected String computeFullName() {
        String path = JavaUtil.computeSourcePath((IFile)this.getFile(), (String)"adfmsrc");
        String fileExtension = this.getFile().getFileExtension();
        if (!DTRTUtil.isEmpty((String)fileExtension)) {
            path = path.substring(0, path.length() - (1 + fileExtension.length()));
        }
        return path.replace('/', '.');
    }

    public void addConfigurationReference(String path) {
        this.addReference("DataControlRegistry", path, "addConfigurationReference");
    }

    public Node findConfigurationReference(String path) {
        return this.findReference("DataControlRegistry", path);
    }

    public List<String> getConfigurationPaths() {
        return this.getReferencePaths("DataControlRegistry");
    }

    public void removeConfigurationReference(String path) {
        this.removeReference("DataControlRegistry", path, "removeConfigurationReference");
    }

    public void addApplicationReference(String path) {
        this.addReference("DataBindingRegistry", path, "addApplicationReference");
    }

    public Node findApplicationReference(String path) {
        return this.findReference("DataBindingRegistry", path);
    }

    public List<String> getApplicationPaths() {
        return this.getReferencePaths("DataBindingRegistry");
    }

    public void removeApplicationReference(String path) {
        this.removeReference("DataBindingRegistry", path, "removeApplicationReference");
    }

    private void checkState() {
        if (this.getDocument() == null || this.getDocument().getDocumentElement() == null) {
            throw new IllegalStateException("The registry has to be initialized");
        }
    }

    private void addReference(final String referenceType, final String path, String transName) {
        if (path != null) {
            this.checkState();
            ConditionalTask conditionalTask = new ConditionalTask(){

                public boolean canRun() {
                    return ADFmRegistry.this.findReference(referenceType, path) == null;
                }
            };
            Task task = new Task(){

                public void run() {
                    Element reference = ADFmRegistry.this.createElement(ADFmRegistry.this.getNameSpaceUrl(), referenceType);
                    reference.setAttribute("path", path);
                    ADFmRegistry.this.getElement().appendChild(reference);
                }
            };
            this.getTransactionManager().runTaskUnderTransactionForCondition(transName, conditionalTask, task);
        }
    }

    private Node findReference(final String referenceType, final String path) {
        if (path != null) {
            this.checkState();
            FetchingTask task = new FetchingTask(){

                public Node run() {
                    NodeList regs = ADFmRegistry.this.getElementsByTagNameNS(ADFmRegistry.this.getNameSpaceUrl(), referenceType);
                    if (regs != null && regs.getLength() > 0) {
                        int i = 0;
                        while (i < regs.getLength()) {
                            Node reference = regs.item(i);
                            if (path.equals(ADFmRegistry.this.getPathAttribute(reference))) {
                                return reference;
                            }
                            ++i;
                        }
                    }
                    return null;
                }
            };
            return (Node)this.getTransactionManager().fetchUnderReadLock(task);
        }
        return null;
    }

    private void removeReference(final String referenceType, final String path, String transName) {
        if (path != null) {
            this.checkState();
            ConditionalTask conditionalTask = new ConditionalTask(){

                public boolean canRun() {
                    return ADFmRegistry.this.findReference(referenceType, path) != null;
                }
            };
            Task task = new Task(){

                public void run() {
                    NodeList referenceList = ADFmRegistry.this.getElementsByTagNameNS(ADFmRegistry.this.getNameSpaceUrl(), referenceType);
                    if (referenceList != null && referenceList.getLength() > 0) {
                        int i = 0;
                        while (i < referenceList.getLength()) {
                            Node reference = referenceList.item(i);
                            if (path.equals(ADFmRegistry.this.getPathAttribute(reference))) {
                                ADFmRegistry.this.getElement().removeChild(reference);
                            }
                            ++i;
                        }
                    }
                }
            };
            this.getTransactionManager().runTaskUnderTransactionForCondition(transName, conditionalTask, task);
        }
    }

    private List<String> getReferencePaths(final String referenceType) {
        this.checkState();
        FetchingTask task = new FetchingTask(){

            public List<String> run() {
                ArrayList<String> references = new ArrayList<String>();
                NodeList referenceList = ADFmRegistry.this.getElementsByTagNameNS(ADFmRegistry.this.getNameSpaceUrl(), referenceType);
                if (referenceList != null && referenceList.getLength() > 0) {
                    int i = 0;
                    while (i < referenceList.getLength()) {
                        Node reference = referenceList.item(i);
                        String path = ADFmRegistry.this.getPathAttribute(reference);
                        if (path != null) {
                            references.add(path);
                        }
                        ++i;
                    }
                }
                return references;
            }
        };
        return (List)this.getTransactionManager().fetchUnderReadLock(task);
    }

    private String getPathAttribute(Node reference) {
        return this.sanitizePath(reference.getAttributes().getNamedItem("path").getNodeValue());
    }

    private String sanitizePath(String path) {
        return path != null && path.length() > 1 && path.charAt(0) == '/' ? path.substring(1) : path;
    }

    public String getPath(Configuration configuration) {
        return this.getPath((BaseElementObject)configuration, "DataControlRegistry");
    }

    public String getPath(Application application) {
        return this.getPath((BaseElementObject)application, "DataBindingRegistry");
    }

    private String getPath(BaseElementObject element, String referenceType) {
        String elementPath;
        List<String> paths;
        ElementData elementData = ElementType.getElementData(element);
        if (elementData != null && elementData.getFile().getProject().equals((Object)this.getFile().getProject()) && !(paths = this.getReferencePaths(referenceType)).isEmpty() && paths.contains(elementPath = JavaUtil.computeSourcePath((IFile)elementData.getFile(), (String)"adfmsrc"))) {
            return elementPath;
        }
        return null;
    }

    public String getPath(List<String> configurationPaths, Configuration configuration) {
        return this.getPath(configurationPaths, (BaseElementObject)configuration);
    }

    public String getPath(List<? extends String> applicationPaths, Application application) {
        return this.getPath(applicationPaths, (BaseElementObject)application);
    }

    private String getPath(List<? extends String> paths, BaseElementObject element) {
        String elementPath;
        ElementData elementData;
        if (paths != null && !paths.isEmpty() && (elementData = ElementType.getElementData(element)) != null && elementData.getFile().getProject().equals((Object)this.getFile().getProject()) && paths.contains(elementPath = JavaUtil.computeSourcePath((IFile)elementData.getFile(), (String)"adfmsrc"))) {
            return elementPath;
        }
        return null;
    }
}

