/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.manager;

import oracle.adfdt.model.datacontrols.JUDTAdapterDataControl;
import oracle.adfdt.transaction.ConditionalTask;
import oracle.adfdt.transaction.FetchingTask;
import oracle.adfdt.transaction.Task;
import oracle.adfdt.transaction.TransactionManager;
import oracle.adfinternal.model.adapter.ejb.EjbDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.DTRTBaseElementObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.IObjectTranslator;
import oracle.eclipse.tools.common.util.Pair;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebApplication
extends DTRTBaseElementObject {
    private static final String DEFAULT_NAMESPACE_URI = "http://java.sun.com/xml/ns/javaee";
    private static final String ADF_BINDING_FILTER_CLASS = "oracle.adf.model.servlet.ADFBindingFilter";
    private static final String OLD_ADF_BINDING_FILTER_CLASS = "oracle.adf.share.http.ServletADFFilter";
    private static final String FILTER = "filter";
    private static final String FILTER_NAME = "filter-name";
    private static final String FILTER_CLASS = "filter-class";
    private static final String FILTER_MAPPING = "filter-mapping";
    private static final String DEFAULT_FILTER_NAME = "adfBindings";
    private static final String SERVLET_NAME = "servlet-name";
    private static final String DISPATCHER = "dispatcher";
    private static final String FORWARD = "FORWARD";
    private static final String REQUEST = "REQUEST";
    private static final String EJB_LOCAL_REF = "ejb-local-ref";
    private static final String EJB_REF_NAME = "ejb-ref-name";
    private static final String EJB_REF_TYPE = "ejb-ref-type";
    private static final String LOCAL = "local";
    private static final String EJB_LINK = "ejb-link";
    private String namespaceURI;

    public static boolean configureForADFBindings(IDTRTManager manager, boolean add) {
        WebApplication webApplication;
        if (manager != null && (webApplication = manager.getWebApplication()) != null) {
            boolean modified = false;
            if (add) {
                modified = webApplication.removeNonADFBindingsAndFilterMapping();
                modified |= webApplication.addADFBindingsFilterAndFilterMapping();
            } else {
                modified = webApplication.addNonADFBindingsAndFilterMapping();
                modified |= webApplication.removeADFBindingsFilterAndFilterMapping();
            }
            return modified;
        }
        return false;
    }

    public static boolean configureForDataControlObject(IDTRTManager manager, IObjectTranslator translator, IDataControlObject dataControlObject) {
        EJBInfo ejbInfo;
        WebApplication webApplication;
        if (manager != null && translator != null && dataControlObject != null && (webApplication = manager.getWebApplication()) != null && (ejbInfo = WebApplication.computeEJBInfo(translator, dataControlObject)) != null) {
            return webApplication.addEJBReference(ejbInfo);
        }
        return false;
    }

    private static EJBInfo computeEJBInfo(IObjectTranslator translator, IDataControlObject dataControlObject) {
        NodeList childList;
        Node node;
        Object object;
        IDataControl dataControl = DTRTObjectUtil.getDataControl((IDataControlObject)dataControlObject);
        if (dataControl != null && (object = translator.toADFObject((IObject)dataControl)) instanceof JUDTAdapterDataControl && (object = ((JUDTAdapterDataControl)object).getNativeDataControlDefinition()) instanceof EjbDefinition && (node = ((EjbDefinition)object).getMetadata()) instanceof Element && (childList = node.getChildNodes()) != null) {
            int i = 0;
            while (i < childList.getLength()) {
                String interfaceName;
                String name;
                NamedNodeMap attributes;
                Node child = childList.item(i);
                if (child instanceof Element && "ejb-definition".equals(child.getLocalName()) && "http://xmlns.oracle.com/adfm/adapter/ejb".equals(child.getNamespaceURI()) && LOCAL.equals(WebApplication.getAttributeValue(attributes = child.getAttributes(), "ejb-interface-type")) && "Session".equals(WebApplication.getAttributeValue(attributes, "ejb-type")) && (name = WebApplication.getAttributeValue(attributes, "ejb-name")) != null && (interfaceName = WebApplication.getAttributeValue(attributes, "ejb-business-interface")) != null) {
                    return new EJBInfo(name, interfaceName);
                }
                ++i;
            }
        }
        return null;
    }

    private static String getAttributeValue(NamedNodeMap attributes, String attName) {
        Node att = attributes.getNamedItem(attName);
        return att != null ? att.getNodeValue() : null;
    }

    public WebApplication(IFile file) {
        super(file);
    }

    public void initializeFromElement(TransactionManager manager, Element element) {
        super.initializeFromElement(manager, element);
        this.namespaceURI = element.getNamespaceURI();
    }

    public String getXMLElementTag() {
        return "web-app";
    }

    public String getNameSpaceUrl() {
        return this.namespaceURI != null ? this.namespaceURI : DEFAULT_NAMESPACE_URI;
    }

    public boolean addNonADFBindingsAndFilterMapping() {
        return this.addFilterAndFilterMapping(OLD_ADF_BINDING_FILTER_CLASS);
    }

    public boolean addADFBindingsFilterAndFilterMapping() {
        return this.addFilterAndFilterMapping(ADF_BINDING_FILTER_CLASS);
    }

    private boolean addFilterAndFilterMapping(final String filterClassName) {
        final String[] adfBindingsFilterName = new String[1];
        final Boolean[] modified = new Boolean[]{Boolean.FALSE};
        ConditionalTask conditionalTask1 = new ConditionalTask(){

            public boolean canRun() {
                Pair pair = WebApplication.this.findADFBindingFilter(filterClassName);
                if (pair != null) {
                    adfBindingsFilterName[0] = (String)pair.getSecond();
                    return false;
                }
                return true;
            }
        };
        Task task1 = new Task(){

            public void run() {
                adfBindingsFilterName[0] = WebApplication.DEFAULT_FILTER_NAME;
                Element filter = WebApplication.this.createElement(WebApplication.this.getNameSpaceUrl(), WebApplication.FILTER);
                Element filterName = WebApplication.this.createElement(WebApplication.this.getNameSpaceUrl(), WebApplication.FILTER_NAME);
                filterName.setTextContent(adfBindingsFilterName[0]);
                filter.appendChild(filterName);
                Element filterClass = WebApplication.this.createAndAddElement(WebApplication.this.getNameSpaceUrl(), WebApplication.FILTER_CLASS);
                filterClass.setTextContent(filterClassName);
                filter.appendChild(filterClass);
                WebApplication.this.getElement().insertBefore(filter, WebApplication.this.findInsertionPoint());
                modified[0] = Boolean.TRUE;
            }
        };
        this.getTransactionManager().runTaskUnderTransactionForCondition("addFilter" + filterClassName, conditionalTask1, task1);
        ConditionalTask conditionalTask2 = new ConditionalTask(){

            public boolean canRun() {
                return WebApplication.this.findFilterMapping(adfBindingsFilterName[0]) == null;
            }
        };
        Task task2 = new Task(){

            public void run() {
                Element filterMap = WebApplication.this.createElement(WebApplication.this.getNameSpaceUrl(), WebApplication.FILTER_MAPPING);
                Element filterName = WebApplication.this.createElement(WebApplication.this.getNameSpaceUrl(), WebApplication.FILTER_NAME);
                filterName.setTextContent(adfBindingsFilterName[0]);
                filterMap.appendChild(filterName);
                Element servlet = WebApplication.this.createAndAddElement(WebApplication.this.getNameSpaceUrl(), WebApplication.SERVLET_NAME);
                servlet.setTextContent("Faces Servlet");
                filterMap.appendChild(servlet);
                Element dispatcher1 = WebApplication.this.createAndAddElement(WebApplication.this.getNameSpaceUrl(), WebApplication.DISPATCHER);
                dispatcher1.setTextContent(WebApplication.FORWARD);
                filterMap.appendChild(dispatcher1);
                Element dispatcher2 = WebApplication.this.createAndAddElement(WebApplication.this.getNameSpaceUrl(), WebApplication.DISPATCHER);
                dispatcher2.setTextContent(WebApplication.REQUEST);
                filterMap.appendChild(dispatcher2);
                WebApplication.this.getElement().insertBefore(filterMap, WebApplication.this.findInsertionPoint());
                modified[0] = Boolean.TRUE;
            }
        };
        this.getTransactionManager().runTaskUnderTransactionForCondition("addFilterMapping" + filterClassName, conditionalTask2, task2);
        return modified[0];
    }

    public boolean removeADFBindingsFilterAndFilterMapping() {
        return this.removeADFBindingsFilterAndFilterMapping(ADF_BINDING_FILTER_CLASS);
    }

    public boolean removeNonADFBindingsAndFilterMapping() {
        return this.removeADFBindingsFilterAndFilterMapping(OLD_ADF_BINDING_FILTER_CLASS);
    }

    private boolean removeADFBindingsFilterAndFilterMapping(final String filterClassName) {
        final String[] adfBindingsFilterName = new String[1];
        final Boolean[] modified = new Boolean[]{Boolean.FALSE};
        Task task1 = new Task(){

            public void run() {
                Pair pair = WebApplication.this.findADFBindingFilter(filterClassName);
                if (pair != null) {
                    adfBindingsFilterName[0] = (String)pair.getSecond();
                    Element element = (Element)pair.getFirst();
                    element.getParentNode().removeChild(element);
                    modified[0] = Boolean.TRUE;
                }
            }
        };
        this.getTransactionManager().runTaskUnderTransaction("removeFilter" + filterClassName, task1);
        if (adfBindingsFilterName[0] != null) {
            Task task2 = new Task(){

                public void run() {
                    Element element = WebApplication.this.findFilterMapping(adfBindingsFilterName[0]);
                    if (element != null) {
                        element.getParentNode().removeChild(element);
                        modified[0] = Boolean.TRUE;
                    }
                }
            };
            this.getTransactionManager().runTaskUnderTransaction("removeFilterMapping" + filterClassName, task2);
        }
        return modified[0];
    }

    private Pair<Element, String> findADFBindingFilter(final String filterClassName) {
        FetchingTask task = new FetchingTask(){

            public Pair<Element, String> run() {
                NodeList filterClasses = WebApplication.this.getElementsByTagNameNS(WebApplication.this.getNameSpaceUrl(), WebApplication.FILTER_CLASS);
                if (filterClasses != null && filterClasses.getLength() > 0) {
                    int i = 0;
                    while (i < filterClasses.getLength()) {
                        Node filterClass = filterClasses.item(i);
                        if (filterClassName.equals(filterClass.getTextContent().trim()) && filterClass.getParentNode().getNodeName().equals(WebApplication.FILTER)) {
                            NodeList children = filterClass.getParentNode().getChildNodes();
                            int j = 0;
                            while (i < children.getLength()) {
                                String filterName;
                                Node child = children.item(j);
                                if (child.getNodeType() == 1 && child.getNodeName().equals(WebApplication.FILTER_NAME) && (filterName = child.getTextContent().trim()).length() > 0) {
                                    return new Pair((Object)((Element)child.getParentNode()), (Object)child.getTextContent().trim());
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                return null;
            }
        };
        return (Pair)this.getTransactionManager().fetchUnderReadLock(task);
    }

    private Element findFilterMapping(final String adfFilterName) {
        FetchingTask task = new FetchingTask(){

            public Element run() {
                NodeList filterMaps = WebApplication.this.getElementsByTagNameNS(WebApplication.this.getNameSpaceUrl(), WebApplication.FILTER_MAPPING);
                if (filterMaps != null && filterMaps.getLength() > 0) {
                    int i = 0;
                    while (i < filterMaps.getLength()) {
                        Node filterMap = filterMaps.item(i);
                        NodeList children = filterMap.getChildNodes();
                        int j = 0;
                        while (j < children.getLength()) {
                            Node child = children.item(j);
                            if (child != null && child.getNodeType() == 1 && child.getNodeName().equals(WebApplication.FILTER_NAME) && child.getTextContent().trim().equals(adfFilterName)) {
                                return (Element)filterMap;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                return null;
            }
        };
        return (Element)this.getTransactionManager().fetchUnderReadLock(task);
    }

    private Node findInsertionPoint() {
        FetchingTask task = new FetchingTask(){

            public Node run() {
                NodeList servlets = WebApplication.this.getElementsByTagNameNS(WebApplication.this.getNameSpaceUrl(), "servlet");
                if (servlets != null && servlets.getLength() > 0) {
                    return servlets.item(0);
                }
                return null;
            }
        };
        return (Node)this.getTransactionManager().fetchUnderReadLock(task);
    }

    public boolean addEJBReference(final EJBInfo ejbInfo) {
        if (ejbInfo != null) {
            final Boolean[] added = new Boolean[]{Boolean.FALSE};
            ConditionalTask conditionalTask = new ConditionalTask(){

                public boolean canRun() {
                    NodeList ejbLocalRefs = WebApplication.this.getElementsByTagNameNS(WebApplication.this.getNameSpaceUrl(), WebApplication.EJB_LOCAL_REF);
                    int i = 0;
                    while (i < ejbLocalRefs.getLength()) {
                        Element ref = (Element)ejbLocalRefs.item(i);
                        Element ejbRefName = this.getFirstChildElementByName(ref, WebApplication.EJB_REF_NAME);
                        if (ejbRefName != null && ejbRefName.getTextContent().equals(ejbInfo.getRefName())) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }

                private Element getFirstChildElementByName(Element parent, String childElementName) {
                    NodeList nodes = parent.getElementsByTagName(childElementName);
                    if (nodes != null && nodes.getLength() > 0) {
                        return (Element)nodes.item(0);
                    }
                    return null;
                }
            };
            Task addEjbLocalRefTask = new Task(){

                public void run() {
                    Element ejbLocalRef = WebApplication.this.createElement(WebApplication.this.getNameSpaceUrl(), WebApplication.EJB_LOCAL_REF);
                    WebApplication.this.appendChild(ejbLocalRef);
                    Element element = WebApplication.this.createElement(WebApplication.this.getNameSpaceUrl(), WebApplication.EJB_REF_NAME);
                    element.setTextContent(ejbInfo.getRefName());
                    ejbLocalRef.appendChild(element);
                    element = WebApplication.this.createElement(WebApplication.this.getNameSpaceUrl(), WebApplication.EJB_REF_TYPE);
                    element.setTextContent(ejbInfo.getType());
                    ejbLocalRef.appendChild(element);
                    element = WebApplication.this.createElement(WebApplication.this.getNameSpaceUrl(), WebApplication.LOCAL);
                    element.setTextContent(ejbInfo.getInterfaceName());
                    ejbLocalRef.appendChild(element);
                    element = WebApplication.this.createElement(WebApplication.this.getNameSpaceUrl(), WebApplication.EJB_LINK);
                    element.setTextContent(ejbInfo.getName());
                    ejbLocalRef.appendChild(element);
                    added[0] = Boolean.TRUE;
                }
            };
            this.getTransactionManager().runTaskUnderTransactionForCondition("addEjbLocalRef: " + ejbInfo.name, conditionalTask, addEjbLocalRefTask);
            return added[0];
        }
        return false;
    }

    private static class EJBInfo {
        private final String name;
        private final String interfaceName;

        public EJBInfo(String name, String interfaceName) {
            assert (name != null);
            assert (interfaceName != null);
            this.name = name;
            this.interfaceName = interfaceName;
        }

        public String getName() {
            return this.name;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public String getType() {
            return "Session";
        }

        public String getRefName() {
            return "ejb/local/" + this.getName();
        }
    }
}

