/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.manager;

import java.beans.PropertyVetoException;
import oracle.adfdt.model.objects.BaseElementObject;
import org.eclipse.core.resources.IFile;

public abstract class DTRTBaseElementObject
extends BaseElementObject {
    private IFile file;
    private String id;
    private String fullName;
    private Object object;

    protected DTRTBaseElementObject(IFile file) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this.file = file;
    }

    public void dispose() {
        this.file = null;
        this.object = null;
    }

    public boolean isDisposed() {
        return this.file != null;
    }

    public final IFile getFile() {
        return this.file;
    }

    public void setNodeObjectAsObject(Object managedFile) {
        this.object = managedFile;
    }

    public Object getNodeObjectAsObject() {
        return this.object;
    }

    public final void setId(String text) throws PropertyVetoException {
        this.id = text;
    }

    public final String getId() {
        if (this.id == null) {
            this.id = this.getFullName();
        }
        return this.id;
    }

    protected String computeFullName() {
        String path = this.getFile().getProjectRelativePath().removeFileExtension().toString();
        return path.replace('/', '.');
    }

    protected void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public final String getFullName() {
        return this.fullName == null ? (this.fullName = this.computeFullName()) : this.fullName;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName());
        builder.append(" [file=").append(this.file).append(", id=").append(this.id).append("]");
        return builder.toString();
    }
}

