/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.facade.command;

import java.util.List;
import oracle.adf.controller.internal.dtrt.binding.DTTaskFlowBinding;
import oracle.adfdt.model.objects.ActionBindingReference;
import oracle.adfdt.model.objects.Application;
import oracle.adfdt.model.objects.BaseElementObject;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdt.model.objects.DTFactory;
import oracle.adfdt.model.objects.Executable;
import oracle.adfdt.model.objects.Factory;
import oracle.adfdt.model.objects.IteratorBinding;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IExecutable;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.vbundle.CreatableType;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DTRTvContextUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.DeleteCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IBaseObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.WebApplication;
import oracle.eclipse.tools.adf.dtrt.vcommon.command.CreateCommandImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.EditorLabelMessages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.w3c.dom.Element;

public final class CreateCommand
extends CreateCommandImpl {
    private DTFactory taskFlowDTFactory;
    private Factory taskFlowFactory;
    private boolean addedADFBindingsFilterAndFilterMapping;

    public void dispose() {
        this.taskFlowDTFactory = null;
        this.taskFlowFactory = null;
        this.addedADFBindingsFilterAndFilterMapping = false;
        super.dispose();
    }

    public CreateCommand(IOEPEExecutableContext context) {
        super(context);
    }

    protected CreateCommand instantiate() {
        return new CreateCommand(this.getCommandStack());
    }

    public String getLabel() {
        return CreatableType.PAGE_DEFINITION_TYPES.indexOf((Object)this.getType()) == 0 ? Messages.createPageDefinition : super.getLabel();
    }

    public CreateCommandImpl setType(IDescribable type) {
        assert (type == null || type instanceof CreatableType);
        return super.setType(type);
    }

    public CreatableType getType() {
        return (CreatableType)super.getType();
    }

    public CreateCommandImpl setParent(IObject parent) {
        assert (parent == null || parent instanceof oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.PageDefinition);
        return super.setParent(parent);
    }

    public oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.PageDefinition getParent() {
        return (oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.PageDefinition)super.getParent();
    }

    protected void assertExecution() throws Exception {
        super.assertExecution();
        IOEPEExecutableContext context = this.getCommandStack();
        IPageDefinition pageDefinition = DTRTvContextUtil.getPageDefinition((IOEPEContext)context);
        DTRTUtil.assertTrue((DTRTvContextUtil.getManager((IOEPEContext)context) != null ? 1 : 0) != 0, (String)"Invalid context.");
        if (this.isPageDefinitionCreatableType() && context instanceof IWebPageContext) {
            IDTRTManager manager = DTRTvContextUtil.getManager((IOEPEContext)context);
            DTRTUtil.assertTrue((pageDefinition == null ? 1 : 0) != 0, (String)"The page definition exists and cannot be created again %s", (Object[])new Object[]{manager.getBoundSource()});
            DTRTUtil.assertTrue((context.getAccessibleFile((IObject)pageDefinition) == null ? 1 : 0) != 0, (String)"PageDefinition file exists and cannot be created for %s", (Object[])new Object[]{manager.getBoundSource()});
        } else {
            String objectId;
            DTRTUtil.assertTrue((pageDefinition != null ? 1 : 0) != 0, (String)"The page definition must exist when creating a binding object.");
            Class<?> realType = this.getType().getType();
            if (!IteratorBinding.class.isAssignableFrom(realType)) {
                DTRTUtil.assertTrue((boolean)ControlBinding.class.isAssignableFrom(realType), (String)"The create command can only create page definitions or binding objects (type: %s).", (Object[])new Object[]{realType});
                DTRTUtil.assertTrue((!Executable.class.isAssignableFrom(realType) || ActionBindingReference.class.isAssignableFrom(realType) || DTTaskFlowBinding.class.isAssignableFrom(realType) ? 1 : 0) != 0, (String)"The create command can only create ActionBindingReference and TaskFlow executables (type: %s).", (Object[])new Object[]{realType});
            }
            if ((objectId = this.getObjectId()) != null) {
                DTRTUtil.assertTrue((objectId.indexOf(59) < 0 ? 1 : 0) != 0, (String)"Invalid id (%s)", (Object[])new Object[]{objectId});
                DTRTUtil.assertTrue((objectId.indexOf(46) < 0 || objectId.lastIndexOf(46) < objectId.length() - 1 ? 1 : 0) != 0, (String)"Invalid id (%s)", (Object[])new Object[]{objectId});
                this.checkObjectId(context, CreatableType.getObjectType(this.getType()), objectId);
            }
        }
    }

    private boolean isPageDefinitionCreatableType() {
        return CreatableType.PAGE_DEFINITION_TYPES.indexOf((Object)this.getType()) >= 0;
    }

    private void checkObjectId(IOEPEExecutableContext context, Class<? extends IObject> objectType, String objectId) {
        IStatus idStatus = DTRTvContextUtil.isValidObjectId(objectType, objectId);
        if (!idStatus.isOK()) {
            throw new IllegalStateException(idStatus.getMessage());
        }
        if (!this.isUniqueId(DTRTObjectUtil.getBindingObjects((IPageDefinition)DTRTvContextUtil.getPageDefinition((IOEPEContext)context)), objectId)) {
            throw new IllegalStateException(EditorLabelMessages.EMFObjectManager_id_uniqueness);
        }
    }

    private boolean isUniqueId(List<? extends IObject> objects, String objectId) {
        for (IObject iObject : objects) {
            if (iObject.getId() == null || !iObject.getId().equals(objectId)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doExecute(IProgressMonitor monitor) throws Exception {
        IOEPEExecutableContext executableContext = this.getCommandStack();
        IDTRTManager manager = DTRTvContextUtil.getManager((IOEPEContext)executableContext);
        if (this.isPageDefinitionCreatableType()) {
            manager.getPageDefinition(true);
            this.objectCreated();
            return;
        } else {
            String id;
            oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.PageDefinition pageDefinition = this.getParent();
            if (pageDefinition == null) {
                this.setParent((IObject)DTRTvContextUtil.getPageDefinition((IOEPEContext)this.getCommandStack()));
                pageDefinition = this.getParent();
            }
            if ((id = this.getObjectId()) == null) {
                id = DTRTvContextUtil.computeUniqueId((IOEPEContext)this.getCommandStack(), CreatableType.getObjectType(this.getType()), null, null);
            }
            ControlBinding controlBinding = null;
            IBaseObject.CachedProperty property = null;
            String subType = this.getType().getFactorySubType();
            PageDefinition dtrtPageDefinition = (PageDefinition)this.getParent().getDecoratedObject();
            if (IteratorBinding.class.isAssignableFrom(this.getType().getType())) {
                IteratorBinding iteratorBinding = dtrtPageDefinition.createIteratorBinding(subType);
                iteratorBinding.setId(id);
                dtrtPageDefinition.addIterator(iteratorBinding);
                controlBinding = iteratorBinding;
                property = IBaseObject.CachedProperty.EXECUTABLES;
            } else if (Executable.class.isAssignableFrom(this.getType().getType())) {
                ActionBindingReference executable = null;
                if (ActionBindingReference.class.isAssignableFrom(this.getType().getType())) {
                    executable = dtrtPageDefinition.createActionBindingReference();
                } else if (DTTaskFlowBinding.class.isAssignableFrom(this.getType().getType())) {
                    this.ensureTaskFlowBindingFactoriesInstalled(DTRTvUtil.getFirstApplication(manager, dtrtPageDefinition));
                    executable = new DTTaskFlowBinding();
                    Element elem = dtrtPageDefinition.getDocument().createElementNS(executable.getNameSpaceUrl(), executable.getXMLElementTag());
                    executable.initializeFromElement(dtrtPageDefinition.getTransactionManager(), elem);
                }
                if (executable == null) throw new IllegalStateException("Create command failed.");
                executable.setId(id);
                dtrtPageDefinition.addExecutable((Executable)executable);
                controlBinding = executable;
                property = IBaseObject.CachedProperty.EXECUTABLES;
            } else {
                controlBinding = dtrtPageDefinition.createControlBinding(subType, null);
                controlBinding.setId(id);
                dtrtPageDefinition.addControlBinding(controlBinding);
                property = IBaseObject.CachedProperty.BINDINGS;
            }
            pageDefinition.handlePropertyChange(new Object[]{property});
            EList<IExecutable> list = property == IBaseObject.CachedProperty.EXECUTABLES ? pageDefinition.getExecutables() : pageDefinition.getBindings();
            IBindingObject bindingObject = null;
            for (IBindingObject o : list) {
                BaseElementObject element = (BaseElementObject)((IBaseObject)o).getDecoratedObject();
                if (element.getElement() != controlBinding.getElement()) continue;
                bindingObject = o;
                break;
            }
            if (bindingObject == null) {
                throw new IllegalStateException("Create command failed.");
            }
            this.objectCreated();
            this.initializeCreatedObject((IObject)bindingObject);
        }
    }

    private void objectCreated() {
        this.addedADFBindingsFilterAndFilterMapping = WebApplication.configureForADFBindings(DTRTvContextUtil.getManager((IOEPEContext)this.getCommandStack()), true);
    }

    private void ensureTaskFlowBindingFactoriesInstalled(Application application) {
        DTFactory dtfactory;
        Factory factory = application.findFactory("http://xmlns.oracle.com/adf/controller/binding");
        if (factory == null) {
            factory = application.createFactory();
            factory.setNameSpace("http://xmlns.oracle.com/adf/controller/binding");
            factory.setClassName("oracle.adf.controller.internal.binding.TaskFlowBindingDefFactoryImpl");
            application.addFactory(factory);
            this.taskFlowFactory = factory;
        }
        if ((dtfactory = application.findDTFactory("oracle.adf.controller.internal.dtrt.binding.BindingDTObjectFactory")) == null) {
            dtfactory = application.createDTFactory();
            dtfactory.setClassName("oracle.adf.controller.internal.dtrt.binding.BindingDTObjectFactory");
            application.addDTFactory(dtfactory);
            DTRTvUtil.registerDTFactory(dtfactory);
            this.taskFlowDTFactory = dtfactory;
        }
    }

    protected void assertUndo() throws Exception {
        if (this.isPageDefinitionCreatableType()) {
            throw new IllegalStateException("Page definition creation cannot be undone");
        }
        super.assertUndo();
        DTRTUtil.assertTrue((DTRTvContextUtil.getPageDefinition((IOEPEContext)this.getCommandStack()) != null ? 1 : 0) != 0, (String)"The page definition must exist when creating a binding object.");
    }

    protected void doUndo(IProgressMonitor monitor) throws Exception {
        if (this.addedADFBindingsFilterAndFilterMapping) {
            WebApplication.configureForADFBindings(DTRTvContextUtil.getManager((IOEPEContext)this.getCommandStack()), false);
        }
        oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.PageDefinition pageDefinition = this.getParent();
        IBindingObject bindingObject = (IBindingObject)this.getCreatedObject();
        DeleteCommand.doDelete(pageDefinition, bindingObject);
        if (this.taskFlowDTFactory != null) {
            this.taskFlowDTFactory.removeFromParent();
        }
        if (this.taskFlowFactory != null) {
            this.taskFlowFactory.removeFromParent();
        }
    }

    protected void assertRedo() throws Exception {
        if (this.isPageDefinitionCreatableType()) {
            throw new IllegalStateException("Page definition creation cannot be undone");
        }
        super.assertRedo();
        DTRTUtil.assertTrue((DTRTvContextUtil.getPageDefinition((IOEPEContext)this.getCommandStack()) != null ? 1 : 0) != 0, (String)"The page definition must exist when creating a binding object.");
        this.checkObjectId(this.getCommandStack(), CreatableType.getObjectType(this.getType()), this.getObjectId());
    }

    protected void doRedo(IProgressMonitor monitor) throws Exception {
        oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.PageDefinition pageDefinition = this.getParent();
        Application application = null;
        IDTRTManager manager = DTRTvContextUtil.getManager((IOEPEContext)this.getCommandStack());
        if (this.taskFlowFactory != null) {
            application = DTRTvUtil.getFirstApplication(manager, (PageDefinition)pageDefinition.getDecoratedObject());
            application.addFactory(this.taskFlowFactory);
        }
        if (this.taskFlowDTFactory != null) {
            if (application == null) {
                application = DTRTvUtil.getFirstApplication(manager, (PageDefinition)pageDefinition.getDecoratedObject());
            }
            application.addDTFactory(this.taskFlowDTFactory);
        }
        IBindingObject bindingObject = (IBindingObject)this.getCreatedObject();
        DeleteCommand.doAdd(pageDefinition, bindingObject, null);
        if (this.addedADFBindingsFilterAndFilterMapping) {
            WebApplication.configureForADFBindings(manager, false);
        }
    }
}

