/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.editor.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ExecutablePackage;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlHier;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlHierTypeBinding;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.TreeBindingUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.AttributeRowValue;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.InputOverridingObservableListContentProvider;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.ListDiffStrategy;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.SimpleListDiff;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.ValueToListMappingObservableList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.Viewer;

public class TreeBindingAttributeProvider
extends InputOverridingObservableListContentProvider {
    private final ICtrlHier iCtrlHier;

    public TreeBindingAttributeProvider(ICtrlHier iCtrlHier) {
        this.iCtrlHier = iCtrlHier;
    }

    protected IObservableList createNewInput(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof TreeBindingUtil.NodeInfo) {
            TreeBindingUtil.NodeInfo nodeInfo = (TreeBindingUtil.NodeInfo)newInput;
            IObservableValue attrNameList = EMFObservables.observeValue((EObject)this.iCtrlHier, (EStructuralFeature)ExecutablePackage.Literals.ICTRL_HIER__TYPE_BINDINGS);
            TreeBindingListDiffStrategy listDiffStrategy = new TreeBindingListDiffStrategy(this.iCtrlHier, nodeInfo);
            ValueToListMappingObservableList curList = new ValueToListMappingObservableList(Collections.singletonList(attrNameList), (ListDiffStrategy)listDiffStrategy);
            return curList;
        }
        return null;
    }

    public static class TreeBindingListDiffStrategy
    extends ListDiffStrategy<ArrayList> {
        private final TreeBindingUtil.NodeInfo nodeInfo;

        public TreeBindingListDiffStrategy(ICtrlHier iCtrlHier, TreeBindingUtil.NodeInfo nodeInfo) {
            this.nodeInfo = nodeInfo;
        }

        public SimpleListDiff<AttributeRowValue> calculate(List<ArrayList> attrNamesList, List<AttributeRowValue> oldList) {
            SimpleListDiff diff = new SimpleListDiff();
            ICtrlHierTypeBinding iCtrlHierTypeBinding = this.nodeInfo.getBinding();
            String[] attrNames = iCtrlHierTypeBinding.getAttrNames();
            List newList = diff.newList(attrNames.length);
            int i = 0;
            while (i < attrNames.length) {
                String attrName = attrNames[i];
                if (oldList != null && oldList.size() > i) {
                    diff.removed((Object)oldList.get(i), i);
                }
                AttributeRowValue rowValue = new AttributeRowValue(Collections.singletonList(attrName), i);
                newList.add(rowValue);
                diff.added((Object)rowValue, i);
                ++i;
            }
            this.trimNewList(newList, oldList, diff);
            return diff;
        }
    }
}

