/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.editor.provider;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ExecutablePackage;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlList;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.AttributeRowValue;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.InputOverridingObservableListContentProvider;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.ListDiffStrategy;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.SimpleListDiff;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.ValueToListMappingObservableList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.Viewer;

public class ListBindingAttributeProvider
extends InputOverridingObservableListContentProvider {
    protected IObservableList createNewInput(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof ICtrlList) {
            ICtrlList list = (ICtrlList)newInput;
            IObservableValue attrNameList = EMFObservables.observeValue((EObject)list, (EStructuralFeature)ExecutablePackage.Literals.ICTRL_VALUE__ATTR_NAMES);
            IObservableValue listAttrNameList = EMFObservables.observeValue((EObject)list, (EStructuralFeature)ExecutablePackage.Literals.ICTRL_LIST__LIST_ATTR_NAMES);
            ArrayList<IObservableValue> values = new ArrayList<IObservableValue>();
            values.add(attrNameList);
            values.add(listAttrNameList);
            return new ValueToListMappingObservableList(values, (ListDiffStrategy)new ListAttributeMappingListDiffStrategy());
        }
        return null;
    }

    public static class ListAttributeMappingListDiffStrategy
    extends ListDiffStrategy<String[]> {
        public SimpleListDiff<AttributeRowValue> calculate(List<String[]> attrs, List<AttributeRowValue> oldList) {
            assert (attrs.size() == 2);
            SimpleListDiff diff = new SimpleListDiff();
            List newList = diff.newList(4);
            String[] attrNames = attrs.get(0);
            String[] listAttrNames = attrs.get(1);
            if (attrNames != null) {
                int i = 0;
                while (i < attrNames.length) {
                    String listAttrName = null;
                    if (listAttrNames != null && listAttrNames.length > i) {
                        listAttrName = listAttrNames[i];
                    }
                    this.addRowValue(oldList, (SimpleListDiff<AttributeRowValue>)diff, newList, attrNames[i], i, listAttrName);
                    ++i;
                }
                if (listAttrNames != null) {
                    i = attrNames.length;
                    while (i < listAttrNames.length) {
                        this.addRowValue(oldList, (SimpleListDiff<AttributeRowValue>)diff, newList, "", i, listAttrNames[i]);
                        ++i;
                    }
                }
                this.trimNewList(newList, oldList, diff);
            }
            return diff;
        }

        private void addRowValue(List<AttributeRowValue> oldList, SimpleListDiff<AttributeRowValue> diff, List<AttributeRowValue> newList, String attrNames, int i, String listAttrName) {
            if (oldList != null && oldList.size() > i) {
                diff.removed((Object)oldList.get(i), i);
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(attrNames);
            values.add(listAttrName);
            AttributeRowValue addedItem = new AttributeRowValue(values, i);
            newList.add(addedItem);
            diff.added((Object)addedItem, i);
        }
    }
}

