/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.editor.provider;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructuredTypeObject;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DataControlObjectContentProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IBaseElementObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.ADFTypeResolver;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.AttributeRowValue;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.ListDiffStrategy;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.SimpleListDiff;
import org.eclipse.emf.ecore.EStructuralFeature;

public class IteratorAttributeListDiffStrategy
extends ListDiffStrategy<String> {
    private final IBaseElementObject input;
    private final EStructuralFeature feature;

    public IteratorAttributeListDiffStrategy(IBaseElementObject newInput, EStructuralFeature feature) {
        this.input = newInput;
        this.feature = feature;
        if (!IStructuredTypeObject.class.isAssignableFrom(feature.getEType().getInstanceClass())) {
            throw new IllegalArgumentException("feature must be of type IDataControlObject: " + feature);
        }
    }

    public SimpleListDiff<AttributeRowValue> calculate(List<String> newBaseValue, List<AttributeRowValue> oldList) {
        assert (newBaseValue.size() == 1);
        SimpleListDiff diff = new SimpleListDiff();
        IStructuredTypeObject targetBinding = (IStructuredTypeObject)this.input.eGet(this.feature);
        List newList = diff.newList(4);
        if (targetBinding != null) {
            DataControlObjectContentProvider contentProvider = new DataControlObjectContentProvider();
            IDataControlObject[] elements = contentProvider.getChildren((Object)targetBinding);
            int i = 0;
            while (i < elements.length) {
                IDataControlObject element = elements[i];
                if (ADFTypeResolver.INSTANCE.isSimpleTypeAttribute(element)) {
                    AttributeRowValue newValue = new AttributeRowValue(Collections.singletonList(element), i);
                    newList.add(newValue);
                    diff.added((Object)newValue, i);
                }
                ++i;
            }
            this.createClearListDiff((SimpleListDiff<AttributeRowValue>)diff, oldList);
        }
        return diff;
    }

    private void createClearListDiff(SimpleListDiff<AttributeRowValue> diff, List<AttributeRowValue> oldList) {
        if (oldList != null) {
            int i = 0;
            while (i < oldList.size()) {
                diff.removed((Object)oldList.get(i), i);
                ++i;
            }
        }
    }
}

