/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.editor.dialog.advisor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IExecutable;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IStructuredTypeObject;
import oracle.eclipse.tools.adf.dtrt.object.IVariableObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.dialog.advisor.IteratorSelection;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IVariablesIterator;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IteratorBinding;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.PageDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.ObjectImplUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.dialog.advisor.IteratorComboUpdater;
import oracle.eclipse.tools.common.services.util.AbstractMatcher;
import oracle.eclipse.tools.common.services.util.IMatcher;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;

public class DataControlObjectIteratorComboUpdater
extends IteratorComboUpdater {
    public static final IteratorComboUpdater.IteratorComboUpdateFactory FACTORY_INSTANCE = new IteratorComboUpdater.IteratorComboUpdateFactory(){

        public IteratorComboUpdater create(IObservableValue triggeringModel, IPageDefinition pageDef) {
            return new DataControlObjectIteratorComboUpdater(triggeringModel, pageDef);
        }
    };
    private final IMatcher<IExecutable> matcher;

    public DataControlObjectIteratorComboUpdater(IObservableValue triggeringModel, IPageDefinition pageDef) {
        this(triggeringModel, pageDef, null);
    }

    public DataControlObjectIteratorComboUpdater(IObservableValue triggeringModel, IPageDefinition pageDef, IMatcher<IExecutable> matcher) {
        this(Realm.getDefault(), triggeringModel, pageDef, matcher);
    }

    public DataControlObjectIteratorComboUpdater(Realm realm, IObservableValue triggeringModel, IPageDefinition pageDef, IMatcher<IExecutable> matcher) {
        super(realm, triggeringModel, pageDef);
        this.matcher = matcher != null ? matcher : new AbstractMatcher<IExecutable>(){

            public boolean matches(IExecutable testMe) {
                return true;
            }
        };
    }

    protected List<?> calculate() {
        ArrayList<IteratorSelection> newList = Collections.EMPTY_LIST;
        Object value = this.getTriggeringModel().getValue();
        if (value instanceof IStructuredTypeObject && ObjectImplUtil.needsIterator((IStructuredTypeObject)value)) {
            newList = new ArrayList<IteratorSelection>(2);
            IStructuredTypeObject structuredTypeObject = (IStructuredTypeObject)value;
            if (structuredTypeObject instanceof IDataControlObject) {
                this.processDataControlObject(newList, (IDataControlObject)structuredTypeObject);
            } else if (structuredTypeObject instanceof IVariableObject) {
                this.processVariableObject(newList, (IVariableObject)structuredTypeObject);
            }
        }
        return newList;
    }

    private void processVariableObject(List<IteratorSelection> newList, IVariableObject structuredTypeObject) {
        IVariablesIterator variablesIterator;
        if (this.getPageDef() instanceof PageDefinition && (variablesIterator = ((PageDefinition)this.getPageDef()).getVariablesIterator()) != null) {
            newList.add(new IteratorSelection(variablesIterator));
        }
    }

    private void processDataControlObject(List<IteratorSelection> newList, IDataControlObject dataControlObject) {
        int definitionType = ObjectImplUtil.getDefinition((IStructuredTypeObject)dataControlObject);
        for (IExecutable executable : this.getPageDef().getExecutables()) {
            if (!(executable instanceof IteratorBinding) || !this.matcher.matches((Object)executable)) continue;
            IDataControlObject iteratorDataControlObject = executable.getDataControlObject();
            boolean useIterator = false;
            switch (definitionType) {
                case 30: {
                    useIterator = ObjectImplUtil.isValidChild(iteratorDataControlObject, dataControlObject);
                    break;
                }
                case 40: 
                case 100: {
                    useIterator = ObjectImplUtil.arePathsAndTypesSame(iteratorDataControlObject, dataControlObject);
                    break;
                }
                case 60: {
                    useIterator = ObjectImplUtil.isValidOperation(iteratorDataControlObject, dataControlObject);
                }
            }
            if (!useIterator) continue;
            newList.add(new IteratorSelection((IteratorBinding)executable));
        }
    }

    public Object getElementType() {
        return IteratorSelection.class;
    }
}

