/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.adf.model.utils.StandardOperationDef;
import oracle.adfdt.model.datacontrols.AdapterLazyStructure;
import oracle.adfdt.model.datacontrols.AdapterStructureDefinition;
import oracle.adfdt.model.objects.BeanStructure;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.DataControlDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.OperationDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.ui.util.IOpenable;
import oracle.eclipse.tools.adf.dtrt.ui.util.OpenableJavaElement;
import oracle.eclipse.tools.adf.dtrt.ui.util.OpenableResource;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.BasicDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.DTRTContentType;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.util.LRUMap;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.BeanDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.AccessorDefinitionStructureChild;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.AttributeDefinitionStructureChild;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.BaseStructureObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.BasicNamedDefinitionStructureChild;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.NamedDefinitionKey;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.NamedDefinitionStructureObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.OperationDefinitionStructureChild;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureDefinitionStructure;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectType;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;

public final class StructureUtil {
    public static final String PROP_LABEL_KEY = "DTRT_StructureObject_Label";
    private static Map<List<String>, BaseDescriptor> descriptorCache;
    static final BasicDescriptor ADF_STRUCTURE_DESCRIPTOR;

    static {
        ADF_STRUCTURE_DESCRIPTOR = new BasicDescriptor(Messages.adfStructure, Messages.adfStructureToolTipText, (ImageManager.IImageData)DTRTBundleIcon.STRUCTURE);
    }

    private StructureUtil() {
    }

    static BaseDescriptor getDescriptor(String label, String toolTipText, ImageManager.IImageData imageData) {
        if (label != null) {
            List<String> key;
            BaseDescriptor descriptor;
            if (descriptorCache == null) {
                descriptorCache = new LRUMap(20, 2000, 50);
            }
            if ((descriptor = descriptorCache.get(key = Arrays.asList(label, toolTipText, imageData != null ? imageData.getKey() : null))) == null) {
                descriptor = new BasicDescriptor(label, toolTipText, imageData);
                descriptorCache.put(key, descriptor);
            }
            return descriptor;
        }
        return null;
    }

    public static StructureProvider getStructureProvider(IStructureObject structureObject) {
        IStructure structure = DTRTObjectUtil.getStructure((IStructureObject)structureObject);
        return structure instanceof StructureDefinitionStructure ? ((StructureDefinitionStructure)structure).getStructureProvider() : null;
    }

    public static boolean isCollection(IStructureChild structureChild) {
        return structureChild instanceof AccessorDefinitionStructureChild && ((AccessorDefinitionStructureChild)structureChild).isCollection();
    }

    public static NamedDefinition toNamedDefinition(IStructureObject structureObject) {
        return structureObject instanceof NamedDefinitionStructureObject ? (NamedDefinition)((NamedDefinitionStructureObject)structureObject).getNamedDefinition() : null;
    }

    public static List<IStructureChild> findChildren(IStructureObject structureObject, StructureObjectType ... structureObjectTypes) {
        List children;
        if (structureObject != null && structureObjectTypes != null && structureObjectTypes.length > 0 && !(children = structureObject.getChildren()).isEmpty()) {
            ArrayList<IStructureChild> list = new ArrayList<IStructureChild>(children.size());
            for (IStructureChild child : children) {
                StructureObjectType structureObjectType = StructureObjectType.getStructureObjectType((IStructureObject)child);
                if (DTRTUtil.indexOf((Object[])structureObjectTypes, (Object)((Object)structureObjectType)) < 0) continue;
                list.add(child);
            }
            if (!list.isEmpty()) {
                return list;
            }
        }
        return new ArrayList<IStructureChild>(0);
    }

    public static IStructureObject findFirstParent(IStructureChild structureChild, StructureObjectType structureObjectType) {
        if (structureChild != null && structureObjectType != null) {
            IStructureObject parent = structureChild.getParent();
            while (parent != null) {
                StructureObjectType type = StructureObjectType.getStructureObjectType(parent);
                if (type == structureObjectType) {
                    return parent;
                }
                parent = parent.getParent();
            }
        }
        return null;
    }

    public static IStructureChild findFirstChild(IStructureObject structureObject, StructureObjectType structureObjectType) {
        if (structureObject != null && structureObjectType != null) {
            for (IStructureChild child : structureObject.getChildren()) {
                StructureObjectType type = StructureObjectType.getStructureObjectType((IStructureObject)child);
                if (type != structureObjectType) continue;
                return child;
            }
        }
        return null;
    }

    public static BeanStructure getBeanStructure(IStructure structure) {
        NamedDefinition namedDefinition = StructureUtil.toNamedDefinition((IStructureObject)structure);
        return namedDefinition instanceof StructureDefinition ? StructureUtil.getBeanStructure((StructureDefinition)namedDefinition) : null;
    }

    static BeanStructure getBeanStructure(StructureDefinition structureDefinition) {
        return structureDefinition instanceof AdapterStructureDefinition ? ((AdapterStructureDefinition)structureDefinition).getBeanStructure() : (structureDefinition instanceof AdapterLazyStructure ? ((AdapterLazyStructure)structureDefinition).getBeanStructure() : null);
    }

    static String getSourceName(StructureDefinition structureDefinition) {
        if (structureDefinition != null) {
            BeanStructure beanStructure = StructureUtil.getBeanStructure(structureDefinition);
            return beanStructure != null ? beanStructure.getBeanClass() : structureDefinition.getFullName();
        }
        return null;
    }

    static StructureDefinition getStructureDefinition(AccessorDefinition accessorDefinition, boolean collectionStructureDefinition) {
        if (accessorDefinition != null) {
            try {
                return collectionStructureDefinition ? accessorDefinition.getCollectionStructure() : accessorDefinition.getStructure();
            }
            catch (Exception e) {
                DTRTvBundle.log(e);
            }
        }
        return null;
    }

    static IStructure addStructureDefinition(List<IStructure> list, StructureProvider structureProvider, StructureDefinition structureDefinition) {
        if (structureProvider != null && list != null && structureDefinition != null) {
            IStructure structure = structureProvider.getStructure(structureDefinition);
            if (structure != null) {
                list.add(structure);
            }
            return structure;
        }
        return null;
    }

    static void addAttributeDefinitions(IStructureObject parent, List<IStructureChild> list, DefinitionContainer definitionContainer, IStructureChild.StructureChildKind kind) {
        if (parent != null && list != null && definitionContainer != null && !definitionContainer.isEmpty()) {
            for (Object object : definitionContainer) {
                if (!(object instanceof AttributeDefinition)) continue;
                list.add(StructureUtil.createAttributeDefinitionStructureChild(parent, (AttributeDefinition)object, kind));
            }
        }
    }

    static AttributeDefinitionStructureChild createAttributeDefinitionStructureChild(IStructureObject parent, AttributeDefinition attributeDefinition, IStructureChild.StructureChildKind kind) {
        if (parent == null || attributeDefinition == null || kind == null) {
            throw new IllegalArgumentException("No argument can be null");
        }
        AttributeDefinitionStructureChild child = attributeDefinition instanceof AccessorDefinition ? new AccessorDefinitionStructureChild(parent, (AccessorDefinition)attributeDefinition, kind) : new AttributeDefinitionStructureChild(parent, attributeDefinition, kind);
        child.initialize();
        return child;
    }

    static void addBasicNamedDefinitions(IStructureObject parent, List<IStructureChild> list, DefinitionContainer definitionContainer, IStructureChild.StructureChildKind kind) {
        if (parent != null && list != null && definitionContainer != null && !definitionContainer.isEmpty()) {
            for (Object object : definitionContainer) {
                if (!(object instanceof NamedDefinition)) continue;
                BasicNamedDefinitionStructureChild child = new BasicNamedDefinitionStructureChild(parent, (NamedDefinition)object, kind);
                child.initialize();
                list.add(child);
            }
        }
    }

    static void addOperationDefinitions(IStructureObject parent, List<IStructureChild> list, DefinitionContainer definitionContainer, IStructureChild.StructureChildKind kind) {
        if (parent != null && list != null && definitionContainer != null && !definitionContainer.isEmpty()) {
            for (Object object : definitionContainer) {
                OperationDefinitionStructureChild child;
                OperationDefinitionStructureChild operationDefinitionStructureChild = object instanceof StandardOperationDef ? new OperationDefinitionStructureChild(parent, (OperationDefinition)object, IStructureChild.StructureChildKind.IMPLICIT) : (child = object instanceof OperationDefinition ? new OperationDefinitionStructureChild(parent, (OperationDefinition)object, kind) : null);
                if (child == null) continue;
                child.initialize();
                list.add(child);
            }
        }
    }

    static IStructureChild findCorrespondingStructureChild(List<? extends IStructureChild> children, NamedDefinition namedDefinition) {
        for (IStructureChild iStructureChild : children) {
            IStructureChild iStructureChild2;
            if (iStructureChild instanceof NamedDefinitionStructureObject && NamedDefinitionKey.shallowEquals(namedDefinition, ((NamedDefinitionStructureObject)iStructureChild).getNamedDefinition())) {
                return iStructureChild;
            }
            if (iStructureChild == null || (iStructureChild2 = StructureUtil.findCorrespondingStructureChild(iStructureChild.getChildren(), namedDefinition)) == null) continue;
            return iStructureChild2;
        }
        return null;
    }

    static StructureDefinition findParentStructureDefinition(NamedDefinition namedDefinition) {
        Definition definition = namedDefinition.getDefinitionParent();
        while (definition instanceof NamedDefinition) {
            if (definition instanceof AccessorDefinition) {
                return ((AccessorDefinition)definition).getStructure();
            }
            if (definition instanceof DataControlDefinition) {
                return ((DataControlDefinition)definition).getStructure();
            }
            if (definition instanceof StructureDefinition) {
                return (StructureDefinition)definition;
            }
            definition = ((NamedDefinition)definition).getDefinitionParent();
        }
        return null;
    }

    public static IFile getDeclarationFile(IStructureObject structureObject) {
        return structureObject instanceof NamedDefinitionStructureObject ? ((NamedDefinitionStructureObject)structureObject).getDeclarationFile() : null;
    }

    static IOpenable createDeclarationOpenable(IFile declarationFile) {
        return new DeclarationOpenableResource(declarationFile);
    }

    private static String computeTypeLabelForDeclarationFile(IFile declarationFile) {
        if (declarationFile != null) {
            DTRTContentType contentType = DTRTContentType.getDTRTContentType((IFile)declarationFile);
            if (contentType != null) {
                return contentType.getDescriptor().getLabel();
            }
            if (JavaCore.isJavaLikeFileName((String)declarationFile.getName())) {
                return Messages.javaFileOpenable;
            }
        }
        return null;
    }

    static IOpenable createJavaOpenable(IJavaElement javaElement) {
        OpenableJavaElement openable = new OpenableJavaElement(javaElement, false);
        openable.setTypeLabel(Messages.javaOpenable);
        return openable;
    }

    static String getCollectionElementSourceType(IStructureChild structureChild) {
        if (StructureUtil.isCollection(structureChild)) {
            for (IStructure referencedStructure : structureChild.getReferencedStructures()) {
                IStructureChild element = (IStructureChild)DTRTObjectUtil.find((Collection)referencedStructure.getChildren(), (String)"element");
                if (element == null) continue;
                return DTRTUtil.getLabel((IDescriptor)element.getSourceTypeDescriptor());
            }
        }
        return null;
    }

    public static boolean isKnown(IDTRTManager manager, IStructureObject structureObject) {
        return manager != null && manager.getStructureProvider() == StructureUtil.getStructureProvider(structureObject);
    }

    public static <T extends IStructureObject> T getStructureObject(IDTRTManager manager, T externalStructureObject) {
        if (manager != null && !manager.isDisposed() && DTRTObjectUtil.isNotDisposed(externalStructureObject)) {
            NamedDefinition externalNamedDefinition;
            IStructure externalStructure;
            if (StructureUtil.isKnown(manager, externalStructureObject)) {
                return externalStructureObject;
            }
            URI structureObjectURI = externalStructureObject.getURI();
            if (BaseStructureObject.isStructureObjectURI(structureObjectURI) && (externalStructure = DTRTObjectUtil.getStructure(externalStructureObject)) != null && (externalNamedDefinition = StructureUtil.toNamedDefinition((IStructureObject)externalStructure)) instanceof StructureDefinition) {
                StructureDefinition externalStructureDefinition = (StructureDefinition)externalNamedDefinition;
                StructureProvider structureProvider = manager.getStructureProvider();
                StructureDefinitionStructure structure = structureProvider.getCachedStructure(externalStructureDefinition);
                if (structure == null) {
                    BeanStructure externalBeanStructure = StructureUtil.getBeanStructure(externalStructure);
                    if (externalBeanStructure != null) {
                        BeanStructure beanStructure = manager.getBeanStructure(externalBeanStructure.getFullName(), false);
                        if (beanStructure != null) {
                            AdapterLazyStructure structureDefinition = new AdapterLazyStructure(beanStructure.getDesigntimeContext(), null, beanStructure);
                            structure = structureProvider.getStructure((StructureDefinition)structureDefinition);
                        }
                    } else {
                        IType type = (IType)DTRTUtil.getAdapter((IAdaptable)externalStructure, IType.class);
                        if (type != null) {
                            try {
                                StructureDefinition structureDefinition = BeanDataControlProvider.buildStructure(manager.getTypeHelper(), type);
                                structure = structureProvider.getStructure(structureDefinition);
                            }
                            catch (Exception e) {
                                DTRTvBundle.log(e);
                            }
                        }
                    }
                }
                if (structure != null) {
                    IObject object = DTRTObjectUtil.find(Collections.singleton(structure), (URI)structureObjectURI);
                    if (externalStructureObject instanceof IStructure ? object instanceof IStructure : object instanceof IStructureChild) {
                        return (T)((IStructureObject)object);
                    }
                }
            }
        }
        return null;
    }

    private static class DeclarationOpenableResource
    extends OpenableResource {
        public DeclarationOpenableResource(IFile file) {
            super(file);
            String declarationType = StructureUtil.computeTypeLabelForDeclarationFile(file);
            this.setTypeLabel(declarationType != null ? declarationType : Messages.declarationOpenable);
        }
    }
}

