/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1;

import java.util.Collection;
import java.util.Collections;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.AbstractBeanDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.MethodInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.Project;
import org.eclipse.jdt.core.IType;

public final class BeanDataControlProvider {
    private static final IFilter DEFAULT_FILTER = new IFilter(){

        @Override
        public boolean ignoreMethod(ITypeHelper typeHelper, String name, String returnType) {
            return false;
        }

        @Override
        public Collection<String> getIgnoredClassNames() {
            return Collections.emptyList();
        }
    };

    private BeanDataControlProvider() {
    }

    public static StructureDefinition buildStructure(ITypeHelper typeHelper, IType type) throws Exception {
        return BeanDataControlProvider.buildStructure(typeHelper, type, DEFAULT_FILTER);
    }

    public static StructureDefinition buildStructure(ITypeHelper typeHelper, IType type, IFilter filter) throws Exception {
        Project project = new Project(typeHelper, type.getJavaProject());
        DataControlProvider dataControlProvider = new DataControlProvider(typeHelper, filter);
        dataControlProvider.setGenerateCollectionOperations(true);
        StructureDefinition structureDefinition = dataControlProvider.buildStructure(project, type.getFullyQualifiedName());
        project.dispose();
        dataControlProvider.dispose();
        return structureDefinition;
    }

    private static class DataControlProvider
    extends AbstractBeanDataControlProvider {
        private ITypeHelper typeHelper;
        private IFilter filter;

        private DataControlProvider(ITypeHelper typeHelper, IFilter filter) {
            this.typeHelper = typeHelper;
            this.filter = filter;
            for (String className : filter.getIgnoredClassNames()) {
                this.setIgnoredClass(className);
            }
        }

        public void dispose() {
            this.typeHelper = null;
            this.filter = null;
        }

        @Override
        protected boolean ignoredMethod(MethodInfo mi) {
            return super.ignoredMethod(mi) || this.filter.ignoreMethod(this.typeHelper, mi.getName(), mi.type);
        }
    }

    public static interface IFilter {
        public boolean ignoreMethod(ITypeHelper var1, String var2, String var3);

        public Collection<String> getIgnoredClassNames();
    }
}

