/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.builder;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlChild;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.util.ObjectList;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.builder.DataControlObjectTreeBuilder;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IBaseObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.impl.IBaseObjectImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonUtil;

abstract class DataControlObjectFolder<T>
extends IBaseObjectImpl
implements IDataControlChild {
    private ObjectList<IDataControlChild> children;
    private String label;
    private int compareCategory = 100;

    protected DataControlObjectFolder(IDataControlObject parent, T decoratedObject, String label) {
        this.label = label;
        assert (parent != null);
        this.setParent((IObject)parent);
        this.setDecoratedObject(decoratedObject);
    }

    public final T getDecoratedObject() {
        return (T)super.getDecoratedObject();
    }

    @Override
    public void dispose() {
        if (this.children != null) {
            DTRTUtil.dispose(this.children);
            this.children.clear();
            this.children = null;
        }
        super.dispose();
    }

    @Override
    public void handlePropertyChange(Object ... properties) {
        super.handlePropertyChange(properties);
        if (DTRTUtil.indexOf((Object[])properties, (Object)((Object)IBaseObject.CachedProperty.CHILDREN)) >= 0) {
            this.children = null;
        }
    }

    @Override
    public boolean isDeleted() {
        IObject root = DTRTvCommonUtil.getRootObject((IObject)this);
        return root != null && root != this && root.isDeleted();
    }

    public final IDataControlObject getParent() {
        return (IDataControlObject)super.getParent();
    }

    public final IStructureChild getStructureObject() {
        return null;
    }

    @Override
    public final String getLabel() {
        return this.label;
    }

    @Override
    public final String getId() {
        return this.getLabel();
    }

    @Override
    public final String getToolTipText() {
        return this.getLabel();
    }

    @Override
    protected String getTypeLabel() {
        return DataControlObjectTreeBuilder.Messages.folder;
    }

    public final void setCompareCategory(int compareCategory) {
        this.compareCategory = compareCategory;
    }

    @Override
    protected final int getCompareCategory() {
        return this.compareCategory;
    }

    @Override
    protected final ImageManager.IImageData getImageData() {
        return ImageManager.getInstance().getWorkbenchSharedImageData("IMG_OBJ_FOLDER");
    }

    public final List<? extends IDataControlChild> getChildren() {
        if (this.children == null) {
            this.children = this.doGetChildren();
        }
        return this.children == null ? Collections.emptyList() : this.children.getUnmodifiableView();
    }

    protected abstract ObjectList<IDataControlChild> doGetChildren();
}

