/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol;

import java.util.Arrays;
import java.util.Collection;
import oracle.adf.model.adapter.AbstractDefinition;
import oracle.adf.model.adapter.generic.DataControlStructure;
import oracle.adfinternal.model.adapter.ejb.EjbDefinition;
import oracle.eclipse.tools.adf.dtrt.context.command.IStructureCommand;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.CreateDataControlCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.EJBSessionBeanSourceInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.IDataControlSourceInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.JavaHandler;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.UpdateStructureCommand;
import oracle.xml.parser.v2.XMLDocument;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class EJBSessionBeanHandler
extends JavaHandler<EJBSessionBeanSourceInfo> {
    private Boolean containsJPA;

    public EJBSessionBeanHandler(EJBSessionBeanSourceInfo sourceInfo) {
        super(sourceInfo);
    }

    @Override
    public void assertExecution(IStructureCommand command) throws Exception {
        super.assertExecution(command);
        DTRTUtil.assertTrue((((EJBSessionBeanSourceInfo)this.getSourceInfo()).getLocalInterfaceType() != null ? 1 : 0) != 0, (String)Messages.invalidLocalInterface);
        DTRTUtil.assertTrue((boolean)((EJBSessionBeanSourceInfo)this.getSourceInfo()).getSessionBeanType().getJavaProject().equals(((EJBSessionBeanSourceInfo)this.getSourceInfo()).getLocalInterfaceType().getJavaProject()), (String)Messages.localInterfaceNotInSameProject);
        if (command instanceof CreateDataControlCommand) {
            CreateDataControlCommand createDataControlCommand = (CreateDataControlCommand)command;
            this.assertExecution(createDataControlCommand, ((EJBSessionBeanSourceInfo)this.getSourceInfo()).getSessionBeanType());
            this.handleDataControlId(createDataControlCommand, (IDataControlSourceInfo)this.getSourceInfo());
        }
    }

    @Override
    public IDataControl createDataControl(CreateDataControlCommand command, IProgressMonitor monitor) throws Exception {
        return this.createDataControl(((EJBSessionBeanSourceInfo)this.getSourceInfo()).getLocalInterfaceType(), command, monitor);
    }

    @Override
    public void updateStructure(UpdateStructureCommand command, IProgressMonitor monitor) throws Exception {
        this.updateStructure(((EJBSessionBeanSourceInfo)this.getSourceInfo()).getLocalInterfaceType(), command, monitor);
    }

    @Override
    protected IJavaProject getJavaProject() {
        return ((EJBSessionBeanSourceInfo)this.getSourceInfo()).getSessionBeanType().getJavaProject();
    }

    @Override
    public Collection<String> getIgnoredClassNames() {
        return Arrays.asList("javax.ejb.EJBObject", "javax.ejb.EJBLocalObject");
    }

    @Override
    public boolean ignoreMethod(ITypeHelper typeHelper, String name, String returnType) {
        return this.containsJPA() && this.isQueryByRangeMethod(name, returnType);
    }

    @Override
    protected Node getRuntimeSettings(ITypeHelper typeHelper) throws Exception {
        XMLDocument xmlDoc = new XMLDocument();
        Element metaData = xmlDoc.createElementNS("http://xmlns.oracle.com/adfm/adapter/ejb", "ejb-definition");
        metaData.setAttributeNS(null, "ejb-version", ((EJBSessionBeanSourceInfo)this.getSourceInfo()).getEJBVersion());
        metaData.setAttributeNS(null, "ejb-name", ((EJBSessionBeanSourceInfo)this.getSourceInfo()).getSessionBean().getEjbName());
        metaData.setAttributeNS(null, "ejb-type", "Session");
        metaData.setAttributeNS(null, "ejb-business-interface", ((EJBSessionBeanSourceInfo)this.getSourceInfo()).getLocalInterfaceType().getFullyQualifiedName());
        metaData.setAttributeNS(null, "ejb-interface-type", "local");
        if (((EJBSessionBeanSourceInfo)this.getSourceInfo()).getEJBVersion().startsWith("3.") && this.containsJPA()) {
            metaData.setAttributeNS(null, "DataControlHandler", EjbDefinition.JPQLDataControlHandlerName);
        }
        metaData.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://xmlns.oracle.com/adfm/adapter/ejb");
        return metaData;
    }

    @Override
    protected AbstractDefinition createDefinition(DataControlStructure dataControlStructure) {
        return new EjbDefinition(dataControlStructure);
    }

    private boolean containsJPA() {
        return this.containsJPA == null ? (this.containsJPA = Boolean.valueOf(this.getJPAProject() != null)) : this.containsJPA;
    }
}

