/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol;

import java.util.Collection;
import java.util.Collections;
import oracle.adf.model.adapter.AbstractDefinition;
import oracle.adf.model.adapter.bean.BeanDefinition;
import oracle.adf.model.adapter.generic.DataControlStructure;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.context.command.IStructureCommand;
import oracle.eclipse.tools.adf.dtrt.jdt.IMemberFilter;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.MemberFilterUtil;
import oracle.eclipse.tools.adf.dtrt.jdt.TypeInfo;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.BeanSourceInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.CreateDataControlCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.IDataControlSourceInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.JavaHandler;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.UpdateStructureCommand;
import oracle.xml.parser.v2.XMLDocument;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class BeanHandler
extends JavaHandler<BeanSourceInfo> {
    private static final IMemberFilter[] TRANSACTIONAL_DATA_CONTROL_FILTER = new IMemberFilter[]{new MemberFilterUtil.MemberFinder(true).findByName("oracle.binding.TransactionalDataControl"), new MemberFilterUtil.MemberFinder(true).findByName("oracle.adf.model.TransactionalDataControl")};
    private Boolean hasJPAField;

    public BeanHandler(BeanSourceInfo sourceInfo) {
        super(sourceInfo);
    }

    @Override
    public void assertExecution(IStructureCommand command) throws Exception {
        super.assertExecution(command);
        if (command instanceof CreateDataControlCommand) {
            CreateDataControlCommand createDataControlCommand = (CreateDataControlCommand)command;
            this.assertExecution(createDataControlCommand, ((BeanSourceInfo)this.getSourceInfo()).getType());
            this.handleDataControlId(createDataControlCommand, (IDataControlSourceInfo)this.getSourceInfo());
        }
    }

    @Override
    public IDataControl createDataControl(CreateDataControlCommand command, IProgressMonitor monitor) throws Exception {
        return this.createDataControl(((BeanSourceInfo)this.getSourceInfo()).getType(), command, monitor);
    }

    @Override
    public void updateStructure(UpdateStructureCommand command, IProgressMonitor monitor) throws Exception {
        this.updateStructure(((BeanSourceInfo)this.getSourceInfo()).getType(), command, monitor);
    }

    @Override
    protected IJavaProject getJavaProject() {
        return ((BeanSourceInfo)this.getSourceInfo()).getType().getJavaProject();
    }

    @Override
    public Collection<String> getIgnoredClassNames() {
        return Collections.singleton("oracle.binding.OperationBinding");
    }

    @Override
    public boolean ignoreMethod(ITypeHelper typeHelper, String name, String returnType) {
        try {
            return this.hasJPAField(typeHelper) && this.isQueryByRangeMethod(name, returnType);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    protected void adjustStructureDefinition(ITypeHelper typeHelper, StructureDefinition structureDefinition) throws Exception {
        if (!typeHelper.getSuperTypes(((BeanSourceInfo)this.getSourceInfo()).getType(), true, false, true, TRANSACTIONAL_DATA_CONTROL_FILTER).isEmpty()) {
            structureDefinition.getProperties().put("_SupportsTransaction", Boolean.TRUE);
        }
    }

    @Override
    protected Node getRuntimeSettings(ITypeHelper typeHelper) throws Exception {
        XMLDocument xmlDoc = new XMLDocument();
        Element metaData = xmlDoc.createElementNS("http://xmlns.oracle.com/adfm/adapter/bean", "bean-definition");
        metaData.setAttributeNS(null, "BeanClass", ((BeanSourceInfo)this.getSourceInfo()).getType().getFullyQualifiedName());
        if (this.hasJPAField(typeHelper)) {
            metaData.setAttributeNS(null, "DataControlHandler", BeanDefinition.JPQLDataControlHandlerName);
        }
        metaData.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://xmlns.oracle.com/adfm/adapter/bean");
        return metaData;
    }

    @Override
    protected AbstractDefinition createDefinition(DataControlStructure dataControlStructure) {
        return new BeanDefinition(dataControlStructure);
    }

    private boolean hasJPAField(ITypeHelper typeHelper) throws CoreException {
        if (this.hasJPAField == null) {
            IField[] fields;
            if (this.getJPAProject() != null && (fields = ((BeanSourceInfo)this.getSourceInfo()).getType().getFields()) != null) {
                IField[] iFieldArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    IField field = iFieldArray[n2];
                    TypeInfo typeInfo = typeHelper.getTypeInfo(field);
                    if (typeInfo != null && typeInfo.getClassName().startsWith("javax.persistence")) {
                        this.hasJPAField = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (this.hasJPAField == null) {
                this.hasJPAField = false;
            }
        }
        return this.hasJPAField;
    }
}

