/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.adfdt.model.objects.Application;
import oracle.adfdt.model.objects.BaseElementObject;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IObjectLocatorContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.ITaskFlowContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.object.IApplication;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlChild;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IFileMarker;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DataControlContext;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.OEPEContextFactory;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.ObjectTranslator;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.ObjectValidator;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.PageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.TaskFlowContext;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.WebPageContext;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.impl.PageDefinitionImpl;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IManagerListener;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.DTRTManagerFactory;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.ApplicationImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.IObjectTranslator;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.IObjectValidator;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.OEPEContextImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.manager.NotRegisteredADFElementException;
import oracle.eclipse.tools.adf.dtrt.vcommon.manager.UnexpectedRootElement;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

final class ObjectLocatorContext
extends OEPEContextImpl
implements IObjectLocatorContext,
IManagerListener {
    private List<IDTRTManager> managers = new ArrayList<IDTRTManager>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispose() {
        List<IDTRTManager> list = this.managers;
        synchronized (list) {
            DTRTUtil.dispose(this.managers);
            this.managers.clear();
        }
        super.doDispose();
    }

    public ObjectLocatorContext initialize(IProgressMonitor monitor) throws InterruptedException, CoreException {
        ProgressMonitorUtil.done((IProgressMonitor)monitor);
        return (ObjectLocatorContext)this.initialize(this);
    }

    public IObjectTranslator getTranslator() {
        return ObjectTranslator.INSTANCE;
    }

    public IObjectValidator getValidator() {
        return ObjectValidator.INSTANCE;
    }

    public boolean isKnown(IObject object) throws IllegalStateException {
        if (object instanceof IDataControlChild) {
            object = DTRTObjectUtil.getDataControl((IDataControlObject)((IDataControlChild)object));
        }
        return this.computeADFInfo(object) != null;
    }

    public IFile getAccessibleFile(IObject object) throws IllegalArgumentException, IllegalStateException {
        this.checkInitialized();
        return this.doGetAccessibleFile(object, true);
    }

    public List<? extends IFileMarker> getAccessibleDeclarations(IObject object) throws IllegalArgumentException, IllegalStateException {
        this.checkInitialized();
        return this.doGetAccessibleDeclarations(object);
    }

    public List<? extends IPageDefinition> getPageDefinitions(IProject earProject, IContainer container) {
        return this.getObjects(earProject, container, IPageDefinition.class);
    }

    public IPageDefinition getPageDefinition(IProject earProject, IFile pageDefinitionFile) {
        PageDefinitionContext context;
        this.checkInitialized();
        IDTRTManager manager = this.getManager(earProject, (IResource)pageDefinitionFile, true);
        if (manager != null && (context = this.createPageDefinitionContext(manager, pageDefinitionFile)) != null) {
            return context.getPageDefinition();
        }
        return null;
    }

    public IPageDefinition getPageDefinitionForWebPage(IProject earProject, IFile webPageFile) {
        WebPageContext context;
        this.checkInitialized();
        IDTRTManager manager = this.getManager(earProject, (IResource)webPageFile, true);
        if (manager != null && (context = this.createWebPageContext(manager, webPageFile)) != null) {
            return context.getPageDefinition();
        }
        return null;
    }

    public List<? extends IPageDefinition> getPageDefinitions(IProject earProject, ITaskFlowContext.ITaskFlowProxy taskFlow) {
        TaskFlowContext context;
        IDTRTManager manager;
        this.checkInitialized();
        if (taskFlow != null && (manager = this.getManager(earProject, (IResource)taskFlow.getTaskFlowFile(), true)) != null && (context = this.createTaskFlowContext(manager, taskFlow)) != null) {
            return context.getPageDefinitions();
        }
        return null;
    }

    public IPageDefinition getPageDefinitionForTaskFlowActivity(IProject earProject, ITaskFlowContext.ITaskFlowProxy taskFlow, Object activity) {
        TaskFlowContext context;
        IDTRTManager manager;
        this.checkInitialized();
        if (taskFlow != null && (manager = this.getManager(earProject, (IResource)taskFlow.getTaskFlowFile(), true)) != null && (context = this.createTaskFlowContext(manager, taskFlow)) != null) {
            return context.getPageDefinition(activity);
        }
        return null;
    }

    public IApplication getApplication(IProject earProject, IFile applicationFile) {
        this.checkInitialized();
        IDTRTManager manager = this.getManager(earProject, (IResource)applicationFile, true);
        if (manager != null) {
            try {
                Application adfApplication = manager.loadRegisteredApplication(applicationFile);
                if (adfApplication != null) {
                    IApplication application = (IApplication)this.getTranslator().fromADFObject((Object)adfApplication, IApplication.class);
                    if (application instanceof ApplicationImpl) {
                        ((ApplicationImpl)application).setManager(manager);
                    }
                    return this.adjustObject(manager, application);
                }
            }
            catch (Exception e) {
                DTRTvBundle.log(e);
            }
        }
        return null;
    }

    public Map<IApplication, List<IPageDefinition.IBoundSource>> getApplications(IPageDefinition pageDefinition) {
        Map<Application, List<IPageDefinition.IBoundSource>> adfApplicationMap;
        ADFInfo adfInfo = this.computeADFInfo((IObject)pageDefinition);
        if (adfInfo != null && !(adfApplicationMap = adfInfo.getManager().getApplications((PageDefinition)adfInfo.getElement())).isEmpty()) {
            HashMap<IApplication, List<IPageDefinition.IBoundSource>> applicationMap = new HashMap<IApplication, List<IPageDefinition.IBoundSource>>(adfApplicationMap.size());
            for (Map.Entry<Application, List<IPageDefinition.IBoundSource>> entry : adfApplicationMap.entrySet()) {
                IApplication application = (IApplication)this.getTranslator().fromADFObject((Object)entry.getKey(), IApplication.class);
                if (application instanceof ApplicationImpl) {
                    ((ApplicationImpl)application).setManager(adfInfo.getManager());
                }
                applicationMap.put(this.adjustObject(adfInfo.getManager(), application), entry.getValue());
            }
            return Collections.unmodifiableMap(applicationMap);
        }
        return Collections.emptyMap();
    }

    public List<? extends IPageDefinition> getPageDefinitions(IApplication application) {
        List<? extends PageDefinition> adfPageDefinitions;
        ADFInfo adfInfo = this.computeADFInfo((IObject)application);
        if (adfInfo != null && !(adfPageDefinitions = adfInfo.getManager().getPageDefinitions((Application)adfInfo.getElement())).isEmpty()) {
            ArrayList<IPageDefinition> pageDefinitions = new ArrayList<IPageDefinition>(adfPageDefinitions.size());
            for (PageDefinition pageDefinition : adfPageDefinitions) {
                IPageDefinition pageDefinition2 = (IPageDefinition)this.getTranslator().fromADFObject((Object)pageDefinition, IPageDefinition.class);
                if (pageDefinition2 instanceof PageDefinitionImpl) {
                    ((PageDefinitionImpl)pageDefinition2).setManager(adfInfo.getManager());
                }
                pageDefinitions.add(this.adjustObject(adfInfo.getManager(), pageDefinition2));
            }
            return Collections.unmodifiableList(pageDefinitions);
        }
        return Collections.emptyList();
    }

    public List<? extends IApplication> getApplications(IProject earProject, IContainer container) {
        return this.getObjects(earProject, container, IApplication.class);
    }

    public boolean hasUpdateableStructure(IStructure.IStructureSource source) {
        if (source != null) {
            IDTRTManager manager = this.getManager(source.getResource(), true);
            return this.hasUpdateableStructure(manager, source);
        }
        return false;
    }

    public boolean hasUpdateableStructure(IProject earProject, IStructure.IStructureSource source) {
        this.checkInitialized();
        if (source != null) {
            IDTRTManager manager = this.getManager(earProject, source.getResource(), true);
            return this.hasUpdateableStructure(manager, source);
        }
        return false;
    }

    private boolean hasUpdateableStructure(IDTRTManager manager, IStructure.IStructureSource source) {
        DataControlContext context;
        if (manager != null && (context = this.createDataControlContext(manager, source)) != null) {
            try {
                return context.hasUpdateableStructure(source);
            }
            catch (CoreException e) {
                DTRTvBundle.log(e);
            }
        }
        return false;
    }

    @Override
    public void handleExternalChange(IDTRTManager manager) {
        manager.reset();
    }

    @Override
    public void handleStructureLoading(IDTRTManager manager) {
    }

    @Override
    public void handleStructureChange(IDTRTManager manager) {
        manager.resetStructures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProject getCachedEARProject(IProject webProject) {
        if (webProject != null) {
            List<IDTRTManager> list = this.managers;
            synchronized (list) {
                for (IDTRTManager manager : this.managers) {
                    if (!manager.initializedWithEARWebProjects() || !manager.getProject().equals((Object)webProject)) continue;
                    return manager.getEARProject();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDTRTManager getManager(IProject earProject, IResource webProjectResource, boolean create) {
        if (earProject != null && webProjectResource != null) {
            IProject webProject = webProjectResource.getProject();
            assert (webProject != null);
            List<IDTRTManager> list = this.managers;
            synchronized (list) {
                for (IDTRTManager manager : this.managers) {
                    if (!manager.initializedWithEARWebProjects() || !manager.getProject().equals((Object)webProject) || !manager.getEARProject().equals((Object)earProject)) continue;
                    return manager;
                }
                if (create) {
                    try {
                        IDTRTManager manager;
                        manager = DTRTManagerFactory.createManager(earProject, webProject);
                        manager.addListener(this);
                        this.managers.add(manager);
                        return manager;
                    }
                    catch (Exception e) {
                        DTRTvBundle.log(e);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDTRTManager getManager(IResource modelProjectResource, boolean create) {
        if (modelProjectResource != null) {
            IProject modelProject = modelProjectResource.getProject();
            assert (modelProject != null);
            List<IDTRTManager> list = this.managers;
            synchronized (list) {
                for (IDTRTManager manager : this.managers) {
                    if (!manager.initializedWithModelProject() || !manager.getProject().equals((Object)modelProject)) continue;
                    return manager;
                }
                if (create) {
                    try {
                        IDTRTManager manager;
                        manager = DTRTManagerFactory.createManager(modelProject);
                        manager.addListener(this);
                        this.managers.add(manager);
                        return manager;
                    }
                    catch (Exception e) {
                        DTRTvBundle.log(e);
                    }
                }
            }
        }
        return null;
    }

    private PageDefinitionContext createPageDefinitionContext(IDTRTManager manager, IFile pageDefinitionFile) {
        try {
            PageDefinitionContext context = (PageDefinitionContext)OEPEContextFactory.INSTANCE.createContext(IPageDefinitionContext.class);
            context.setManager(manager);
            return context.initialize(manager.getEARProject(), pageDefinitionFile, null);
        }
        catch (UnexpectedRootElement unexpectedRootElement) {
        }
        catch (NotRegisteredADFElementException notRegisteredADFElementException) {
        }
        catch (CoreException e) {
            Throwable cause = DTRTUtil.getRootCause((CoreException)e);
            if (!(cause instanceof UnexpectedRootElement) && !(cause instanceof NotRegisteredADFElementException)) {
                DTRTvBundle.log(e);
            }
        }
        catch (Exception e) {
            DTRTvBundle.log(e);
        }
        return null;
    }

    private WebPageContext createWebPageContext(IDTRTManager manager, IFile webPageFile) {
        try {
            WebPageContext context = (WebPageContext)OEPEContextFactory.INSTANCE.createContext(IWebPageContext.class);
            context.setManager(manager);
            return context.initialize(manager.getEARProject(), webPageFile, null, null);
        }
        catch (Exception e) {
            DTRTvBundle.log(e);
            return null;
        }
    }

    private TaskFlowContext createTaskFlowContext(IDTRTManager manager, ITaskFlowContext.ITaskFlowProxy taskFlow) {
        try {
            TaskFlowContext context = (TaskFlowContext)OEPEContextFactory.INSTANCE.createContext(ITaskFlowContext.class);
            context.setManager(manager);
            return context.initialize(manager.getEARProject(), taskFlow, null);
        }
        catch (Exception e) {
            DTRTvBundle.log(e);
            return null;
        }
    }

    private DataControlContext createDataControlContext(IDTRTManager manager, IStructure.IStructureSource structureSource) {
        try {
            DataControlContext context = (DataControlContext)OEPEContextFactory.INSTANCE.createContext(IDataControlContext.class);
            context.setManager(manager);
            return manager.initializedWithEARWebProjects() ? context.initialize(manager.getEARProject(), manager.getProject(), null) : context.initialize(manager.getProject(), null);
        }
        catch (Exception e) {
            DTRTvBundle.log(e);
            return null;
        }
    }

    private List<? extends IFileMarker> doGetAccessibleDeclarations(IObject object) throws IllegalStateException {
        ADFInfo adfInfo = this.computeADFInfo(object);
        if (adfInfo != null) {
            return DTRTvUtil.getAccessibleDeclarations(adfInfo.getManager(), this.getTranslator(), object);
        }
        throw new IllegalArgumentException("Unknown object: " + object);
    }

    private IFile doGetAccessibleFile(IObject object, boolean throwUnknownObjectException) throws IllegalStateException {
        ADFInfo adfInfo = this.computeADFInfo(object);
        if (adfInfo != null) {
            IFile file = adfInfo.getManager().getElementFile(adfInfo.getElement());
            return adfInfo.getManager().isAccessible(file) ? file : null;
        }
        if (throwUnknownObjectException) {
            throw new IllegalArgumentException("Unknown object: " + object);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends BaseElementObject> ADFInfo<T> computeADFInfo(IObject object) throws IllegalStateException {
        if (object != null) {
            List<IDTRTManager> list = this.managers;
            synchronized (list) {
                Object adfObject = this.getTranslator().toADFObject(object);
                for (IDTRTManager manager : this.managers) {
                    if (!manager.isManagedElement(adfObject)) continue;
                    ADFInfo adfInfo = new ADFInfo(manager, adfObject);
                    return adfInfo;
                }
            }
        }
        return null;
    }

    private <T extends IObject> List<T> getObjects(IProject earProject, IContainer container, Class<T> objectType) {
        IDTRTManager manager;
        this.checkInitialized();
        if (container != null && !(container instanceof IWorkspaceRoot) && (manager = this.getManager(earProject, (IResource)container, true)) != null) {
            List<? extends Application> elements;
            List<Object> list = objectType == IApplication.class ? manager.getApplications() : (elements = objectType == IPageDefinition.class ? manager.getPageDefinitions() : null);
            if (elements != null && !elements.isEmpty()) {
                ArrayList<IObject> objects = new ArrayList<IObject>(elements.size());
                for (Application application : elements) {
                    IObject object = this.getTranslator().fromADFObject((Object)application, objectType);
                    if (object == null || !(container instanceof IProject) && !DTRTUtil.contains((IContainer)container, (IResource)manager.getElementFile(application))) continue;
                    objects.add((IObject)objectType.cast(this.adjustObject(manager, object)));
                }
                return Collections.unmodifiableList(objects);
            }
        }
        return Collections.emptyList();
    }

    private <T extends IObject> T adjustObject(IDTRTManager manager, T object) {
        if (object instanceof PageDefinitionImpl) {
            ((PageDefinitionImpl)object).setManager(manager);
        }
        return object;
    }

    private static class ADFInfo<T> {
        private IDTRTManager manager;
        private T element;

        private ADFInfo(IDTRTManager manager, T element) {
            this.manager = manager;
            this.element = element;
        }

        public IDTRTManager getManager() {
            return this.manager;
        }

        public T getElement() {
            return this.element;
        }
    }
}

