/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.context;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.util.IFileMarker;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DTRTvContextUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DataControlProviderExecutableContext;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.impl.PageDefinitionImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

abstract class BasePageDefinitionContext
extends DataControlProviderExecutableContext {
    protected PageDefinition adfPageDefinition;
    protected URI pageDefinitionURI;
    private IPageDefinition pageDefinition;

    BasePageDefinitionContext() {
    }

    @Override
    protected void doDispose() {
        this.adfPageDefinition = null;
        this.pageDefinitionURI = null;
        if (this.pageDefinition != null) {
            this.pageDefinition.dispose();
            this.pageDefinition = null;
        }
        super.doDispose();
    }

    public final IProject getEARProject() {
        return this.getManager() != null ? this.getManager().getEARProject() : null;
    }

    protected final void loadPageDefinition(IFile pageDefinitionFile) throws Exception {
        this.adfPageDefinition = this.getManager().loadRegisteredPageDefinition(pageDefinitionFile);
        if (this.adfPageDefinition != null) {
            this.pageDefinitionURI = this.getManager().getElementURI(this.adfPageDefinition);
            this.getManager().registerUnknownElementObjectFactories(this.adfPageDefinition);
        }
    }

    protected final void loadPageDefinition(IPageDefinition.IBoundSource boundSource) throws Exception {
        this.getManager().setBoundSource(boundSource);
        this.adfPageDefinition = this.getManager().getPageDefinition(false);
        if (this.adfPageDefinition != null) {
            this.pageDefinitionURI = this.getManager().getElementURI(this.adfPageDefinition);
            this.getManager().registerUnknownElementObjectFactories(this.adfPageDefinition);
        }
    }

    @Override
    protected boolean doReset(IProgressMonitor monitor) throws InterruptedException, CoreException {
        boolean doReset;
        boolean bl = doReset = this.pageDefinitionURI != null;
        if (this.pageDefinition != null) {
            this.pageDefinition.dispose();
            this.pageDefinition = null;
            doReset = true;
        }
        boolean bl2 = doReset = super.doReset(monitor) || doReset;
        if (doReset) {
            this.handleReset(monitor);
        }
        return doReset;
    }

    protected abstract void handleReset(IProgressMonitor var1) throws CoreException;

    protected final PageDefinition getADFPageDefinition() {
        if (this.adfPageDefinition == null) {
            if (this.getManager().getBoundSource() != null) {
                this.adfPageDefinition = this.getManager().getPageDefinition(false);
                if (this.adfPageDefinition != null) {
                    this.pageDefinitionURI = this.getManager().getElementURI(this.adfPageDefinition);
                    this.getManager().registerUnknownElementObjectFactories(this.adfPageDefinition);
                }
            }
        } else if (!this.getManager().isManagedElement(this.adfPageDefinition)) {
            this.adfPageDefinition = null;
            this.pageDefinitionURI = null;
            this.pageDefinition = null;
        }
        return this.adfPageDefinition;
    }

    public final IPageDefinition getPageDefinition() {
        this.checkInitialized();
        if (this.getADFPageDefinition() != null && this.pageDefinition == null) {
            this.pageDefinition = (IPageDefinition)this.getTranslator().fromADFObject((Object)this.getADFPageDefinition(), IPageDefinition.class);
            if (this.pageDefinition instanceof PageDefinitionImpl) {
                ((PageDefinitionImpl)this.pageDefinition).setManager(this.getManager());
            }
        }
        return this.pageDefinition;
    }

    public IFileMarker getAccessibleDeclaration(IDataControlObject dataControlObject) {
        List<? extends IFileMarker> markers = super.getAccessibleDeclarations((IObject)dataControlObject);
        return markers.isEmpty() ? null : markers.get(0);
    }

    public Collection<? extends IStructure> getLoadedStructures() {
        return DTRTvContextUtil.getLoadedStructures(this);
    }

    @Override
    public void resetStructures(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (this.pageDefinition instanceof oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.PageDefinition) {
            ((oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.PageDefinition)this.pageDefinition).clearDataControlCache();
        }
        super.resetStructures(monitor);
    }

    protected static class Messages
    extends NLS {
        public static String errorDuringReset;

        static {
            NLS.initializeMessages((String)BasePageDefinitionContext.class.getName(), Messages.class);
        }

        protected Messages() {
        }
    }
}

