/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.bindingobject.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IELProperty;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DescribableLabelProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.DescribableTreeElement;
import oracle.eclipse.tools.adf.dtrt.ui.util.UIExceptionHandler;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescribable;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.TaskFlowWidget;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.ui.Messages;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonBundleIcon;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.xml.edit.ui.propeditor.AbstractBindDialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ParameterELBindStrategy
extends AbstractBindDialogCreationStrategy {
    private IOEPEContext context;

    public ParameterELBindStrategy(IOEPEContext context) {
        this.context = context;
    }

    public void dispose() {
        this.context = null;
    }

    public ToolItem createToolItem(ToolBar parent, WidgetAdapter widgetAdapter) {
        return this.createToolItem(parent, widgetAdapter, LABEL_PROVIDER);
    }

    public Image getToolItemImage() {
        return CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_DYNAMIC_BINDING);
    }

    public String doGetToolTipText() {
        return Messages.bindToDynamicValue;
    }

    public IDocument getBaseDocument() {
        return null;
    }

    public boolean isValid() {
        return true;
    }

    protected ElementTreeSelectionDialog getDialog(Control parent, IObservableValue modelObservable) {
        List managedBeans = Collections.emptyList();
        IWebPageContext pageContext = this.getPageContext(this.context);
        if (pageContext != null) {
            try {
                managedBeans = new ArrayList<IWebPageContext.IManagedBean>(TaskFlowWidget.collectManagedBeans(pageContext, null));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        if (!managedBeans.isEmpty()) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int i = managedBeans.size() - 1;
            while (i >= 0) {
                IWebPageContext.IManagedBean managedBean = (IWebPageContext.IManagedBean)managedBeans.get(i);
                if (managedBean.getScope() != Variable.SCOPE.ADF_VIEW_SCOPE) {
                    managedBeans.remove(i);
                } else {
                    IFile file = root.getFile(((IWebPageContext.IManagedBean)managedBeans.get(i)).getJavaFilePath());
                    if (!file.isAccessible()) {
                        managedBeans.remove(i);
                    }
                }
                --i;
            }
        }
        List bindingObjects = Collections.emptyList();
        if (this.getPageDefContext(this.context) != null) {
            bindingObjects = DTRTObjectUtil.getBindingObjects((IPageDefinition)this.getPageDefContext(this.context));
        }
        ArrayList input = new ArrayList(bindingObjects.size() + managedBeans.size());
        input.addAll(bindingObjects);
        input.addAll(managedBeans);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent.getShell(), (ILabelProvider)new DescribableLabelProvider(), new ELBindContentProvider()){

            protected TreeViewer createTreeViewer(Composite parent) {
                TreeViewer treeViewer = super.createTreeViewer(parent);
                ColumnViewerToolTipSupport.enableFor((ColumnViewer)treeViewer);
                return treeViewer;
            }
        };
        dialog.setTitle(Messages.elBindDialogTitle);
        dialog.setMessage(Messages.elBindDialogMessage);
        dialog.setInput(input);
        dialog.setAllowMultiple(false);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length == 0 || selection.length > 1 || selection[0] instanceof IGroup) {
                    return new Status(4, "oracle.eclipse.tools.adf.dtrt.v110101", "");
                }
                String el = ELBindContentProvider.getELExpression(false, selection[0]);
                if (el != null) {
                    return new Status(0, "oracle.eclipse.tools.adf.dtrt.v110101", NLS.bind((String)Messages.elBindDialogELExpression, (Object)el));
                }
                return new Status(4, "oracle.eclipse.tools.adf.dtrt.v110101", Messages.elBindDialogNotValid);
            }
        });
        return dialog;
    }

    private IPageDefinition getPageDefContext(IOEPEContext ctx) {
        if (ctx instanceof IPageDefinitionContext) {
            return ((IPageDefinitionContext)ctx).getPageDefinition();
        }
        if (ctx instanceof IWebPageContext) {
            return ((IWebPageContext)ctx).getPageDefinition();
        }
        return null;
    }

    private IWebPageContext getPageContext(IOEPEContext ctx) {
        if (ctx instanceof IWebPageContext) {
            return (IWebPageContext)ctx;
        }
        if (ctx instanceof IPageDefinitionContext) {
            List sources = ((IPageDefinitionContext)ctx).getPageDefinition().getBoundSources();
            for (IPageDefinition.IBoundSource source : sources) {
                if (source.getType() != IPageDefinition.IBoundSource.BoundSourceType.WEB_PAGE) continue;
                IFile file = source.getFile();
                IProject earProject = DTRTUtil.getEARProject((IResource)file);
                IWebPageContext wpc = (IWebPageContext)DTRTUtil.createContext((IResource)file, IWebPageContext.class);
                if (wpc == null) continue;
                try {
                    wpc.initialize(earProject, file, null, null);
                    return wpc;
                }
                catch (Exception e) {
                    UIExceptionHandler.DEFAULT.handleException(e);
                }
            }
        }
        return null;
    }

    public void openDialog(Control parent, IObservableValue modelObservable) {
        if (!this.isValid()) {
            DialogService.showErrorDialog((String)this.getValidationMessage());
            return;
        }
        ElementTreeSelectionDialog dialog = this.getDialog(parent, modelObservable);
        Assert.isNotNull((Object)dialog, (String)"Could not create dialog");
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            String el = ELBindContentProvider.getELExpression(false, dialog.getFirstResult());
            modelObservable.setValue((Object)el);
        }
    }

    private static class BindingGroup
    extends BaseDescribable
    implements IGroup {
        private List<DescribableTreeElement> bindingObjectElements;

        private BindingGroup() {
        }

        public void dispose() {
            this.bindingObjectElements = null;
            super.dispose();
        }

        protected BaseDescriptor createDescriptor() {
            return new BaseDescriptor(){

                public String getLabel() {
                    return Messages.bindings;
                }

                public ImageManager.IImageData getImageData() {
                    return ImageManager.getInstance().getWorkbenchSharedImageData("IMG_OBJ_FOLDER");
                }
            };
        }

        @Override
        public List<DescribableTreeElement> getTreeElements() {
            return this.bindingObjectElements == null ? (this.bindingObjectElements = new ArrayList<DescribableTreeElement>()) : this.bindingObjectElements;
        }

        public int hashCode() {
            return this.baseHashCode();
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj);
        }
    }

    private static class ELBindContentProvider
    implements ITreeContentProvider {
        private ManagedBeanGroup managedBeanGroup;
        private BindingGroup bindingGroup;

        private ELBindContentProvider() {
        }

        public static String getELExpression(boolean deferred, Object element) {
            if (element instanceof DescribableTreeElement) {
                DescribableTreeElement treeElement = (DescribableTreeElement)element;
                IDescribable describable = treeElement.getDescribable();
                if (describable instanceof IWebPageContext.IManagedBeanObject) {
                    return ((IWebPageContext.IManagedBeanObject)describable).getEL();
                }
                if (describable instanceof IBindingObject) {
                    return DTRTObjectUtil.computeEL((boolean)deferred, (IBindingObject)((IBindingObject)describable), null);
                }
                if (describable instanceof IELProperty) {
                    ArrayList<IELProperty> properties = new ArrayList<IELProperty>();
                    Object treeObject = treeElement;
                    while (treeObject instanceof DescribableTreeElement) {
                        DescribableTreeElement dte = treeObject;
                        if (!(dte.getDescribable() instanceof IELProperty)) {
                            if (!(dte.getDescribable() instanceof IBindingObject)) break;
                            if (properties.size() > 1) {
                                Collections.reverse(properties);
                            }
                            return DTRTObjectUtil.computeEL((boolean)deferred, (IBindingObject)((IBindingObject)dte.getDescribable()), properties);
                        }
                        properties.add((IELProperty)dte.getDescribable());
                        treeObject = treeObject.getParent();
                    }
                }
            }
            return null;
        }

        public void dispose() {
            if (this.managedBeanGroup != null) {
                this.managedBeanGroup.dispose();
                this.managedBeanGroup = null;
            }
            if (this.bindingGroup != null) {
                this.bindingGroup.dispose();
                this.bindingGroup = null;
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.dispose();
            if (newInput instanceof Collection) {
                this.initialize((Collection)newInput);
            }
        }

        public Object[] getElements(Object inputElement) {
            Object[] objectArray;
            if (this.managedBeanGroup == null && this.bindingGroup == null && inputElement instanceof Collection) {
                this.initialize((Collection)inputElement);
            }
            if (this.managedBeanGroup != null && this.bindingGroup != null) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = this.bindingGroup;
                objectArray = objectArray2;
                objectArray2[1] = this.managedBeanGroup;
            } else if (this.bindingGroup != null) {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.bindingGroup;
            } else if (this.managedBeanGroup != null) {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.managedBeanGroup;
            } else {
                objectArray = DTRTUtil.EMPTY_ARRAY;
            }
            return objectArray;
        }

        public Object getParent(Object element) {
            return element instanceof DescribableTreeElement ? ((DescribableTreeElement)element).getParent() : null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IGroup) {
                return !((IGroup)element).getTreeElements().isEmpty();
            }
            if (element instanceof DescribableTreeElement) {
                DescribableTreeElement treeElement = (DescribableTreeElement)element;
                if (!treeElement.childrenWasComputed()) {
                    if (treeElement.getDescribable() instanceof IBindingObject) {
                        IBindingObject bindingObject = (IBindingObject)treeElement.getDescribable();
                        return bindingObject.getELMetadata() != null && !bindingObject.getELMetadata().getProperties().isEmpty();
                    }
                    if (treeElement.getDescribable() instanceof IELProperty) {
                        IELProperty property = (IELProperty)treeElement.getDescribable();
                        return !property.getProperties().isEmpty();
                    }
                    if (treeElement.getDescribable() instanceof IWebPageContext.IManagedBeanObject) {
                        IWebPageContext.IManagedBeanObject managedBeanObject = (IWebPageContext.IManagedBeanObject)treeElement.getDescribable();
                        for (IWebPageContext.IManagedBeanObject child : managedBeanObject.getChildren()) {
                            treeElement.addChild((Object)new DescribableTreeElement((Object)treeElement, (IDescribable)child));
                        }
                    }
                }
                return !treeElement.getChildren().isEmpty();
            }
            return false;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IGroup) {
                return ((IGroup)parentElement).getTreeElements().toArray();
            }
            if (parentElement instanceof DescribableTreeElement) {
                DescribableTreeElement treeElement = (DescribableTreeElement)parentElement;
                if (!treeElement.childrenWasComputed()) {
                    if (treeElement.getDescribable() instanceof IBindingObject) {
                        IBindingObject bindingObject = (IBindingObject)treeElement.getDescribable();
                        if (bindingObject.getELMetadata() != null) {
                            for (IELProperty property : bindingObject.getELMetadata().getProperties()) {
                                DescribableTreeElement childTreeElement = new DescribableTreeElement((Object)treeElement, (IDescribable)property);
                                treeElement.addChild((Object)childTreeElement);
                            }
                        }
                    } else if (treeElement.getDescribable() instanceof IELProperty) {
                        IELProperty property = (IELProperty)treeElement.getDescribable();
                        for (IELProperty childProperty : property.getProperties()) {
                            DescribableTreeElement childTreeElement = new DescribableTreeElement((Object)treeElement, (IDescribable)childProperty);
                            treeElement.addChild((Object)childTreeElement);
                        }
                    } else if (treeElement.getDescribable() instanceof IWebPageContext.IManagedBeanObject) {
                        IWebPageContext.IManagedBeanObject managedBeanObject = (IWebPageContext.IManagedBeanObject)treeElement.getDescribable();
                        for (IWebPageContext.IManagedBeanObject child : managedBeanObject.getChildren()) {
                            treeElement.addChild((Object)new DescribableTreeElement((Object)treeElement, (IDescribable)child));
                        }
                    }
                }
                return treeElement.getChildren().toArray();
            }
            return DTRTUtil.EMPTY_ARRAY;
        }

        private void initialize(Collection<?> input) {
            for (Object object : input) {
                if (object instanceof IBindingObject) {
                    if (this.bindingGroup == null) {
                        this.bindingGroup = new BindingGroup();
                    }
                    this.bindingGroup.getTreeElements().add(new DescribableTreeElement((Object)this.bindingGroup, (IDescribable)((IBindingObject)object)));
                    continue;
                }
                if (!(object instanceof IWebPageContext.IManagedBean)) continue;
                if (this.managedBeanGroup == null) {
                    this.managedBeanGroup = new ManagedBeanGroup();
                }
                this.managedBeanGroup.getTreeElements().add(new DescribableTreeElement((Object)this.managedBeanGroup, (IDescribable)((IWebPageContext.IManagedBean)object)));
            }
        }
    }

    private static interface IGroup {
        public List<DescribableTreeElement> getTreeElements();
    }

    private static class ManagedBeanGroup
    extends BaseDescribable
    implements IGroup {
        private List<DescribableTreeElement> managedBeanElements;

        private ManagedBeanGroup() {
        }

        public void dispose() {
            this.managedBeanElements = null;
            super.dispose();
        }

        protected BaseDescriptor createDescriptor() {
            return new BaseDescriptor(){

                public String getLabel() {
                    return Messages.managedBeans;
                }

                public ImageManager.IImageData getImageData() {
                    return DTRTvCommonBundleIcon.MANAGED_BEAN_GROUP;
                }
            };
        }

        @Override
        public List<DescribableTreeElement> getTreeElements() {
            return this.managedBeanElements == null ? (this.managedBeanElements = new ArrayList<DescribableTreeElement>()) : this.managedBeanElements;
        }

        public int hashCode() {
            return this.baseHashCode();
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj);
        }
    }
}

