/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.binding.pattern.selection;

import java.util.Map;
import oracle.adf.model.adapter.dataformat.AttributeDef;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.model.objects.Application;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdt.model.objects.CtrlList;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfdt.model.objects.IteratorBinding;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.adfdt.view.common.binding.creator.v2.BasePattern;
import oracle.adfdt.view.common.binding.creator.v2.BinderParams;
import oracle.adfdt.view.common.binding.creator.v2.BinderResult;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.creator.v2.CreatorResult;
import oracle.adfdt.view.common.binding.utils.ADFBindingGenerator;
import oracle.adfdt.view.common.binding.utils.ADFBindingUtils;
import oracle.adfdtinternal.view.rich.binding.provider.ADFSelectionModelProvider;
import oracle.binding.meta.NamedDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.binding.pattern.selection.SelectOneOptions;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseSelectOnePattern
extends BasePattern<SelectOneOptions> {
    public CreatorResult create(CreatorParams<SelectOneOptions> params) {
        this._configure(params);
        Document d = params.getOwnerDocument();
        DocumentFragment df = d.createDocumentFragment();
        df.appendChild(d.createElementNS("http://xmlns.oracle.com/adf/faces/rich", this.getLocalName()));
        return new CreatorResult(df);
    }

    public BinderResult bind(BinderParams<SelectOneOptions> params) {
        this._configure((CreatorParams<SelectOneOptions>)params);
        this._bind(params);
        return BinderResult.OK;
    }

    public SelectOneOptions createOptions(CreatorParams<SelectOneOptions> params) {
        return new SelectOneOptions((ADFSelectionModelProvider)params.getModelProvider());
    }

    public SelectOneOptions generateOptions(BinderParams<SelectOneOptions> params) {
        return new SelectOneOptions((ADFSelectionModelProvider)params.getModelProvider());
    }

    private void _configure(CreatorParams<SelectOneOptions> p) {
        ADFSelectionModelProvider mp = (ADFSelectionModelProvider)p.getModelProvider();
        mp.setIgnorePopulation(true);
    }

    protected abstract String getLocalName();

    private void _bind(BinderParams<SelectOneOptions> params) {
        ADFDesignTimeContext dtContext = params.getDtContext();
        ADFSelectionModelProvider modelProvider = (ADFSelectionModelProvider)params.getModelProvider();
        Element root = this.getSingleBindRoot(params.getBindRoots());
        Map properties = params.getProperties();
        boolean isJsf = ADFBindingUtils.hasProperty((Map)properties, (String)"jsf");
        boolean addRequired = "true".equals(properties.get("primitive:addRequired"));
        this.populateBinding(modelProvider, params);
        String itorVar = modelProvider.getIteratorVar();
        boolean isBoundToIterator = modelProvider.isBoundToIterator();
        String value = isBoundToIterator ? modelProvider.getSelectionExpression(itorVar) : modelProvider.getSelectionExpression();
        root.setAttributeNS(null, "value", value);
        if (!isJsf) {
            String shortDesc;
            String label = isBoundToIterator ? modelProvider.getLabelExpression(itorVar) : modelProvider.getLabelExpression();
            root.setAttributeNS(null, "label", label);
            if (!root.hasAttributeNS(null, "shortDesc") && (shortDesc = modelProvider.getShortDescExpression()) != null && !"".equals(shortDesc)) {
                root.setAttributeNS(null, "shortDesc", shortDesc);
            }
            String requiredExpr = modelProvider.getRequiredExpression();
            if (addRequired && requiredExpr != null) {
                root.setAttributeNS(null, "required", requiredExpr);
            }
        }
        Element selectItems = null;
        Node child = root.getFirstChild();
        while (child != null) {
            Element childElement;
            if (child.getNodeType() == 1 && "http://java.sun.com/jsf/core".equals((childElement = (Element)child).getNamespaceURI()) && "selectItems".equals(childElement.getLocalName())) {
                selectItems = childElement;
                break;
            }
            child = child.getNextSibling();
        }
        if (selectItems == null) {
            Document document = root.getOwnerDocument();
            selectItems = document.createElementNS("http://java.sun.com/jsf/core", "selectItems");
            dtContext.prepareAppendElement(root, selectItems);
            root.appendChild(selectItems);
        }
        String childValue = isBoundToIterator ? modelProvider.getChildIteratorExpression(itorVar) : modelProvider.getChildIteratorExpression();
        selectItems.setAttributeNS(null, "value", childValue);
    }

    private void populateBinding(ADFSelectionModelProvider modelProvider, BinderParams<SelectOneOptions> params) {
        SelectOneOptions options = (SelectOneOptions)params.getOptions();
        ControlBinding ctrlBinding = modelProvider.getOrCreateUnpopulatedBinding();
        PageDefinition pageDefinition = ctrlBinding.getBindingContainer();
        Application application = pageDefinition.getDesigntimeContext().getApplication();
        IteratorBinding newIter = ADFBindingGenerator.createUniqueIteratorBinding((Application)application, (PageDefinition)pageDefinition, (DataControl)options.getListDataSourceDC(), (NamedDefinition)options.getListDataSource());
        newIter.setRangeSize(-1);
        if (ctrlBinding instanceof CtrlList) {
            CtrlList ctrlList = (CtrlList)ctrlBinding;
            ctrlList.setStaticList(false);
            ctrlList.setListOperMode(0);
            ctrlList.setAttrNames(this.getTargetAttribute(modelProvider.getDefinition()));
            ctrlList.setListIteratorBindingName(newIter.getId());
            ctrlList.setListAttrNames(this.createStringArray(options.getListAttribute()));
            ctrlList.setListDisplayAttrNames(this.createStringArray(options.getDisplayAttribute()));
        }
    }

    private String[] getTargetAttribute(NamedDefinition definition) {
        return definition instanceof AttributeDef ? this.createStringArray((AttributeDef)definition) : null;
    }

    private String[] createStringArray(AttributeDef attributeDef) {
        if (attributeDef != null) {
            String[] attrs = new String[]{attributeDef.getName()};
            return attrs;
        }
        return null;
    }
}

