/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.binding.creator;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.binding.creator.CreatorPresentation;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.ICreatorPresentation;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.IPresentationVariation;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.PresentationVariation;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GraphType;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.xml.jaxp.JXDocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CreatorPresentationManager {
    private static final String CREATOR_CONFIGURATION_NS = "http://xmlns.oracle.com/adfdt/view/creatorConfiguration";
    private static final String DVT_CREATOR_CONFIGURATION_FILE_PATH = "metadata/dvt_creator_configuration.xml";
    private static volatile CreatorPresentationManager INSTANCE;
    private final Map<String, ICreatorPresentation> _presentations = new HashMap<String, ICreatorPresentation>();

    private CreatorPresentationManager() {
    }

    public static synchronized CreatorPresentationManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CreatorPresentationManager();
            INSTANCE.init();
        }
        return INSTANCE;
    }

    public ICreatorPresentation getCreatorPresentation(String componentType) {
        return this._presentations.get(componentType);
    }

    private void init() {
        try {
            Element creatorInfos;
            String resourceClass;
            InputStream is = DTRTvBundle.getResourceURL(DVT_CREATOR_CONFIGURATION_FILE_PATH).openStream();
            JXDocumentBuilderFactory factory = new JXDocumentBuilderFactory();
            factory.setIgnoreElementContentWhitespace(false);
            factory.setIgnoringComments(false);
            Document document = factory.newDocumentBuilder().parse(is);
            NodeList nodeList = document.getElementsByTagNameNS(CREATOR_CONFIGURATION_NS, "creatorInfos");
            ResourceBundle resourceBundle = null;
            if (nodeList != null && nodeList.getLength() > 0 && (resourceClass = (creatorInfos = (Element)nodeList.item(0)).getAttributeNS(null, "resourceBundle")) != null && !resourceClass.isEmpty()) {
                resourceBundle = ResourceBundle.getBundle(resourceClass, Locale.getDefault(), DTRTvBundle.class.getClassLoader());
            }
            NodeList creators = document.getElementsByTagNameNS(CREATOR_CONFIGURATION_NS, "creator");
            int i = 0;
            while (i < creators.getLength()) {
                Element creatorElement = (Element)creators.item(i);
                String componentType = creatorElement.getAttribute("localName");
                if (GraphType.forType((String)componentType) != null) {
                    Node child = creatorElement.getFirstChild();
                    while (child != null) {
                        if (1 == child.getNodeType() && "presentation".equals(child.getLocalName())) {
                            this.handlePresentationNode(componentType, resourceBundle, (Element)child);
                        }
                        child = child.getNextSibling();
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            LoggingService.logException((String)"oracle.eclipse.tools.adf.dtrt.v110101", (Throwable)e);
        }
    }

    private void handlePresentationNode(String componentType, ResourceBundle rb, Element presentationNode) {
        try {
            String presType = presentationNode.getAttributeNS(null, "type");
            if (presType == null || presType.trim().isEmpty()) {
                throw new IllegalStateException("presentation type empty");
            }
            HashMap<String, String> propertiesMap = new HashMap<String, String>();
            String properties = this._getAttr(presentationNode, "properties", false);
            this._addPropertiesToMap(rb, properties, propertiesMap);
            CreatorPresentation cp = new CreatorPresentation(propertiesMap, this.gatherVariations(rb, presentationNode));
            this._presentations.put(componentType, cp);
        }
        catch (Exception e) {
            String message = "Failed to process node: " + presentationNode.getLocalName();
            LoggingService.logException((String)"oracle.eclipse.tools.adf.dtrt.v110101", (Throwable)e, (String)message);
        }
    }

    private List<IPresentationVariation> gatherVariations(ResourceBundle rb, Element root) {
        ArrayList<IPresentationVariation> variations = new ArrayList<IPresentationVariation>();
        Node child = root.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && "variation".equals(child.getLocalName())) {
                Element childElem = (Element)child;
                String name = this._getAttr(childElem, "name", true);
                String desc = this._getAttr(childElem, "description", false);
                if (desc == null) {
                    desc = this._getResourceFromBundle(rb, name, true);
                }
                desc = this.removeMarkup(desc);
                String helpText = this._getAttr(childElem, "helpText", false);
                if (helpText == null) {
                    helpText = this._getResourceFromBundle(rb, String.valueOf(name) + ".help", false);
                }
                helpText = this.removeMarkup(helpText);
                HashMap<String, String> propertiesMap = new HashMap<String, String>();
                String properties = this._getAttr(childElem, "properties", false);
                this._addPropertiesToMap(rb, properties, propertiesMap);
                List<IPresentationVariation> childVars = this.gatherVariations(rb, childElem);
                String image = this._getAttr(childElem, "image", false);
                variations.add((IPresentationVariation)new PresentationVariation(name, desc, helpText, image, propertiesMap, childVars));
            }
            child = child.getNextSibling();
        }
        return variations;
    }

    private String _getAttr(Element elem, String attrName, boolean required) {
        String attr = elem.getAttributeNS(null, attrName);
        if (attr == null) {
            if (required) {
                throw new IllegalArgumentException(String.valueOf(attrName) + " is required on " + elem.getLocalName());
            }
            return null;
        }
        if ((attr = attr.trim()).isEmpty()) {
            if (required) {
                throw new IllegalArgumentException(String.valueOf(attrName) + " is required on " + elem.getLocalName());
            }
            return null;
        }
        return attr;
    }

    private String _getResourceFromBundle(ResourceBundle bundle, String resource, boolean required) {
        try {
            return bundle.getString(resource);
        }
        catch (Exception exception) {
            if (!required) {
                return null;
            }
            return String.format("-- NO TRANSLATIONS FOUND FOR %s --", resource);
        }
    }

    private void _addPropertiesToMap(ResourceBundle rb, String properties, Map<String, String> propertyMap) {
        if (properties == null) {
            return;
        }
        if (!(properties = properties.trim()).isEmpty()) {
            String[] split = properties.split(" ");
            int i = 0;
            while (i < split.length) {
                this._addEncodedPropertyStringToMap(rb, propertyMap, split[i]);
                ++i;
            }
        }
    }

    private void _addEncodedPropertyStringToMap(ResourceBundle rb, Map<String, String> map, String encodedString) {
        String[] split = encodedString.split("=");
        if (split.length >= 2) {
            String value = split[1];
            if (value.startsWith("resource(") && value.endsWith(")")) {
                value = this._getResourceFromBundle(rb, value.substring(9, value.length() - 1), true);
            }
            map.put(split[0], value);
        } else {
            map.put(split[0], "true");
        }
    }

    private String removeMarkup(String html) {
        String result = html;
        if (html != null && !html.isEmpty()) {
            if (html.indexOf("<html><center>") >= 0 && html.length() > 21) {
                result = html.substring(14, html.length() - 7);
                result = result.replace("<br>", " ");
            } else if (html.indexOf("<html>") >= 0 && html.length() > 13) {
                result = html.substring(6, html.length() - 7);
            }
        }
        return result;
    }
}

