/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal;

import java.util.List;
import org.eclipse.wst.dtd.core.internal.CMBasicNode;
import org.eclipse.wst.dtd.core.internal.CMNode;
import org.eclipse.wst.dtd.core.internal.CMRepeatableNode;
import org.eclipse.wst.dtd.core.internal.DTDCoreMessages;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.text.RegionIterator;
import org.eclipse.wst.dtd.core.internal.util.DTDUniqueNameHelper;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.w3c.dom.Node;

public class CMGroupNode
extends CMRepeatableNode {
    public static final char CHOICE = '|';
    public static final char SEQUENCE = ',';
    protected char connector = (char)44;

    public CMGroupNode(DTDFile file, IStructuredDocumentRegion flatNode) {
        super(file, flatNode);
    }

    public void addChild() {
        this.beginRecording((Object)this, DTDCoreMessages._UI_LABEL_CM_GRP_NODE_ADD_CHILD);
        DTDNode lastNode = (DTDNode)((Object)this.getLastChild());
        String elementName = DTDUniqueNameHelper.getUniqueName(this.getChildrenList(), "ChildNode");
        if (lastNode != null) {
            this.replaceText((Object)this, lastNode.getEndOffset(), 0, String.valueOf(String.valueOf(this.getConnector())) + elementName);
        } else {
            this.replaceText((Object)this, this.getStartOffset() + 1, 0, elementName);
        }
        this.endRecording((Object)this);
    }

    public void addGroup() {
        this.beginRecording((Object)this, DTDCoreMessages._UI_LABEL_CM_GRP_NODE_ADD_GRP);
        DTDNode lastNode = (DTDNode)((Object)this.getLastChild());
        if (lastNode != null) {
            this.replaceText((Object)this, lastNode.getEndOffset(), 0, String.valueOf(String.valueOf(this.getConnector())) + " ()");
        } else {
            this.replaceText((Object)this, this.getStartOffset() + 1, 0, "()");
        }
        this.endRecording((Object)this);
    }

    public void delete(Object requestor, DTDNode child) {
        Object[] children = this.getChildren();
        if (children.length == 1 && this.getFirstChild() == child) {
            this.replaceText(requestor, child.getStartOffset(), child.getNodeLength(), null);
            return;
        }
        int i = 0;
        while (i < children.length - 1) {
            boolean childBDeleted;
            DTDNode childA = (DTDNode)((Object)children[i]);
            DTDNode childB = (DTDNode)((Object)children[i + 1]);
            boolean childADeleted = childA == child;
            boolean bl = childBDeleted = childB == child;
            if (childADeleted || childBDeleted) {
                int startOffset = childADeleted ? childA.getStartOffset() : childA.getEndOffset();
                int endOffset = childADeleted ? childB.getStartOffset() : childB.getEndOffset();
                this.replaceText(requestor, startOffset, endOffset - startOffset, "");
                this.removeChild((Node)((Object)child));
                break;
            }
            ++i;
        }
    }

    public char getConnector() {
        Object[] children = this.getChildren();
        int i = 0;
        while (i < children.length - 1) {
            DTDNode childA = (DTDNode)((Object)children[i]);
            DTDNode childB = (DTDNode)((Object)children[i + 1]);
            RegionIterator iter = new RegionIterator(this.getStructuredDTDDocumentRegion(), childA.getEndOffset(), childB.getStartOffset());
            ITextRegion currentRegion = null;
            while (iter.hasNext() && currentRegion != childB.getStartRegion()) {
                currentRegion = iter.next();
                if (currentRegion.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.CONNECTOR") continue;
                this.connector = this.getStructuredDTDDocumentRegion().getText(currentRegion).charAt(0);
                return this.connector;
            }
            ++i;
        }
        return this.connector;
    }

    public String getImagePath() {
        switch (this.getConnector()) {
            case ',': {
                return "icons/full/obj16/onesequence.gif";
            }
            case '|': {
                return "icons/full/obj16/onechoice.gif";
            }
        }
        return null;
    }

    public String getName() {
        return "";
    }

    public ITextRegion getOccurrenceRegion() {
        int nesting = 0;
        RegionIterator iter = this.iterator();
        iter.next();
        ITextRegion currentRegion = null;
        while (iter.hasNext() && nesting >= 0) {
            currentRegion = iter.next();
            if (currentRegion.getType() == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.LEFT_PAREN") {
                ++nesting;
            }
            if (currentRegion.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.RIGHT_PAREN") continue;
            --nesting;
        }
        if (nesting < 0) {
            while (iter.hasNext()) {
                currentRegion = iter.next();
                if (currentRegion.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.OCCUR_TYPE") continue;
                return currentRegion;
            }
        }
        return iter.previous();
    }

    public String getType() {
        if (this.isRootElementContent() && this.getFirstChild() != null) {
            CMNode node = (CMNode)((Object)this.getFirstChild());
            if (node.getType().equals(PCDATA)) {
                return MIXED;
            }
            return CHILDREN;
        }
        return "";
    }

    public void insertChildNode(Object requestor, String nodeText, int position) {
        Object[] children = this.getChildren();
        int startOffset = 0;
        String newText = "";
        if (position < children.length) {
            DTDNode reference = (DTDNode)((Object)children[position]);
            startOffset = reference.getStartOffset();
            newText = String.valueOf(nodeText) + " " + String.valueOf(this.getConnector()) + " ";
        } else if (position == children.length) {
            DTDNode reference = (DTDNode)((Object)children[position - 1]);
            startOffset = reference.getEndOffset();
            newText = " " + String.valueOf(this.getConnector()) + " " + nodeText;
        }
        this.replaceText(requestor, startOffset, 0, newText);
    }

    public void insertChildNode(String nodeText, int position) {
        this.beginRecording((Object)this, DTDCoreMessages._UI_LABEL_CM_GRP_NODE_INSERT_ELEMENT);
        this.insertChildNode((Object)this, nodeText, position);
        this.endRecording((Object)this);
    }

    public void insertIntoModel(Object requestor, CMNode reference, CMNode node, boolean isAfter) {
        String nodeText = node.getNodeText();
        List children = this.getChildrenList();
        int index = children.indexOf((Object)reference);
        index = index == -1 ? children.size() : (isAfter ? index + 1 : index);
        this.insertChildNode(requestor, nodeText, index);
    }

    public void resolveRegions() {
        ITextRegion currentRegion;
        int nesting = 0;
        this.removeChildNodes();
        DTDNode currentGroupNode = null;
        DTDNode currentReferenceNode = null;
        RegionIterator iter = this.iterator();
        iter.next();
        while (iter.hasNext() && nesting >= 0) {
            currentRegion = iter.next();
            if (nesting == 0) {
                if (currentRegion.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.CONTENT_PCDATA")) {
                    currentReferenceNode = null;
                    currentGroupNode = null;
                    CMBasicNode pcData = new CMBasicNode(this.getDTDFile(), this.getStructuredDTDDocumentRegion());
                    pcData.addRegion(currentRegion);
                    this.appendChild((Node)((Object)pcData));
                } else if (currentRegion.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NAME")) {
                    currentGroupNode = null;
                    currentReferenceNode = new CMBasicNode(this.getDTDFile(), this.getStructuredDTDDocumentRegion());
                    currentReferenceNode.addRegion(currentRegion);
                    this.appendChild((Node)((Object)currentReferenceNode));
                } else if (currentRegion.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.OCCUR_TYPE")) {
                    if (currentReferenceNode != null) {
                        currentReferenceNode.addRegion(currentRegion);
                        currentReferenceNode = null;
                    }
                } else if (!currentRegion.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.CONNECTOR") && currentRegion.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.LEFT_PAREN") && currentGroupNode == null) {
                    currentReferenceNode = null;
                    currentGroupNode = new CMGroupNode(this.getDTDFile(), this.getStructuredDTDDocumentRegion());
                    this.appendChild((Node)((Object)currentGroupNode));
                }
            }
            if (currentRegion.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.LEFT_PAREN")) {
                ++nesting;
            }
            if (currentRegion.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.RIGHT_PAREN") && --nesting == 0 && currentGroupNode != null) {
                currentGroupNode.addRegion(currentRegion);
                if (iter.hasNext()) {
                    ITextRegion nextRegion = iter.next();
                    if (nextRegion.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.OCCUR_TYPE")) {
                        currentGroupNode.addRegion(nextRegion);
                    } else {
                        iter.previous();
                    }
                }
                currentGroupNode = null;
            }
            if (currentGroupNode == null) continue;
            currentGroupNode.addRegion(currentRegion);
        }
        if (nesting < 0) {
            while (iter.hasNext()) {
                currentRegion = iter.next();
                currentRegion.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.OCCUR_TYPE");
            }
        }
        Object[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            DTDNode currentNode = (DTDNode)((Object)children[i]);
            currentNode.resolveRegions();
            ++i;
        }
    }

    public void setConnector(char v) {
        if (this.connector != v) {
            this.connector = v;
            Object[] children = this.getChildren();
            if (children.length <= 1) {
                this.getDTDFile().notifyNodeChanged(this);
                return;
            }
            this.beginRecording((Object)this, DTDCoreMessages._UI_LABEL_CM_GRP_NODE_CONNECTOR);
            int i = 0;
            while (i < children.length - 1) {
                DTDNode childA = (DTDNode)((Object)children[i]);
                DTDNode childB = (DTDNode)((Object)children[i + 1]);
                RegionIterator iter = new RegionIterator(this.getStructuredDTDDocumentRegion(), childA.getEndOffset(), childB.getStartOffset());
                ITextRegion currentRegion = null;
                boolean foundConnector = false;
                while (iter.hasNext() && currentRegion != childB.getStartRegion()) {
                    currentRegion = iter.next();
                    if (currentRegion.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.CONNECTOR") continue;
                    foundConnector = true;
                    this.replaceText((Object)this, this.getStructuredDTDDocumentRegion().getStartOffset(currentRegion), 1, String.valueOf(this.connector));
                    break;
                }
                if (!foundConnector) {
                    this.replaceText((Object)this, childA.getEndOffset(), 0, String.valueOf(this.connector));
                }
                ++i;
            }
            this.endRecording((Object)this);
        }
    }
}

