/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.tasks.ui.query.internal;

import com.tasktop.c2c.server.common.service.domain.criteria.ColumnCriteria;
import com.tasktop.c2c.server.common.service.domain.criteria.Criteria;
import com.tasktop.c2c.server.common.service.domain.criteria.CriteriaBuilder;
import com.tasktop.c2c.server.common.service.domain.criteria.CriteriaParser;
import com.tasktop.c2c.server.common.service.domain.criteria.NaryCriteria;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import oracle.eclipse.tools.cloud.dev.tasks.ui.query.CustomQueryTerms;
import oracle.eclipse.tools.cloud.dev.tasks.ui.query.Query;
import oracle.eclipse.tools.cloud.dev.tasks.ui.query.QueryTerms;
import oracle.eclipse.tools.cloud.dev.tasks.ui.query.SavedQueryTerms;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.sapphire.util.ListFactory;

public final class QueryConverter {
    private static final String SUMMARY = "summary";
    private static final String DESCRIPTION = "description";
    private static final String COMMENT = "comment";
    private static final String PRODUCT_NAME = "productName";
    private static final String COMPONENT_NAME = "componentName";
    private static final String RELEASE = "release";
    private static final String ITERATION = "iteration";
    private static final String TYPE = "tasktype";
    private static final String PRIORITY = "priority";
    private static final String SEVERITY = "severity";
    private static final String STATUS = "status";
    private static final String RESOLUTION = "resolution";
    private static final String KEYWORDS = "keywords";
    private static final String CREATION_DATE = "creationDate";
    private static final String MODIFICATION_DATE = "modificationDate";
    private static final String CREATOR = "reporter";
    private static final String OWNER = "assignee";
    private static final String COMMENT_AUTHOR = "commentAuthor";
    private static final String WATCHER = "watcher";
    private static final String DATE_FORMAT = "yyyy-MM-dd";

    public static void convertToMylynQuery(Query query, IRepositoryQuery mq) {
        mq.setSummary(query.getName().text());
        QueryTerms terms = (QueryTerms)query.getTerms().content();
        if (terms instanceof CustomQueryTerms) {
            CustomQueryTerms qt = (CustomQueryTerms)terms;
            Criteria criteria = QueryConverter.readCriteriaFromQuery(qt);
            mq.setUrl("findTasksWithCriteria");
            mq.setAttribute("QueryCriteria", criteria.toString());
        } else if (terms instanceof SavedQueryTerms) {
            SavedQueryTerms qt = (SavedQueryTerms)terms;
            mq.setUrl("findTasksWithQuery");
            mq.setAttribute("QueryName", (String)qt.getReference().content());
        } else {
            throw new IllegalStateException();
        }
    }

    public static Criteria readCriteriaFromQuery(CustomQueryTerms qt) {
        Criteria criteria;
        boolean first;
        String persion;
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        String text = qt.getText().text();
        if (text != null && (((Boolean)qt.getFilterBySummary().content()).booleanValue() || ((Boolean)qt.getFilterByDescription().content()).booleanValue() || ((Boolean)qt.getFilterByComments().content()).booleanValue())) {
            CriteriaBuilder builder = new CriteriaBuilder();
            boolean first2 = true;
            if (((Boolean)qt.getFilterBySummary().content()).booleanValue()) {
                builder.column(SUMMARY, Criteria.Operator.STRING_CONTAINS, (Object)text);
                first2 = false;
            }
            if (((Boolean)qt.getFilterByDescription().content()).booleanValue()) {
                if (first2) {
                    builder.column(DESCRIPTION, Criteria.Operator.STRING_CONTAINS, (Object)text);
                    first2 = false;
                } else {
                    builder.or(DESCRIPTION, Criteria.Operator.STRING_CONTAINS, (Object)text);
                }
            }
            if (((Boolean)qt.getFilterByComments().content()).booleanValue()) {
                if (first2) {
                    builder.column(COMMENT, Criteria.Operator.STRING_CONTAINS, (Object)text);
                    first2 = false;
                } else {
                    builder.or(COMMENT, Criteria.Operator.STRING_CONTAINS, (Object)text);
                }
            }
            criteriaList.add(builder.toCriteria());
        }
        if ((persion = qt.getPerson().text()) != null && (((Boolean)qt.getFilterByCreator().content()).booleanValue() || ((Boolean)qt.getFilterByOwner().content()).booleanValue() || ((Boolean)qt.getFilterByCommenter().content()).booleanValue() || ((Boolean)qt.getFilterByObserver().content()).booleanValue())) {
            CriteriaBuilder builder = new CriteriaBuilder();
            first = true;
            if (((Boolean)qt.getFilterByCreator().content()).booleanValue()) {
                builder.column(CREATOR, Criteria.Operator.EQUALS, (Object)persion);
                first = false;
            }
            if (((Boolean)qt.getFilterByOwner().content()).booleanValue()) {
                if (first) {
                    builder.column(OWNER, Criteria.Operator.EQUALS, (Object)persion);
                    first = false;
                } else {
                    builder.or(OWNER, Criteria.Operator.EQUALS, (Object)persion);
                }
            }
            if (((Boolean)qt.getFilterByCommenter().content()).booleanValue()) {
                if (first) {
                    builder.column(COMMENT_AUTHOR, Criteria.Operator.EQUALS, (Object)persion);
                    first = false;
                } else {
                    builder.or(COMMENT_AUTHOR, Criteria.Operator.EQUALS, (Object)persion);
                }
            }
            if (((Boolean)qt.getFilterByObserver().content()).booleanValue()) {
                if (first) {
                    builder.column(WATCHER, Criteria.Operator.EQUALS, (Object)persion);
                    first = false;
                } else {
                    builder.or(WATCHER, Criteria.Operator.EQUALS, (Object)persion);
                }
            }
            criteriaList.add(builder.toCriteria());
        }
        if (!qt.getProducts().isEmpty()) {
            CriteriaBuilder builder = new CriteriaBuilder();
            first = true;
            for (Object entry : qt.getProducts()) {
                if (first) {
                    builder.column(PRODUCT_NAME, Criteria.Operator.EQUALS, (Object)entry.getProduct().text());
                    first = false;
                    continue;
                }
                builder.or(PRODUCT_NAME, Criteria.Operator.EQUALS, (Object)entry.getProduct().text());
            }
            criteriaList.add(builder.toCriteria());
        }
        if (!qt.getComponents().isEmpty()) {
            CriteriaBuilder builder = new CriteriaBuilder();
            first = true;
            for (Object entry : qt.getComponents()) {
                if (first) {
                    builder.column(COMPONENT_NAME, Criteria.Operator.EQUALS, (Object)entry.getComponent().text());
                    first = false;
                    continue;
                }
                builder.or(COMPONENT_NAME, Criteria.Operator.EQUALS, (Object)entry.getComponent().text());
            }
            criteriaList.add(builder.toCriteria());
        }
        if (!qt.getReleases().isEmpty()) {
            CriteriaBuilder builder = new CriteriaBuilder();
            first = true;
            for (Object entry : qt.getReleases()) {
                if (first) {
                    builder.column(RELEASE, Criteria.Operator.EQUALS, (Object)entry.getRelease().text());
                    first = false;
                    continue;
                }
                builder.or(RELEASE, Criteria.Operator.EQUALS, (Object)entry.getRelease().text());
            }
            criteriaList.add(builder.toCriteria());
        }
        if (!qt.getIterations().isEmpty()) {
            CriteriaBuilder builder = new CriteriaBuilder();
            first = true;
            for (Object entry : qt.getIterations()) {
                if (first) {
                    builder.column(ITERATION, Criteria.Operator.EQUALS, (Object)entry.getIteration().text());
                    first = false;
                    continue;
                }
                builder.or(ITERATION, Criteria.Operator.EQUALS, (Object)entry.getIteration().text());
            }
            criteriaList.add(builder.toCriteria());
        }
        if (!qt.getTypes().isEmpty()) {
            CriteriaBuilder builder = new CriteriaBuilder();
            first = true;
            for (Object entry : qt.getTypes()) {
                if (first) {
                    builder.column(TYPE, Criteria.Operator.EQUALS, (Object)entry.getType().text());
                    first = false;
                    continue;
                }
                builder.or(TYPE, Criteria.Operator.EQUALS, (Object)entry.getType().text());
            }
            criteriaList.add(builder.toCriteria());
        }
        if (!qt.getPriorities().isEmpty()) {
            CriteriaBuilder builder = new CriteriaBuilder();
            first = true;
            for (Object entry : qt.getPriorities()) {
                if (first) {
                    builder.column(PRIORITY, Criteria.Operator.EQUALS, (Object)entry.getPriority().text());
                    first = false;
                    continue;
                }
                builder.or(PRIORITY, Criteria.Operator.EQUALS, (Object)entry.getPriority().text());
            }
            criteriaList.add(builder.toCriteria());
        }
        if (!qt.getSeverities().isEmpty()) {
            CriteriaBuilder builder = new CriteriaBuilder();
            first = true;
            for (Object entry : qt.getSeverities()) {
                if (first) {
                    builder.column(SEVERITY, Criteria.Operator.EQUALS, (Object)entry.getSeverity().text());
                    first = false;
                    continue;
                }
                builder.or(SEVERITY, Criteria.Operator.EQUALS, (Object)entry.getSeverity().text());
            }
            criteriaList.add(builder.toCriteria());
        }
        if (!qt.getStatuses().isEmpty()) {
            CriteriaBuilder builder = new CriteriaBuilder();
            first = true;
            for (Object entry : qt.getStatuses()) {
                if (first) {
                    builder.column(STATUS, Criteria.Operator.EQUALS, (Object)entry.getStatus().text());
                    first = false;
                    continue;
                }
                builder.or(STATUS, Criteria.Operator.EQUALS, (Object)entry.getStatus().text());
            }
            criteriaList.add(builder.toCriteria());
        }
        if (!qt.getResolutions().isEmpty()) {
            CriteriaBuilder builder = new CriteriaBuilder();
            first = true;
            for (Object entry : qt.getResolutions()) {
                if (first) {
                    builder.column(RESOLUTION, Criteria.Operator.EQUALS, (Object)entry.getResolution().text());
                    first = false;
                    continue;
                }
                builder.or(RESOLUTION, Criteria.Operator.EQUALS, (Object)entry.getResolution().text());
            }
            criteriaList.add(builder.toCriteria());
        }
        if (!qt.getTags().isEmpty()) {
            CriteriaBuilder builder = new CriteriaBuilder();
            first = true;
            for (Object entry : qt.getTags()) {
                if (first) {
                    builder.column(KEYWORDS, Criteria.Operator.EQUALS, (Object)entry.getTag().text());
                    first = false;
                    continue;
                }
                builder.or(KEYWORDS, Criteria.Operator.EQUALS, (Object)entry.getTag().text());
            }
            criteriaList.add(builder.toCriteria());
        }
        if (qt.getCreatedAfter().content() != null || qt.getCreatedBefore().content() != null) {
            CriteriaBuilder builder = new CriteriaBuilder();
            first = true;
            if (qt.getCreatedAfter().content() != null) {
                builder.column(CREATION_DATE, Criteria.Operator.GREATER_THAN, (Object)QueryConverter.convertFromAfterDate((Date)qt.getCreatedAfter().content()));
                first = false;
            }
            if (qt.getCreatedBefore().content() != null) {
                if (first) {
                    builder.column(CREATION_DATE, Criteria.Operator.LESS_THAN, (Object)QueryConverter.convertFromBeforeDate((Date)qt.getCreatedBefore().content()));
                    first = false;
                } else {
                    builder.and(CREATION_DATE, Criteria.Operator.LESS_THAN, (Object)QueryConverter.convertFromBeforeDate((Date)qt.getCreatedBefore().content()));
                }
            }
            criteriaList.add(builder.toCriteria());
        }
        if (qt.getModifiedAfter().content() != null || qt.getModifiedBefore().content() != null) {
            CriteriaBuilder builder = new CriteriaBuilder();
            first = true;
            if (qt.getModifiedAfter().content() != null) {
                builder.column(MODIFICATION_DATE, Criteria.Operator.GREATER_THAN, (Object)QueryConverter.convertFromAfterDate((Date)qt.getModifiedAfter().content()));
                first = false;
            }
            if (qt.getModifiedBefore().content() != null) {
                if (first) {
                    builder.column(MODIFICATION_DATE, Criteria.Operator.LESS_THAN, (Object)QueryConverter.convertFromBeforeDate((Date)qt.getModifiedBefore().content()));
                    first = false;
                } else {
                    builder.and(MODIFICATION_DATE, Criteria.Operator.LESS_THAN, (Object)QueryConverter.convertFromBeforeDate((Date)qt.getModifiedBefore().content()));
                }
            }
            criteriaList.add(builder.toCriteria());
        }
        for (CustomQueryTerms.CustomFieldListEntry custom : qt.getCustomFields()) {
            CriteriaBuilder builder = new CriteriaBuilder();
            builder.column(custom.getName().text(), Criteria.Operator.EQUALS, (Object)custom.getValue().text());
            criteriaList.add(builder.toCriteria());
        }
        if (criteriaList.size() == 1) {
            criteria = (Criteria)criteriaList.get(0);
        } else {
            NaryCriteria naryCriteria = new NaryCriteria();
            naryCriteria.setOperator(Criteria.Operator.AND);
            naryCriteria.setSubCriteria(criteriaList);
            criteria = naryCriteria;
        }
        return criteria;
    }

    public static void convertFromMylynQuery(IRepositoryQuery mq, Query query) {
        query.setName(mq.getSummary());
        String url = mq.getUrl();
        if ("findTasksWithCriteria".equals(url)) {
            CustomQueryTerms qt = (CustomQueryTerms)query.getTerms().content(true, CustomQueryTerms.class);
            Criteria criteria = CriteriaParser.parse((String)mq.getAttribute("QueryCriteria"));
            QueryConverter.convertFromMylynQuery(criteria, qt);
        } else if ("findTasksWithQuery".equals(url)) {
            SavedQueryTerms qt = (SavedQueryTerms)query.getTerms().content(true, SavedQueryTerms.class);
            qt.setReference(mq.getAttribute("QueryName"));
        }
    }

    public static void convertFromMylynQuery(Criteria criteria, CustomQueryTerms qt) {
        String summary = null;
        String description = null;
        String comment = null;
        String creator = null;
        String owner = null;
        String commenter = null;
        String watcher = null;
        for (ColumnCriteria c : QueryConverter.extractColumnCriteria(criteria)) {
            String column = c.getColumnName();
            Object value = c.getColumnValue();
            Criteria.Operator operator = c.getOperator();
            if (column.equals(SUMMARY)) {
                summary = (String)value;
                continue;
            }
            if (column.equals(DESCRIPTION)) {
                description = (String)value;
                continue;
            }
            if (column.equals(COMMENT)) {
                comment = (String)value;
                continue;
            }
            if (column.equals(CREATOR)) {
                creator = (String)value;
                continue;
            }
            if (column.equals(OWNER)) {
                owner = (String)value;
                continue;
            }
            if (column.equals(COMMENT_AUTHOR)) {
                commenter = (String)value;
                continue;
            }
            if (column.equals(WATCHER)) {
                watcher = (String)value;
                continue;
            }
            if (column.equals(PRODUCT_NAME)) {
                ((CustomQueryTerms.ProductListEntry)qt.getProducts().insert()).setProduct((String)value);
                continue;
            }
            if (column.equals(COMPONENT_NAME)) {
                ((CustomQueryTerms.ComponentListEntry)qt.getComponents().insert()).setComponent((String)value);
                continue;
            }
            if (column.equals(RELEASE)) {
                ((CustomQueryTerms.ReleaseListEntry)qt.getReleases().insert()).setRelease((String)value);
                continue;
            }
            if (column.equals(ITERATION)) {
                ((CustomQueryTerms.IterationListEntry)qt.getIterations().insert()).setIteration((String)value);
                continue;
            }
            if (column.equals(TYPE)) {
                ((CustomQueryTerms.TypeListEntry)qt.getTypes().insert()).setType((String)value);
                continue;
            }
            if (column.equals(PRIORITY)) {
                ((CustomQueryTerms.PriorityListEntry)qt.getPriorities().insert()).setPriority((String)value);
                continue;
            }
            if (column.equals(SEVERITY)) {
                ((CustomQueryTerms.SeverityListEntry)qt.getSeverities().insert()).setSeverity((String)value);
                continue;
            }
            if (column.equals(STATUS)) {
                ((CustomQueryTerms.StatusListEntry)qt.getStatuses().insert()).setStatus((String)value);
                continue;
            }
            if (column.equals(RESOLUTION)) {
                ((CustomQueryTerms.ResolutionListEntry)qt.getResolutions().insert()).setResolution((String)value);
                continue;
            }
            if (column.equals(KEYWORDS)) {
                ((CustomQueryTerms.TagListEntry)qt.getTags().insert()).setTag((String)value);
                continue;
            }
            if (column.endsWith(CREATION_DATE)) {
                if (operator == Criteria.Operator.GREATER_THAN) {
                    qt.setCreatedAfter(QueryConverter.convertToAfterDate(value));
                    continue;
                }
                if (operator != Criteria.Operator.LESS_THAN) continue;
                qt.setCreatedBefore(QueryConverter.convertToBeforeDate(value));
                continue;
            }
            if (column.endsWith(MODIFICATION_DATE)) {
                if (operator == Criteria.Operator.GREATER_THAN) {
                    qt.setModifiedAfter(QueryConverter.convertToAfterDate(value));
                    continue;
                }
                if (operator != Criteria.Operator.LESS_THAN) continue;
                qt.setModifiedBefore(QueryConverter.convertToBeforeDate(value));
                continue;
            }
            CustomQueryTerms.CustomFieldListEntry custom = (CustomQueryTerms.CustomFieldListEntry)qt.getCustomFields().insert();
            custom.setName(column);
            custom.setValue((String)c.getColumnValue());
        }
        if (summary != null || comment != null || description != null) {
            if (summary == null) {
                qt.setFilterBySummary(false);
            } else {
                qt.setText(summary);
            }
            if (comment == null) {
                qt.setFilterByComments(false);
            } else {
                qt.setText(comment);
            }
            if (description == null) {
                qt.setFilterByDescription(false);
            } else {
                qt.setText(description);
            }
        }
        if (creator != null || owner != null || commenter != null || watcher != null) {
            if (creator == null) {
                qt.setFilterByCreator(false);
            } else {
                qt.setPerson(creator);
            }
            if (owner == null) {
                qt.setFilterByOwner(false);
            } else {
                qt.setPerson(owner);
            }
            if (commenter == null) {
                qt.setFilterByCommenter(false);
            } else {
                qt.setPerson(commenter);
            }
            if (watcher == null) {
                qt.setFilterByObserver(false);
            } else {
                qt.setPerson(watcher);
            }
        }
    }

    private static List<ColumnCriteria> extractColumnCriteria(Criteria criteria) {
        return QueryConverter.extractColumnCriteria(criteria, (ListFactory<ColumnCriteria>)ListFactory.start()).result();
    }

    private static ListFactory<ColumnCriteria> extractColumnCriteria(Criteria criteria, ListFactory<ColumnCriteria> result) {
        if (criteria instanceof ColumnCriteria) {
            result.add((Object)((ColumnCriteria)criteria));
        } else if (criteria instanceof NaryCriteria) {
            for (Criteria sub : ((NaryCriteria)criteria).getSubCriteria()) {
                QueryConverter.extractColumnCriteria(sub, result);
            }
        }
        return result;
    }

    private static String convertToAfterDate(Object time) {
        Date date = time instanceof Date ? (Date)time : new Date((Long)time);
        return new SimpleDateFormat(DATE_FORMAT).format(date);
    }

    private static Date convertFromAfterDate(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    private static String convertToBeforeDate(Object time) {
        Date date = time instanceof Date ? (Date)time : new Date((Long)time);
        return new SimpleDateFormat(DATE_FORMAT).format(date);
    }

    private static Date convertFromBeforeDate(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return new Date(calendar.getTimeInMillis());
    }
}

