/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.tasks.ui.action;

import com.tasktop.c2c.server.cloud.domain.ServiceType;
import com.tasktop.c2c.server.profile.domain.project.ProjectService;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.CloudProjectService;
import oracle.eclipse.tools.cloud.dev.tasks.ui.CloudDevUiUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class NewTaskQueryActionDelegate
implements IViewActionDelegate {
    protected CloudProjectService element = null;

    public void run(IAction action) {
        if (this.element != null) {
            ProjectService ps = this.element.getProjectService();
            if (ps.getServiceType() != ServiceType.TASKS) {
                return;
            }
            String url = ps.getUrl();
            CloudProject cp = this.element.getCloudProject();
            TaskRepository taskRepository = CloudDevUiUtil.getTaskRepoitory(url, cp);
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi((String)taskRepository.getConnectorKind());
            final IWizard queryWizard = connectorUi.getQueryWizard(taskRepository, null);
            Display.getDefault().getActiveShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    WizardDialog queryDialog = new WizardDialog(WorkbenchUtil.getShell(), queryWizard);
                    queryDialog.create();
                    queryDialog.setBlockOnOpen(true);
                    queryDialog.open();
                    String viewId = "org.eclipse.mylyn.tasks.ui.views.tasks";
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewId);
                    }
                    catch (Exception exception) {}
                }
            });
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        TreeSelection ts = null;
        ts = (TreeSelection)selection;
        if (ts.getFirstElement() instanceof CloudProjectService) {
            this.element = (CloudProjectService)ts.getFirstElement();
            if (this.element.getProjectService().getServiceType() == ServiceType.TASKS) {
                action.setEnabled(this.element.isActivated());
                return;
            }
        }
        action.setEnabled(false);
    }

    public void init(IViewPart view) {
    }
}

