/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.tasks.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.cloud.dev.BuiltInQuery;
import oracle.eclipse.tools.cloud.dev.TaskService;
import oracle.eclipse.tools.cloud.dev.UserDefinedQuery;
import oracle.eclipse.tools.cloud.ui.internal.FetchingRemoteDataNode;
import oracle.eclipse.tools.cloud.ui.profile.CloudProfileView;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.UIJob;

public class CloudViewTasksContentProvider
implements ITreeContentProvider {
    private ITaskListChangeListener taskChangeListener = null;
    private IRepositoryListener repositoryListener = null;
    private List<TaskService> taskServices = new ArrayList<TaskService>();
    private CommonViewer viewer;

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object inputElement) {
        if (inputElement instanceof TaskService) {
            TaskService ts = (TaskService)inputElement;
            ListFactory ret = ListFactory.start();
            if (ts.isActivated()) {
                ret.add((Collection)ts.getQueries());
            }
            return ret.result().toArray();
        }
        if (inputElement instanceof UserDefinedQuery) {
            RepositoryQuery q = ((UserDefinedQuery)inputElement).getRepositoryQuery();
            if (q.isSynchronizing()) {
                return new Object[]{FetchingRemoteDataNode.INSTANCE};
            }
            String s = q.getLastSynchronizedTimeStamp();
            if (!s.equals("<never>")) {
                Collection ret = q.getChildren();
                return ret.toArray();
            }
            CloudViewTasksContentProvider.synchronizeQuery((UserDefinedQuery)inputElement, this.viewer);
            if (q.isSynchronizing()) {
                return new Object[]{FetchingRemoteDataNode.INSTANCE};
            }
        }
        return null;
    }

    public static void synchronizeQuery(final UserDefinedQuery inputElement, final CommonViewer viewer) {
        RepositoryQuery q = inputElement.getRepositoryQuery();
        String url = q.getRepositoryUrl();
        TaskRepository taskRepo = CloudViewTasksContentProvider.findRepo(url);
        if (taskRepo != null) {
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(taskRepo.getConnectorKind());
            JobChangeAdapter listener = new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    UIJob job = new UIJob(""){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            viewer.setExpandedState((Object)inputElement, true);
                            viewer.refresh((Object)inputElement);
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            };
            TasksUiInternal.synchronizeQuery((AbstractRepositoryConnector)connector, (RepositoryQuery)q, (IJobChangeListener)listener, (boolean)true);
        }
    }

    public static TaskRepository findRepo(String url) {
        IRepositoryManager repoMgr = TasksUi.getRepositoryManager();
        for (TaskRepository repo : repoMgr.getAllRepositories()) {
            if (!repo.getUrl().equals(url)) continue;
            return repo;
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof BuiltInQuery) {
            return ((BuiltInQuery)element).getTaskService();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TaskService) {
            TaskService ts = (TaskService)element;
            if (!this.taskServices.contains(ts)) {
                this.taskServices.add(0, ts);
            }
            return ts.isActivated();
        }
        return element instanceof UserDefinedQuery;
    }

    public void dispose() {
        TasksUiPlugin.getTaskList().removeChangeListener(this.taskChangeListener);
        TasksUiPlugin.getRepositoryManager().removeListener(this.repositoryListener);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (CommonViewer)viewer;
        if (this.taskChangeListener == null) {
            this.taskChangeListener = new ITaskListChangeListener(){

                public void containersChanged(Set<TaskContainerDelta> containers) {
                    for (TaskContainerDelta delta : containers) {
                        if (!(delta.getElement() instanceof RepositoryQuery)) continue;
                        RepositoryQuery query = (RepositoryQuery)delta.getElement();
                        TaskService ts = CloudViewTasksContentProvider.this.getTaskService(query.getRepositoryUrl());
                        if (ts != null && delta.getKind() == TaskContainerDelta.Kind.REMOVED) {
                            ts.deleteQuery(query);
                        } else if (ts != null && delta.getKind() == TaskContainerDelta.Kind.ADDED) {
                            ts.setActivated(true);
                        }
                        if (ts == null) continue;
                        CloudViewTasksContentProvider.this.refreshViewer(ts);
                    }
                }
            };
            TasksUiPlugin.getTaskList().addChangeListener(this.taskChangeListener);
            this.repositoryListener = new IRepositoryListener(){

                public void repositoryUrlChanged(TaskRepository repository, String oldUrl) {
                }

                public void repositorySettingsChanged(TaskRepository repository) {
                }

                public void repositoryRemoved(TaskRepository repository) {
                    for (TaskService ts : CloudViewTasksContentProvider.this.taskServices) {
                        if (!repository.getUrl().equals(ts.getProjectService().getUrl())) continue;
                        CloudViewTasksContentProvider.this.refreshViewer(ts);
                        return;
                    }
                }

                public void repositoryAdded(TaskRepository repository) {
                }
            };
            TasksUiPlugin.getRepositoryManager().addListener(this.repositoryListener);
        }
    }

    private TaskService getTaskService(String url) {
        for (TaskService ts : this.taskServices) {
            if (!url.equals(ts.getProjectService().getUrl())) continue;
            return ts;
        }
        return null;
    }

    private void refreshViewer(final TaskService taskService) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CloudProfileView cloudView = CloudProfileView.getFromActivePerspective();
                if (cloudView != null) {
                    cloudView.refresh((Object)taskService);
                }
            }
        });
    }

    public static class SynchronizingNode {
        String label = null;

        SynchronizingNode(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

