/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.tasks.ui;

import com.tasktop.c2c.server.tasks.domain.Component;
import com.tasktop.c2c.server.tasks.domain.Milestone;
import com.tasktop.c2c.server.tasks.domain.Product;
import com.tasktop.c2c.server.tasks.domain.RepositoryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.cloud.dev.tasks.CloudDevAttribute;
import oracle.eclipse.tools.cloud.dev.tasks.CloudDevRepositoryConnector;
import oracle.eclipse.tools.cloud.dev.tasks.CloudDevTasksConnectorBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.internal.tasks.ui.editors.CheckboxMultiSelectAttributeEditor;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelEvent;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelListener;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;
import org.eclipse.ui.services.IServiceLocator;

public class CloudDevTaskEditorPage
extends AbstractTaskEditorPage {
    private ProductSelectionListener productListener;
    private final Map<TaskAttribute, AbstractAttributeEditor> attributeEditorMap;

    public CloudDevTaskEditorPage(TaskEditor editor) {
        super(editor, "CloudDev");
        this.setNeedsPrivateSection(true);
        this.setNeedsSubmitButton(true);
        this.attributeEditorMap = new HashMap<TaskAttribute, AbstractAttributeEditor>();
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        Set descriptors = super.createPartDescriptors();
        return descriptors;
    }

    protected AttributeEditorFactory createAttributeEditorFactory() {
        return new CloudDevAttributeEditorFactory(this.getModel(), this.getTaskRepository(), (IServiceLocator)this.getEditorSite());
    }

    protected void createParts() {
        this.attributeEditorMap.clear();
        super.createParts();
    }

    protected TaskDataModel createModel(TaskEditorInput input) throws CoreException {
        TaskDataModel model = super.createModel(input);
        this.productListener = new ProductSelectionListener();
        model.addModelListener((TaskDataModelListener)this.productListener);
        return model;
    }

    private void addToAttributeEditorMap(TaskAttribute attribute, AbstractAttributeEditor editor) {
        if (this.attributeEditorMap.containsKey(attribute)) {
            this.attributeEditorMap.remove(attribute);
        }
        this.attributeEditorMap.put(attribute, editor);
    }

    private void refresh(TaskAttribute attribute) {
        AbstractAttributeEditor editor = this.attributeEditorMap.get(attribute);
        if (editor != null) {
            try {
                editor.refresh();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    private Product getProduct(RepositoryConfiguration repositoryConfiguration, String value) {
        if (value != null) {
            for (Product product : repositoryConfiguration.getProducts()) {
                if (!value.equals(product.getName())) continue;
                return product;
            }
        }
        return null;
    }

    private class CloudDevAttributeEditorFactory
    extends AttributeEditorFactory {
        public CloudDevAttributeEditorFactory(TaskDataModel model, TaskRepository taskRepository, IServiceLocator serviceLocator) {
            super(model, taskRepository, serviceLocator);
        }

        public AbstractAttributeEditor createEditor(String type, TaskAttribute taskAttribute) {
            Object editor = "cloud.dev.cc".equals(type) ? new CheckboxMultiSelectAttributeEditor(CloudDevTaskEditorPage.this.getModel(), taskAttribute) : ("cloud.dev.keywords".equals(type) ? new CheckboxMultiSelectAttributeEditor(CloudDevTaskEditorPage.this.getModel(), taskAttribute) : super.createEditor(type, taskAttribute));
            CloudDevTaskEditorPage.this.addToAttributeEditorMap(taskAttribute, (AbstractAttributeEditor)editor);
            return editor;
        }
    }

    private class ProductSelectionListener
    extends TaskDataModelListener {
        private ProductSelectionListener() {
        }

        public void attributeChanged(TaskDataModelEvent event) {
            TaskAttribute taskAttribute = event.getTaskAttribute();
            if (taskAttribute != null && taskAttribute.getId().equals("task.common.product")) {
                TaskRepository repository = CloudDevTaskEditorPage.this.getModel().getTaskRepository();
                RepositoryConfiguration repositoryConfiguration = null;
                AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)repository.getConnectorKind());
                if (connector instanceof CloudDevRepositoryConnector) {
                    try {
                        repositoryConfiguration = ((CloudDevRepositoryConnector)connector).getRepositoryConfiguration(repository, false, null);
                    }
                    catch (CoreException coreException) {
                        RepositoryStatus status = RepositoryStatus.createNotFoundError((String)repository.getRepositoryUrl(), (String)CloudDevTasksConnectorBundle.ID);
                        CloudDevTaskEditorPage.this.getTaskEditor().setMessage(status.getMessage(), 3);
                        return;
                    }
                }
                TaskAttribute root = taskAttribute.getTaskData().getRoot();
                Product product = CloudDevTaskEditorPage.this.getProduct(repositoryConfiguration, taskAttribute.getValue());
                if (product != null) {
                    TaskAttribute milestoneAttribute;
                    TaskAttribute componentAttribute = root.getAttribute(CloudDevAttribute.COMPONENT.getTaskName());
                    if (componentAttribute != null) {
                        componentAttribute.clearOptions();
                        for (Component component : repositoryConfiguration.getComponents(product)) {
                            componentAttribute.putOption(component.getName(), component.getName());
                        }
                        if (product.getDefaultComponent() != null) {
                            componentAttribute.setValue(product.getDefaultComponent().getName());
                        }
                        CloudDevTaskEditorPage.this.refresh(componentAttribute);
                    }
                    if ((milestoneAttribute = root.getAttribute(CloudDevAttribute.MILESTONE.getTaskName())) != null) {
                        milestoneAttribute.clearOptions();
                        for (Milestone milestone : repositoryConfiguration.getMilestones(product)) {
                            milestoneAttribute.putOption(milestone.getValue(), milestone.getValue());
                        }
                        if (product.getDefaultMilestone() != null) {
                            milestoneAttribute.setValue(product.getDefaultMilestone().getValue());
                        }
                        CloudDevTaskEditorPage.this.refresh(milestoneAttribute);
                    }
                }
            }
        }
    }
}

