/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.ui.internal.menus.ActionSet;
import org.eclipse.ui.internal.menus.MenuHelper;

public class EditorAction
extends ActionSet {
    private IConfigurationElement parent;

    public EditorAction(MApplication application, IEclipseContext appContext, IConfigurationElement parent, IConfigurationElement element) {
        super(application, appContext, element);
        this.parent = parent;
    }

    @Override
    public void addToModel(ArrayList<MMenuContribution> menuContributions, ArrayList<MToolBarContribution> toolBarContributions, ArrayList<MTrimContribution> trimContributions) {
        String idContrib = MenuHelper.getId(this.configElement);
        this.visibleWhen = this.createExpression(this.configElement);
        EContextService contextService = (EContextService)this.application.getContext().get(EContextService.class);
        Context actionSetContext = contextService.getContext(idContrib);
        if (!actionSetContext.isDefined()) {
            actionSetContext.define(MenuHelper.getLabel(this.configElement), MenuHelper.getDescription(this.configElement), "org.eclipse.ui.contexts.actionSet");
        }
        this.addContribution(idContrib, menuContributions, this.configElement, false, "org.eclipse.ui.main.menu");
        this.addToolBarContribution(idContrib, toolBarContributions, trimContributions, this.configElement, "org.eclipse.ui.main.toolbar");
    }

    @Override
    protected Expression createExpression(IConfigurationElement configElement) {
        String idContrib = MenuHelper.getId(configElement);
        return new ActiveEditorContextExpression(this.parent.getAttribute("targetID"), idContrib);
    }

    static class ActiveEditorContextExpression
    extends Expression {
        private String editorId;
        private String actionId;

        public ActiveEditorContextExpression(String editorId, String actionId) {
            this.editorId = editorId;
            this.actionId = actionId;
        }

        public void collectExpressionInfo(ExpressionInfo info) {
            info.addVariableNameAccess("activeEditorId");
        }

        public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
            Object activeEditorId = context.getVariable("activeEditorId");
            if (activeEditorId instanceof String) {
                return EvaluationResult.valueOf((boolean)this.editorId.equals(activeEditorId));
            }
            return EvaluationResult.FALSE;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ActiveEditorContextExpression)) {
                return false;
            }
            ActiveEditorContextExpression other = (ActiveEditorContextExpression)((Object)obj);
            return this.actionId.equals(other.actionId) && this.editorId.equals(other.editorId);
        }

        public int hashCode() {
            return this.actionId.hashCode() * this.editorId.hashCode();
        }
    }
}

