/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.util;

import java.io.File;
import java.util.ArrayList;
import oracle.eclipse.tools.common.util.StringUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class URIUtil {
    private static final char SEGMENT_SEPARATOR = '/';

    public IPath convertToPath(URI uri) {
        ArrayList pathList;
        String leading;
        String string = leading = uri.hasAbsolutePath() ? "/" : "";
        if (uri.isFile()) {
            return new Path(uri.device(), String.valueOf(leading) + uri.path());
        }
        if (uri.isPlatformResource() && (pathList = new ArrayList(uri.segmentsList())).size() > 0) {
            pathList.remove(0);
            String joined = StringUtil.join(pathList, (char)'/');
            return new Path(String.valueOf(leading) + joined);
        }
        throw new IllegalArgumentException(String.format("%s is not supported", uri.toString()));
    }

    public URI convertToPlatformResourceUri(IPath fullPath) {
        return URI.createPlatformResourceURI((String)fullPath.toString(), (boolean)false);
    }

    public boolean isWebRelative(URI uri) {
        return "web".equals(uri.scheme()) && "root".equals(uri.segments()[0]);
    }

    public URI createWebRelative(String path) {
        return URIUtil.createWebRelative("web:/root", "web:/root/", path);
    }

    public String getPath(URI webRelative) {
        if (!this.isWebRelative(webRelative)) {
            throw new AssertionError((Object)String.format("%s is not a web relative uri", webRelative));
        }
        ArrayList segments = new ArrayList(webRelative.segmentsList());
        segments.remove(0);
        String joined = StringUtil.join(segments, (char)'/');
        if (webRelative.hasAbsolutePath()) {
            joined = "/" + joined;
        }
        return joined;
    }

    private static URI createWebRelative(String unrootedBase, String rootedBase, String pathName) {
        String safePathName = pathName;
        if (File.separatorChar != '/') {
            safePathName = safePathName.replace(File.separatorChar, '/');
        }
        URI result = URI.createURI((String)(String.valueOf(safePathName.charAt(0) == '/' ? unrootedBase : rootedBase) + safePathName));
        return result;
    }
}

