/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class StringUtil {
    public static String padLeft(String str, char padChar, int len) {
        if (str == null) {
            return null;
        }
        String retValue = str;
        int strLen = retValue.length();
        if (strLen < len) {
            StringBuffer buffer = new StringBuffer(len);
            int count = len - strLen;
            int i = 0;
            while (i < count) {
                buffer.append(padChar);
                ++i;
            }
            buffer.append(retValue);
            retValue = buffer.toString();
        }
        return retValue;
    }

    public static String quote(String str, char c) {
        assert (str != null);
        StringBuffer buffer = new StringBuffer(str.length() + 2);
        buffer.append(c);
        buffer.append(str);
        buffer.append(c);
        return buffer.toString();
    }

    public static String doubleQuote(String str) {
        return StringUtil.quote(str, '\"');
    }

    public static String unquote(String quoted) {
        if (quoted != null && quoted.length() >= 2) {
            char lastChar;
            int len = quoted.length();
            char firstChar = quoted.charAt(0);
            if (firstChar == (lastChar = quoted.charAt(len - 1)) && (firstChar == '\'' || firstChar == '\"')) {
                return quoted.substring(1, len - 1);
            }
        }
        return quoted;
    }

    public static String truncate(String s, int maxLen) {
        if (s == null) {
            return null;
        }
        String retValue = s;
        int len = retValue.length();
        if (len > maxLen) {
            int segmentLen = maxLen / 2;
            retValue = String.valueOf(retValue.substring(0, segmentLen)) + "..." + retValue.substring(len - segmentLen);
        }
        return retValue;
    }

    public static String repeat(char c, int count) {
        StringBuffer buffer = new StringBuffer(count);
        int i = 0;
        while (i < count) {
            buffer.append(c);
            ++i;
        }
        return buffer.toString();
    }

    public static String nullIfEmpty(String s) {
        if (s != null && s.length() == 0) {
            return null;
        }
        return s;
    }

    public static String getVisibleString(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c <= '\u001f' || c == ' ' && (i == 0 || i == len - 1)) {
                buffer.append("(0x" + Integer.toHexString(c).toUpperCase() + ")");
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String strReplace(String str, int offset, int len, String replaceStr) {
        StringBuffer buffer = new StringBuffer(str.length() - len + replaceStr.length());
        buffer.append(str.substring(0, offset));
        buffer.append(replaceStr);
        buffer.append(str.substring(offset + len));
        return buffer.toString();
    }

    public static String strReplace(String str, String pattern, String replaceStr) {
        if (str == null) {
            return null;
        }
        if (pattern == null || pattern.equals("")) {
            return str;
        }
        int index = str.indexOf(pattern);
        if (index < 0) {
            return str;
        }
        String workingCopy = replaceStr;
        if (workingCopy == null) {
            workingCopy = "";
        }
        return String.valueOf(str.substring(0, index)) + workingCopy + str.substring(index + pattern.length());
    }

    public static String strReplaceAll(String str, String pattern, String replaceStr) {
        if (str == null) {
            return null;
        }
        String workingReplaceStr = replaceStr;
        if (workingReplaceStr == null) {
            workingReplaceStr = "";
        }
        if (pattern == null || pattern.equals("")) {
            return str;
        }
        int index = str.indexOf(pattern);
        String workingCopy = str;
        while (index >= 0) {
            workingCopy = String.valueOf(workingCopy.substring(0, index)) + workingReplaceStr + workingCopy.substring(index + pattern.length());
            index = workingCopy.indexOf(pattern, index + workingReplaceStr.length());
        }
        return workingCopy;
    }

    public static String strInsert(String str, int index, String insertStr) {
        return String.valueOf(str.substring(0, index)) + insertStr + str.substring(index);
    }

    public static List<String> strToList(String s, char sep, boolean trim) {
        if (s == null || s.length() == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        char[] delimiters = new char[]{sep};
        StringTokenizer tokenizer = new StringTokenizer(s, new String(delimiters), true);
        String lastTok = null;
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (tok.length() == 1 && tok.charAt(0) == sep) {
                if (tok.equals(lastTok) || lastTok == null) {
                    result.add("");
                }
            } else {
                if (trim) {
                    tok = tok.trim();
                }
                result.add(tok);
            }
            lastTok = tok;
        }
        if (lastTok != null && lastTok.length() == 1 && lastTok.charAt(0) == sep) {
            result.add("");
        }
        result.trimToSize();
        return result;
    }

    public static List<String> strToList(String s, char sep) {
        return StringUtil.strToList(s, sep, false);
    }

    public static String listToStr(Collection<Object> a, char sep) {
        return StringUtil.listToStr(a, String.valueOf(sep));
    }

    public static String listToStr(Collection<Object> a, String sep) {
        if (a == null) {
            return null;
        }
        int count = a.size();
        if (count == 0) {
            return null;
        }
        StringBuffer buffer = null;
        for (Object obj : a) {
            if (obj == null) continue;
            if (buffer == null) {
                buffer = new StringBuffer();
            } else {
                buffer.append(sep);
            }
            if (obj instanceof String) {
                buffer.append((String)obj);
                continue;
            }
            buffer.append(obj);
        }
        return buffer != null ? buffer.toString() : null;
    }

    public static Map<String, String> strToMap(String s, char sep1, char sep2) {
        return StringUtil.strToMap(s, sep1, sep2, false);
    }

    public static Map<String, String> strToMap(String s, char sep1, char sep2, boolean lowercaseKeys) {
        if (s == null || s.length() == 0) {
            return Collections.emptyMap();
        }
        List<String> a = StringUtil.strToList(s, sep2);
        if (a == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hm = new HashMap<String, String>();
        int count = a.size();
        int i = 0;
        while (i < count) {
            String s2 = a.get(i);
            int pos = s2.indexOf(sep1);
            if (pos >= 0) {
                String name = s2.substring(0, pos);
                String val = s2.substring(pos + 1);
                if (lowercaseKeys) {
                    name = name.toLowerCase();
                }
                hm.put(name, val);
            }
            ++i;
        }
        return hm;
    }

    public static String mapToStr(Map<Object, Object> hm, char sep1, char sep2) {
        if (hm == null || hm.isEmpty()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator<Map.Entry<Object, Object>> iter = hm.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            buffer.append(entry.getKey());
            buffer.append(sep1);
            buffer.append(entry.getValue());
            if (!iter.hasNext()) continue;
            buffer.append(sep2);
        }
        return buffer.toString();
    }

    public static boolean compareAsStrings(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return obj1 == obj2;
        }
        String s1 = obj1 instanceof String ? (String)obj1 : obj1.toString();
        String s2 = obj2 instanceof String ? (String)obj2 : obj2.toString();
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean startsWithAny(String s, List<String> prefixes) {
        int count = prefixes.size();
        int i = 0;
        while (i < count) {
            if (s.startsWith(prefixes.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String initUpper(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return String.valueOf(Character.toUpperCase(str.charAt(0))) + str.substring(1);
    }

    public static String initLower(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return String.valueOf(Character.toLowerCase(str.charAt(0))) + str.substring(1);
    }

    public static boolean isUpperCase(String s) {
        return s.toUpperCase().equals(s);
    }

    public static int skipWhiteSpaces(String str, int index) {
        int len = str.length();
        int runningIndex = index;
        while (runningIndex < len) {
            if (!Character.isWhitespace(str.charAt(runningIndex))) break;
            ++runningIndex;
        }
        return runningIndex;
    }

    public static String collapseWhiteSpaces(String str) {
        String result = null;
        if (str != null) {
            StringBuffer buffer = new StringBuffer();
            boolean isInWhiteSpace = false;
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                if (Character.isWhitespace(c)) {
                    isInWhiteSpace = true;
                } else {
                    if (isInWhiteSpace) {
                        buffer.append(" ");
                    }
                    isInWhiteSpace = false;
                    buffer.append(c);
                }
                ++i;
            }
            result = buffer.toString();
        }
        return result;
    }

    public static String removeWhiteSpaces(String s) {
        boolean found = false;
        int wsIndex = -1;
        int size = s.length();
        int i = 0;
        while (i < size) {
            found = Character.isWhitespace(s.charAt(i));
            if (found) {
                wsIndex = i;
                break;
            }
            ++i;
        }
        if (!found) {
            return s;
        }
        StringBuffer result = new StringBuffer(s.substring(0, wsIndex));
        int i2 = wsIndex + 1;
        while (i2 < size) {
            char ch = s.charAt(i2);
            if (!Character.isWhitespace(ch)) {
                result.append(ch);
            }
            ++i2;
        }
        return result.toString();
    }
}

