/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.util;

public final class ObjectUtil {
    public static final boolean IGNORE_CASE_IF_STRING = true;
    private static final EqualsComparator<Object, Object> EQUALS_COMPARATOR_WITH_CASE = new DefaultEqualsComparator(false);
    private static final EqualsComparator<Object, Object> EQUALS_COMPARATOR_IGNORE_CASE = new DefaultEqualsComparator(true);

    public static String getPackageName(String className) {
        if (className == null) {
            return null;
        }
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return null;
        }
        return className.substring(0, lastDotIndex);
    }

    public static String getClassName(String fullClassName) {
        if (fullClassName == null) {
            return null;
        }
        int lastDotIndex = fullClassName.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return fullClassName;
        }
        return fullClassName.substring(lastDotIndex + 1);
    }

    public static boolean equalObjects(Object o1, Object o2) {
        return ObjectUtil.getDefaultEqualsComparator(false).equals(o1, o2);
    }

    public static boolean equalObjects(Object o1, Object o2, boolean ignoreCaseIfStr) {
        return ObjectUtil.getDefaultEqualsComparator(ignoreCaseIfStr).equals(o1, o2);
    }

    public static EqualsComparator<Object, Object> getDefaultEqualsComparator(boolean ignoreCase) {
        if (ignoreCase) {
            return EQUALS_COMPARATOR_IGNORE_CASE;
        }
        return EQUALS_COMPARATOR_WITH_CASE;
    }

    private ObjectUtil() {
    }

    private static final class DefaultEqualsComparator
    extends EqualsComparator<Object, Object> {
        private final boolean _ignoreCase;

        public DefaultEqualsComparator(boolean ignoreCase) {
            this._ignoreCase = ignoreCase;
        }

        @Override
        public boolean equals(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            boolean result = this._ignoreCase && o1 instanceof String && o2 instanceof String ? ((String)o1).equalsIgnoreCase((String)o2) : o1.equals(o2);
            return result;
        }
    }

    public static abstract class EqualsComparator<TYPE1, TYPE2> {
        public abstract boolean equals(TYPE1 var1, TYPE2 var2);
    }
}

