/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JpaContextRoot;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;

public class JPAUtils {
    public static List<JpaProject> getJpaProjects(IProject project) {
        JpaProject jpaProj;
        if (project == null || !project.isAccessible()) {
            return Collections.emptyList();
        }
        ArrayList<JpaProject> jpaProjList = new ArrayList<JpaProject>();
        IProject earProject = WtpProjectUtil.findReferencingEarProject((IProject)project);
        Set projects = null;
        if (earProject != null) {
            projects = WtpProjectUtil.findProjectsReferencedByEar((IProject)earProject);
            for (IProject proj : projects) {
                JpaProject jpaPr = (JpaProject)proj.getAdapter(JpaProject.class);
                if (jpaPr == null) continue;
                jpaProjList.add(jpaPr);
            }
        }
        if (!((jpaProj = (JpaProject)project.getAdapter(JpaProject.class)) == null || projects != null && projects.contains(project))) {
            jpaProjList.add(jpaProj);
        }
        return Collections.unmodifiableList(jpaProjList);
    }

    public static List<Entity> getEntities(IProject project) {
        Persistence persistence;
        JpaContextRoot rootContextNode;
        PersistenceXml pXml;
        JpaProject jpaProject;
        ArrayList<Entity> entities = new ArrayList<Entity>();
        if (project != null && (jpaProject = (JpaProject)project.getAdapter(JpaProject.class)) != null && (pXml = (rootContextNode = jpaProject.getContextRoot()).getPersistenceXml()) != null && (persistence = pXml.getRoot()) != null) {
            PersistenceUnit pu = (PersistenceUnit)persistence.getPersistenceUnits().iterator().next();
            Iterator iterator = pu.getEntities().iterator();
            while (iterator.hasNext()) {
                entities.add((Entity)iterator.next());
            }
        }
        return Collections.unmodifiableList(entities);
    }

    public static String getPersistanceUnitName(IProject project, String entityName) {
        Persistence persistence;
        JpaContextRoot rootContextNode;
        PersistenceXml pXml;
        JpaProject jpaProject;
        if (project != null && (jpaProject = (JpaProject)project.getAdapter(JpaProject.class)) != null && (pXml = (rootContextNode = jpaProject.getContextRoot()).getPersistenceXml()) != null && (persistence = pXml.getRoot()) != null) {
            PersistenceUnit pu = (PersistenceUnit)persistence.getPersistenceUnits().iterator().next();
            for (Entity entity : pu.getEntities()) {
                String puEntityName = entity.getPersistentType().getName();
                if (!puEntityName.equals(entityName)) continue;
                return pu.getName();
            }
        }
        return null;
    }

    public static boolean isJpaProject(IProject project) {
        if (!project.isAccessible()) {
            return false;
        }
        JpaProject jpaPr = (JpaProject)project.getAdapter(JpaProject.class);
        return jpaPr != null;
    }
}

