/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.util;

import java.io.File;
import oracle.eclipse.tools.common.services.util.URIUtil;
import oracle.eclipse.tools.common.services.util.WebRelativeURIHandler;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.FileURIHandlerImpl;

public class FileWebRelativeURIHandler
extends WebRelativeURIHandler {
    private final File _webRootDir;

    public FileWebRelativeURIHandler(File webRootDir, URIUtil uriUtil) {
        super((URIHandler)new FileURIHandlerImpl(), uriUtil);
        if (!webRootDir.isDirectory()) {
            throw new AssertionError((Object)String.format("%s must be a directory", webRootDir.toString()));
        }
        this._webRootDir = webRootDir;
    }

    @Override
    protected URI convertToDelegateType(URI webRelativeUri) {
        String path = this.getUriUtil().getPath(webRelativeUri);
        return URI.createFileURI((String)new File(this._webRootDir, path).getAbsolutePath());
    }
}

