/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.common.services.util.URIUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;

public abstract class AbstractDelegatingURIHandler
extends URIHandlerImpl {
    private final URIHandler _delegate;
    private final URIUtil _uriUtil;

    public AbstractDelegatingURIHandler(URIHandler delegate, URIUtil uriUtil) {
        this._uriUtil = uriUtil;
        this._delegate = delegate;
    }

    public abstract boolean canHandle(URI var1);

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        this.assertInputType(uri);
        return this._delegate.createOutputStream(this.convertToDelegateType(uri), this.ensureNotNull(options));
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        this.assertInputType(uri);
        return this._delegate.createInputStream(this.convertToDelegateType(uri), this.ensureNotNull(options));
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        this.assertInputType(uri);
        this._delegate.delete(this.convertToDelegateType(uri), this.ensureNotNull(options));
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        this.assertInputType(uri);
        return this._delegate.exists(this.convertToDelegateType(uri), this.ensureNotNull(options));
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        this.assertInputType(uri);
        return this._delegate.contentDescription(this.convertToDelegateType(uri), this.ensureNotNull(options));
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        this.assertInputType(uri);
        return this._delegate.getAttributes(this.convertToDelegateType(uri), this.ensureNotNull(options));
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        this.assertInputType(uri);
        this._delegate.setAttributes(this.convertToDelegateType(uri), attributes, this.ensureNotNull(options));
    }

    private Map<?, ?> ensureNotNull(Map<?, ?> options) {
        if (options == null) {
            return new HashMap();
        }
        return options;
    }

    protected void assertInputType(URI uri) {
        if (!this.canHandle(uri)) {
            throw new AssertionError();
        }
    }

    protected final URIUtil getUriUtil() {
        return this._uriUtil;
    }

    protected abstract URI convertToDelegateType(URI var1);
}

