/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.transaction;

import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import oracle.eclipse.tools.common.services.transaction.TransactionService;
import org.eclipse.core.runtime.jobs.Job;

public abstract class TransactionalJob
extends Job {
    private ITransactionContext currentTransaction = null;

    public TransactionalJob(String name) {
        super(name);
    }

    protected final ITransactionContext getCurrentTransaction() {
        return this.currentTransaction;
    }

    protected void startTransaction() {
        if (this.currentTransaction != null) {
            throw new IllegalStateException("Attempt to begin transaction while previous transaction is still active.");
        }
        this.currentTransaction = TransactionService.getInstance().createTransaction();
    }

    protected void commitTransaction() {
        if (this.currentTransaction == null) {
            throw new IllegalStateException("Attempt to commit transaction without an active transaction context.");
        }
        TransactionService.getInstance().commit(this.currentTransaction, null);
        this.currentTransaction = null;
    }

    protected void rollbackTransaction() {
        if (this.currentTransaction != null) {
            TransactionService.getInstance().rollback(this.currentTransaction);
            this.currentTransaction = null;
        }
    }
}

