/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.transaction;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import oracle.eclipse.tools.common.services.transaction.DataSourceExtensionReader;
import oracle.eclipse.tools.common.services.transaction.IDataSource;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class TransactionService {
    private static final AtomicLong transactionCounter = new AtomicLong();
    private static final TransactionService sINSTANCE = new TransactionService();
    private final Set<IDataSource> dataSources = DataSourceExtensionReader.getDataSources();

    private TransactionService() {
    }

    public static TransactionService getInstance() {
        return sINSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITransactionContext createTransaction() {
        TransactionContext ctx = new TransactionContext(transactionCounter.incrementAndGet());
        TransactionService transactionService = this;
        synchronized (transactionService) {
            for (IDataSource dataSource : this.dataSources) {
                dataSource.start(ctx);
            }
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(ITransactionContext context) {
        TransactionService transactionService = this;
        synchronized (transactionService) {
            for (IDataSource dataSource : this.dataSources) {
                dataSource.end(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus prepare(ITransactionContext context) {
        TransactionService transactionService = this;
        synchronized (transactionService) {
            for (IDataSource dataSource : this.dataSources) {
                dataSource.prepare(context);
            }
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(ITransactionContext context, IProgressMonitor monitor) {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)(this.dataSources.size() * 10));
        try {
            TransactionService transactionService = this;
            synchronized (transactionService) {
                for (IDataSource dataSource : this.dataSources) {
                    dataSource.commit(context, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)10));
                }
            }
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(ITransactionContext context) {
        TransactionService transactionService = this;
        synchronized (transactionService) {
            for (IDataSource dataSource : this.dataSources) {
                dataSource.rollback(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(ITransactionContext context) {
        TransactionService transactionService = this;
        synchronized (transactionService) {
            for (IDataSource dataSource : this.dataSources) {
                dataSource.forget(context);
            }
        }
    }

    private static final class TransactionContext
    implements ITransactionContext {
        private final long id;

        public TransactionContext(long id) {
            this.id = id;
        }

        @Override
        public long getTransactionID() {
            return this.id;
        }
    }
}

