/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.resources.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.resources.IElementChange;
import oracle.eclipse.tools.common.services.resources.IResourceChange;
import oracle.eclipse.tools.common.services.resources.ISequentialResourceChangeEvent;
import oracle.eclipse.tools.common.services.resources.internal.SequentialResourceChangeEvent;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IJavaElementDelta;

final class SequentialResourceChangeEventBuilder {
    private final int sequenceNumber;
    private final IResourceChangeEvent resourceEvent;
    private final ElementChangedEvent javaEvent;
    private final Set<IResourceChange> resourceChanges = new LinkedHashSet<IResourceChange>();
    private final Set<IElementChange> javaChanges = new LinkedHashSet<IElementChange>();
    private boolean markersOnly = true;

    SequentialResourceChangeEventBuilder(IResourceChangeEvent event, int sequenceNumber) {
        this.resourceEvent = event;
        this.javaEvent = null;
        this.sequenceNumber = sequenceNumber;
    }

    SequentialResourceChangeEventBuilder(ElementChangedEvent event, int sequenceNumber) {
        this.javaEvent = event;
        this.resourceEvent = null;
        this.sequenceNumber = sequenceNumber;
    }

    SequentialResourceChangeEventBuilder setResource(IResource resource) {
        if (resource != null) {
            this.markersOnly = false;
        }
        return this;
    }

    SequentialResourceChangeEventBuilder setDelta(IResourceDelta delta) {
        return this;
    }

    SequentialResourceChangeEventBuilder setDelta(IJavaElementDelta javaDelta) {
        return this;
    }

    SequentialResourceChangeEventBuilder addResourceChange(IResourceChange resourceChange) {
        this.resourceChanges.add(resourceChange);
        if (this.markersOnly) {
            this.markersOnly = resourceChange.getFlags().size() == 1 && resourceChange.getFlags().contains((Object)IResourceChange.FLAG.MARKERS);
        }
        return this;
    }

    SequentialResourceChangeEventBuilder addElementChange(IElementChange elementChange) {
        this.javaChanges.add(elementChange);
        return this;
    }

    ISequentialResourceChangeEvent build() {
        if (this.resourceEvent != null) {
            return new SequentialResourceChangeEvent(this.resourceEvent, this.sequenceNumber, this.resourceChanges, this.markersOnly);
        }
        return new SequentialResourceChangeEvent(this.javaEvent, this.sequenceNumber, this.javaChanges);
    }
}

