/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.resources.internal;

import java.util.Collections;
import java.util.EventObject;
import java.util.Set;
import oracle.eclipse.tools.common.services.resources.EventType;
import oracle.eclipse.tools.common.services.resources.IElementChange;
import oracle.eclipse.tools.common.services.resources.IResourceChange;
import oracle.eclipse.tools.common.services.resources.ISequentialResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.jdt.core.ElementChangedEvent;

final class SequentialResourceChangeEvent
extends EventObject
implements ISequentialResourceChangeEvent {
    private static final long serialVersionUID = 1L;
    private final int sequenceNumber;
    private final EventType type;
    private final boolean markerOnly;
    private final Set<IResourceChange> resourceChanges;
    private final Set<IElementChange> javaChanges;

    public SequentialResourceChangeEvent(IResourceChangeEvent event, int sequenceNumber, Set<IResourceChange> changes, boolean markerOnly) {
        super(event);
        this.sequenceNumber = sequenceNumber;
        this.type = EventType.fromIResourceChangeEventType(event.getType());
        this.resourceChanges = changes;
        this.javaChanges = null;
        this.markerOnly = markerOnly;
    }

    public SequentialResourceChangeEvent(ElementChangedEvent event, int sequenceNumber, Set<IElementChange> changes) {
        super(event);
        this.sequenceNumber = sequenceNumber;
        this.type = EventType.fromJavaChangeEventType(event.getType());
        this.resourceChanges = null;
        this.javaChanges = changes;
        this.markerOnly = false;
    }

    @Override
    public EventType getType() {
        return this.type;
    }

    @Override
    public boolean isMarkerOnly() {
        return this.markerOnly;
    }

    @Override
    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public Set<IResourceChange> getResourceChanges() {
        return this.resourceChanges == null ? null : Collections.unmodifiableSet(this.resourceChanges);
    }

    @Override
    public Set<IElementChange> getElementChanges() {
        return this.javaChanges == null ? null : Collections.unmodifiableSet(this.javaChanges);
    }

    @Override
    public boolean isResourceEvent() {
        return this.resourceChanges != null;
    }

    @Override
    public boolean isJavaEvent() {
        return this.javaChanges != null;
    }

    @Override
    public int compareTo(ISequentialResourceChangeEvent event) {
        return this.sequenceNumber > event.getSequenceNumber() ? 1 : (this.sequenceNumber == event.getSequenceNumber() ? 0 : -1);
    }

    public int hashCode() {
        return this.sequenceNumber;
    }

    public boolean equals(Object other) {
        return other instanceof SequentialResourceChangeEvent && ((SequentialResourceChangeEvent)other).sequenceNumber == this.sequenceNumber;
    }
}

