/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.resources.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import oracle.eclipse.tools.common.services.TraceOptions;
import oracle.eclipse.tools.common.services.resources.ISequentialEventManager;
import oracle.eclipse.tools.common.services.resources.ISequentialResourceChangeEvent;
import oracle.eclipse.tools.common.services.resources.internal.EventSequencer;
import oracle.eclipse.tools.common.services.resources.internal.JavaChangeEventProcessor;
import oracle.eclipse.tools.common.services.resources.internal.ResourceChangeEventProcessor;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;

class ResourceChangeListener
implements IResourceChangeListener,
IElementChangedListener {
    private final EventSequencer sequencer;
    private final ISequentialEventManager manager;
    private final AtomicBoolean isListening = new AtomicBoolean(false);

    ResourceChangeListener(ISequentialEventManager manager) {
        this.sequencer = new EventSequencer();
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListening() {
        AtomicBoolean atomicBoolean = this.isListening;
        synchronized (atomicBoolean) {
            if (!this.isListening.get()) {
                this.isListening.set(true);
                JavaCore.addPreProcessingResourceChangedListener((IResourceChangeListener)this, (int)39);
                JavaCore.addElementChangedListener((IElementChangedListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListening() {
        AtomicBoolean atomicBoolean = this.isListening;
        synchronized (atomicBoolean) {
            if (this.isListening.get()) {
                this.isListening.set(false);
                JavaCore.removePreProcessingResourceChangedListener((IResourceChangeListener)this);
                JavaCore.removeElementChangedListener((IElementChangedListener)this);
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (TraceOptions.APPXRAY_RESOURCE_CHANGES) {
            this.logEvent(event);
        }
        ResourceChangeEventProcessor processor = new ResourceChangeEventProcessor(event, this.sequencer.next());
        ISequentialResourceChangeEvent seqEvent = processor.process();
        this.manager.resourceChanged(seqEvent);
    }

    public void elementChanged(ElementChangedEvent event) {
        JavaChangeEventProcessor processor = new JavaChangeEventProcessor(event, this.sequencer.next());
        ISequentialResourceChangeEvent seqEvent = processor.process();
        this.manager.resourceChanged(seqEvent);
    }

    private void logEvent(IResourceChangeEvent event) {
        StringBuilder sb = new StringBuilder();
        sb.append("Logging Resource Change Event\n");
        sb.append("  BuildKind ");
        switch (event.getBuildKind()) {
            case 9: {
                sb.append("AUTO_BUILD");
                break;
            }
            case 15: {
                sb.append("CLEAN_BUILD");
                break;
            }
            case 6: {
                sb.append("FULL_BUILD");
                break;
            }
            case 10: {
                sb.append("INCREMENTAL_BUILD");
                break;
            }
            default: {
                sb.append(event.getBuildKind());
            }
        }
        sb.append("\n");
        sb.append("  Source ").append(event.getSource()).append("\n");
        sb.append("  Type ");
        switch (event.getType()) {
            case 1: {
                sb.append("POST_CHANGE");
                break;
            }
            case 16: {
                sb.append("POST_BUILD");
                break;
            }
            case 8: {
                sb.append("PRE_BUILD");
                break;
            }
            case 2: {
                sb.append("PRE_CLOSE");
                break;
            }
            case 4: {
                sb.append("PRE_DELETE");
                break;
            }
            case 32: {
                sb.append("PRE_REFRESH");
                break;
            }
            default: {
                sb.append("No Type");
            }
        }
        sb.append("\n");
        sb.append("  Resource ").append(event.getResource()).append("\n");
        LoggingService.logDebug((String)"oracle.eclipse.tools.common.services", (String)sb.toString());
    }
}

