/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.resources.internal;

import oracle.eclipse.tools.common.services.resources.ISequentialResourceChangeEvent;
import oracle.eclipse.tools.common.services.resources.internal.IEventProcessor;
import oracle.eclipse.tools.common.services.resources.internal.ResourceDeltaVisitor;
import oracle.eclipse.tools.common.services.resources.internal.SequentialResourceChangeEventBuilder;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

final class ResourceChangeEventProcessor
implements IEventProcessor {
    private final IResourceChangeEvent event;
    private final int sequenceNumber;

    ResourceChangeEventProcessor(IResourceChangeEvent event, int sequenceNumber) {
        this.event = event;
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public ISequentialResourceChangeEvent process() {
        SequentialResourceChangeEventBuilder builder = new SequentialResourceChangeEventBuilder(this.event, this.sequenceNumber);
        builder.setResource(this.event.getResource());
        IResourceDelta delta = this.event.getDelta();
        if (delta != null) {
            ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(builder);
            try {
                delta.accept((IResourceDeltaVisitor)visitor);
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)e);
            }
        }
        return builder.build();
    }
}

