/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.resources.internal;

import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.common.services.resources.IResourceChange;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;

final class ResourceChange
implements IResourceChange {
    private final IResource resource;
    private final Set<IResourceChange.FLAG> flags;
    private final IResourceChange.KIND kind;
    private final IPath movedFromPath;
    private final IPath movedToPath;
    private final IResourceDelta delta;

    ResourceChange(IResourceDelta delta) {
        this.delta = delta;
        this.resource = delta.getResource();
        this.flags = Collections.unmodifiableSet(IResourceChange.FLAG.fromIResourceChangeEventFlags(delta.getFlags()));
        this.kind = IResourceChange.KIND.fromIResourceChangeEventKind(delta.getKind());
        this.movedToPath = delta.getMovedToPath();
        this.movedFromPath = delta.getMovedFromPath();
    }

    ResourceChange(IProject project) {
        this.delta = null;
        this.resource = project;
        this.flags = Collections.unmodifiableSet(Collections.singleton(IResourceChange.FLAG.OPEN));
        this.kind = IResourceChange.KIND.ADDED;
        this.movedToPath = null;
        this.movedFromPath = null;
    }

    @Override
    public Set<IResourceChange.FLAG> getFlags() {
        return this.flags;
    }

    @Override
    public IResourceChange.KIND getKind() {
        return this.kind;
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    @Override
    public IPath getMovedFromPath() {
        return this.movedFromPath;
    }

    @Override
    public IPath getMovedToPath() {
        return this.movedToPath;
    }

    @Override
    public IResourceDelta getDelta() {
        return this.delta;
    }

    public String toString() {
        return "Resource [" + this.resource + "] flags [" + this.flags + "] kind [" + (Object)((Object)this.kind) + "]";
    }
}

