/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.resources.internal;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import oracle.eclipse.tools.common.services.TraceOptions;
import oracle.eclipse.tools.common.services.resources.internal.CommandSet;
import oracle.eclipse.tools.common.services.resources.internal.CommandSetJob;
import oracle.eclipse.tools.common.services.resources.internal.Messages;
import oracle.eclipse.tools.common.services.resources.internal.SequentialEventManager;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

class QueueManagerJob
extends Job {
    private static final int MAX_JOBS = 5;
    private volatile AtomicBoolean isShuttingDown = new AtomicBoolean(false);
    private final SequentialEventManager seqManager;
    private final Lock pauseLock = new ReentrantLock();
    private final Condition unPaused = this.pauseLock.newCondition();
    private volatile boolean isPaused = false;
    private final ReentrantLock executingLock = new ReentrantLock();
    private static final Object FAMILY = new Object();
    static volatile long overallStartTime = 0L;
    private CommandSet runningCommandSet = null;

    QueueManagerJob(SequentialEventManager seqManager) {
        super(Messages.QueueManagerJob_jobName);
        this.setSystem(true);
        this.seqManager = seqManager;
    }

    public void shutDown() {
        this.isShuttingDown.set(true);
        this.interrupt();
        try {
            Job.getJobManager().join(FAMILY, null);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void pause() {
        this.pauseLock.lock();
        try {
            this.isPaused = true;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    private void unpause() {
        this.pauseLock.lock();
        try {
            this.isPaused = false;
            this.unPaused.signal();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    private void interrupt() {
        Thread thisJobThread = this.getThread();
        if (thisJobThread != null) {
            thisJobThread.interrupt();
        }
    }

    CommandSet getPausedCommandSet() {
        return this.runningCommandSet;
    }

    /*
     * Exception decompiling
     */
    protected IStatus run(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean pauseNoWait() {
        this.pause();
        this.interrupt();
        return !this.executingLock.isLocked();
    }

    void pauseJobExecution() {
        this.pause();
        this.interrupt();
        if (TraceOptions.APPXRAY_LOCKS) {
            TraceOptions.log("QueueManagerJob pauseJobExecution about to acquire executingLock");
        }
        this.executingLock.lock();
        if (TraceOptions.APPXRAY_LOCKS) {
            TraceOptions.log("QueueManagerJob pauseJobExecution aquired executingLock");
        }
    }

    boolean safeControlledPause() {
        this.pause();
        this.interrupt();
        if (TraceOptions.APPXRAY_LOCKS) {
            TraceOptions.log("QueueManagerJob safeControlledPause about to acquire executingLock");
        }
        boolean lockAcquired = false;
        try {
            lockAcquired = this.executingLock.tryLock(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {}
        if (TraceOptions.APPXRAY_LOCKS) {
            TraceOptions.log("QueueManagerJob safeControlledPause aquired executingLock -" + String.valueOf(lockAcquired));
        }
        return lockAcquired;
    }

    void restartJobExecution() {
        try {
            this.unpause();
        }
        finally {
            if (this.executingLock.isHeldByCurrentThread()) {
                if (TraceOptions.APPXRAY_LOCKS) {
                    TraceOptions.log("QueueManagerJob restartJobExecution executingLock is locked about to release");
                }
                this.executingLock.unlock();
                if (TraceOptions.APPXRAY_LOCKS) {
                    TraceOptions.log("QueueManagerJob restartJobExecution executingLock released");
                }
            } else if (TraceOptions.APPXRAY_LOCKS) {
                TraceOptions.log("QueueManagerJob restartJobExecution executingLock was unlocked");
            }
        }
    }

    public boolean belongsTo(Object family) {
        return family == FAMILY;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean executeCommandSetJobs(CommandSet commandSet, IProgressMonitor monitor) {
        block19: {
            block20: {
                numJobs = Math.min(5, commandSet.numProjects());
                latch = new CountDownLatch(numJobs);
                latchModifier = new CountDownLatchJobListener(latch);
                pm = Job.getJobManager().createProgressGroup();
                pm.beginTask(Messages.QueueManagerJob_progressGroupName, 100);
                i = 0;
                while (i < numJobs) {
                    if (TraceOptions.APPXRAY_COMMANDSET) {
                        TraceOptions.log("QueueManagerJob creating and running commandSet job for " + commandSet);
                    }
                    if (success = latchModifier.addJob(job = new CommandSetJob(commandSet))) {
                        job.setProgressGroup(pm, 100 / numJobs);
                        job.setSystem(true);
                        job.schedule();
                    }
                    ++i;
                }
                done = false;
                do {
                    block18: {
                        try {
                            done = latch.await(30L, TimeUnit.SECONDS);
                            if (!(done || (remainingJobs = Job.getJobManager().find((Object)commandSet)) != null && remainingJobs.length != 0)) {
                                done = true;
                                LoggingService.logWarning((String)"oracle.eclipse.tools.common.services", (String)"QueueManagerJob mismatch between latch count and completed jobs");
                            }
                            if (!done) break block18;
                            if (latchModifier.wasCanceled()) {
                                this.seqManager.commandCanceled(commandSet);
                                break block18;
                            }
                            if (!latchModifier.wasInterrupted()) {
                                this.seqManager.eventProcessed(commandSet.getSequenceNumber());
                            }
                        }
                        catch (InterruptedException v0) {
                            remainingJobs = Job.getJobManager().find((Object)commandSet);
                            if (remainingJobs == null) break block19;
                            var12_11 = remainingJobs;
                            var11_12 = remainingJobs.length;
                            var10_13 = 0;
                            if (true) ** GOTO lbl57
                        }
                    }
                    if (monitor == null) continue;
                    this.isShuttingDown.compareAndSet(false, monitor.isCanceled());
                } while (!done && !this.isShuttingDown.get());
                break block20;
                finally {
                    pm.done();
                }
            }
            if (latchModifier.wasCanceled()) {
                v1 = false;
                return v1;
            }
            v1 = true;
            return v1;
            do {
                if ((jobThread = (remainingJob = var12_11[var10_13]).getThread()) != null) {
                    jobThread.interrupt();
                }
                ++var10_13;
lbl57:
                // 2 sources

            } while (var10_13 < var11_12);
        }
        try {
            latch.await(30L, TimeUnit.SECONDS);
            return false;
        }
        catch (InterruptedException v2) {
            return false;
        }
    }

    private static final class CountDownLatchJobListener
    extends JobChangeAdapter {
        private final CountDownLatch latch;
        private volatile boolean isCanceled = false;
        private volatile boolean isInterrupted = false;
        private final ArrayList<Job> jobs = new ArrayList();

        public CountDownLatchJobListener(CountDownLatch latch) {
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addJob(Job job) {
            ArrayList<Job> arrayList = this.jobs;
            synchronized (arrayList) {
                block4: {
                    if (!this.isCanceled) break block4;
                    return false;
                }
                this.jobs.add(job);
            }
            job.addJobChangeListener((IJobChangeListener)this);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent event) {
            ArrayList<Job> jobsToCancel = new ArrayList<Job>(this.jobs.size());
            ArrayList<Job> arrayList = this.jobs;
            synchronized (arrayList) {
                this.latch.countDown();
                this.jobs.remove(event.getJob());
                if (event.getResult().getSeverity() == 8) {
                    this.isCanceled = true;
                    for (Job job : this.jobs) {
                        jobsToCancel.add(job);
                    }
                }
                if (event.getResult().getCode() == 2048) {
                    this.isInterrupted = true;
                }
            }
            for (Job job : jobsToCancel) {
                job.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean wasCanceled() {
            ArrayList<Job> arrayList = this.jobs;
            synchronized (arrayList) {
                return this.isCanceled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean wasInterrupted() {
            ArrayList<Job> arrayList = this.jobs;
            synchronized (arrayList) {
                return this.isInterrupted;
            }
        }
    }
}

