/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.resources.internal;

import oracle.eclipse.tools.common.services.resources.ISequentialResourceChangeEvent;
import oracle.eclipse.tools.common.services.resources.internal.ElementChange;
import oracle.eclipse.tools.common.services.resources.internal.IEventProcessor;
import oracle.eclipse.tools.common.services.resources.internal.SequentialResourceChangeEventBuilder;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IJavaElementDelta;

public class JavaChangeEventProcessor
implements IEventProcessor {
    private final ElementChangedEvent event;
    private final int sequenceNumber;

    JavaChangeEventProcessor(ElementChangedEvent event, int sequenceNumber) {
        this.event = event;
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public ISequentialResourceChangeEvent process() {
        SequentialResourceChangeEventBuilder builder = new SequentialResourceChangeEventBuilder(this.event, this.sequenceNumber);
        IJavaElementDelta delta = this.event.getDelta();
        if (delta != null) {
            this.processDelta(builder, delta);
        }
        return builder.build();
    }

    private final void processDelta(SequentialResourceChangeEventBuilder builder, IJavaElementDelta delta) {
        ElementChange change = new ElementChange(delta);
        builder.addElementChange(change);
        IJavaElementDelta[] children = delta.getAffectedChildren();
        if (children != null) {
            IJavaElementDelta[] iJavaElementDeltaArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta child = iJavaElementDeltaArray[n2];
                this.processDelta(builder, child);
                ++n2;
            }
        }
    }
}

