/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.resources.internal;

import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.common.services.resources.IElementChange;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;

final class ElementChange
implements IElementChange {
    private final Set<IElementChange.FLAG> flags;
    private final IElementChange.KIND kind;
    private final IJavaElement element;
    private final IJavaElement movedFromElement;
    private final IJavaElement movedToElement;
    private final IJavaElementDelta delta;

    ElementChange(IJavaElementDelta delta) {
        this.delta = delta;
        this.element = delta.getElement();
        this.flags = Collections.unmodifiableSet(IElementChange.FLAG.fromIJavaElementChangeEventFlags(delta.getFlags()));
        this.kind = IElementChange.KIND.fromIJavaElementChangeEventKind(delta.getKind());
        this.movedToElement = delta.getMovedToElement();
        this.movedFromElement = delta.getMovedFromElement();
    }

    @Override
    public Set<IElementChange.FLAG> getFlags() {
        return this.flags;
    }

    @Override
    public IElementChange.KIND getKind() {
        return this.kind;
    }

    @Override
    public IJavaElement getElement() {
        return this.element;
    }

    @Override
    public IJavaElement getMovedFroElement() {
        return this.movedFromElement;
    }

    @Override
    public IJavaElement getMovedToElement() {
        return this.movedToElement;
    }

    @Override
    public IJavaElementDelta getDelta() {
        return this.delta;
    }
}

