/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.resources.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import oracle.eclipse.tools.common.services.resources.ICommand;
import oracle.eclipse.tools.common.services.resources.internal.CommandComparator;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class CommandSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int sequenceNumber;
    private final Set<ProjectCommandSet> commands;

    public CommandSet(int sequenceNumber, Map<IProject, PriorityBlockingQueue<ICommand>> commands) {
        this.sequenceNumber = sequenceNumber;
        this.commands = new HashSet<ProjectCommandSet>(commands.size(), 1.0f);
        for (Map.Entry<IProject, PriorityBlockingQueue<ICommand>> entry : commands.entrySet()) {
            this.commands.add(new ProjectCommandSet(entry.getKey(), entry.getValue()));
        }
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numProjects() {
        Set<ProjectCommandSet> set = this.commands;
        synchronized (set) {
            return this.commands.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Set<ProjectCommandSet> set = this.commands;
        synchronized (set) {
            return this.commands.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectCommandSet getNext() {
        Set<ProjectCommandSet> set = this.commands;
        synchronized (set) {
            Iterator<ProjectCommandSet> iter = this.commands.iterator();
            if (iter.hasNext()) {
                ProjectCommandSet pcs = iter.next();
                iter.remove();
                return pcs;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectCommandSet getNext(IProject project) {
        Set<ProjectCommandSet> set = this.commands;
        synchronized (set) {
            Iterator<ProjectCommandSet> iter = this.commands.iterator();
            while (iter.hasNext()) {
                ProjectCommandSet pcs = iter.next();
                if (project == null || !project.equals((Object)pcs.getProject())) continue;
                iter.remove();
                return pcs;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnCommandSet(ProjectCommandSet pcs) {
        Set<ProjectCommandSet> set = this.commands;
        synchronized (set) {
            this.commands.add(pcs);
        }
    }

    public int hashCode() {
        return this.sequenceNumber;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommandSet) {
            CommandSet commandSet = (CommandSet)obj;
            return this.sequenceNumber == commandSet.sequenceNumber && this.commands.equals(commandSet.commands);
        }
        return false;
    }

    public String toString() {
        return "CommandSet [" + this.sequenceNumber + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.sequenceNumber);
        for (ProjectCommandSet pcs : this.commands) {
            out.writeObject(pcs);
        }
        out.writeObject((Object)SerializationUtil.MARKER.END);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput(in);
        su.readFinalFieldFromStream(this, "sequenceNumber", Integer.TYPE);
        su.setFinalField(this, "commands", HashSet.class, new HashSet());
        Object streamObject = null;
        while ((streamObject = in.readObject()) != SerializationUtil.MARKER.END) {
            if (streamObject instanceof ProjectCommandSet) {
                ProjectCommandSet pcs = (ProjectCommandSet)streamObject;
                this.commands.add(pcs);
                continue;
            }
            throw new IllegalStateException("Corrupt comamnd file.");
        }
    }

    public static final class ProjectCommandSet
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        private final IProject project;
        private final PriorityBlockingQueue<ICommand> commands;

        ProjectCommandSet(IProject project, PriorityBlockingQueue<ICommand> commands) {
            this.project = project;
            this.commands = commands;
        }

        IProject getProject() {
            return this.project;
        }

        public PriorityBlockingQueue<ICommand> getCommands() {
            return this.commands;
        }

        public ProjectCommandSet clone() {
            PriorityBlockingQueue<ICommand> clonedQueue = new PriorityBlockingQueue<ICommand>(this.commands.size(), new CommandComparator());
            clonedQueue.addAll(this.commands);
            ProjectCommandSet clone = new ProjectCommandSet(this.project, clonedQueue);
            return clone;
        }

        public int hashCode() {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(this.project);
            hcu.hash(this.commands);
            return hcu.getHashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProjectCommandSet) {
                ProjectCommandSet pcs = (ProjectCommandSet)obj;
                return this.project == pcs.project && this.commands.equals(pcs.commands);
            }
            return false;
        }

        public String toString() {
            return "ProjectCommandSet [" + this.project + "]";
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            SerializationUtil su = SerializationUtil.forOutput(out);
            su.writeResource((IResource)this.project);
            out.writeObject(this.commands);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
            SerializationUtil su = SerializationUtil.forInput(in);
            su.readFinalProjectFromStream(this, "project");
            su.readFinalFieldFromStream(this, "commands", PriorityBlockingQueue.class);
        }
    }
}

