/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.resources;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;

public interface IResourceChange {
    public Set<FLAG> getFlags();

    public KIND getKind();

    public IResource getResource();

    public IResourceDelta getDelta();

    public IPath getMovedFromPath();

    public IPath getMovedToPath();

    public static enum FLAG {
        CONTENT,
        DERIVED_CHANGED,
        DESCRIPTION,
        ENCODING,
        LOCAL_CHANGED,
        OPEN,
        MOVED_TO,
        MOVED_FROM,
        COPIED_FROM,
        TYPE,
        SYNC,
        MARKERS,
        REPLACED;


        public static Set<FLAG> fromIResourceChangeEventFlags(int flagBits) {
            HashSet<FLAG> flags = new HashSet<FLAG>();
            if ((0x100 & flagBits) != 0) {
                flags.add(CONTENT);
            }
            if ((0x400000 & flagBits) != 0) {
                flags.add(DERIVED_CHANGED);
            }
            if ((0x80000 & flagBits) != 0) {
                flags.add(DESCRIPTION);
            }
            if ((0x100000 & flagBits) != 0) {
                flags.add(ENCODING);
            }
            if ((0x200000 & flagBits) != 0) {
                flags.add(LOCAL_CHANGED);
            }
            if ((0x4000 & flagBits) != 0) {
                flags.add(OPEN);
            }
            if ((0x2000 & flagBits) != 0) {
                flags.add(MOVED_TO);
            }
            if ((0x1000 & flagBits) != 0) {
                flags.add(MOVED_FROM);
            }
            if ((0x800 & flagBits) != 0) {
                flags.add(COPIED_FROM);
            }
            if ((0x8000 & flagBits) != 0) {
                flags.add(TYPE);
            }
            if ((0x10000 & flagBits) != 0) {
                flags.add(SYNC);
            }
            if ((0x20000 & flagBits) != 0) {
                flags.add(MARKERS);
            }
            if ((0x40000 & flagBits) != 0) {
                flags.add(REPLACED);
            }
            return flags;
        }
    }

    public static enum KIND {
        NO_CHANGE,
        ADDED,
        REMOVED,
        CHANGED,
        ADDED_PHANTOM,
        REMOVED_PHANTOM;


        public static KIND fromIResourceChangeEventKind(int kind) {
            switch (kind) {
                case 0: {
                    return NO_CHANGE;
                }
                case 1: {
                    return ADDED;
                }
                case 2: {
                    return REMOVED;
                }
                case 4: {
                    return CHANGED;
                }
                case 8: {
                    return ADDED_PHANTOM;
                }
                case 16: {
                    return REMOVED_PHANTOM;
                }
            }
            return null;
        }
    }
}

