/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.refactoring.internal;

import java.util.ArrayList;
import java.util.Arrays;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.refactoring.IArtifactRefactoringService;
import oracle.eclipse.tools.common.services.refactoring.RefactoringUtil;
import oracle.eclipse.tools.common.services.refactoring.internal.CommonRenameArguments;
import oracle.eclipse.tools.common.services.refactoring.internal.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.internal.core.refactoring.Resources;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class CommonArtifactRefactoringProcessor
extends RenameProcessor {
    private final IFile file;
    private final IArtifact artifact;
    private final Range range;
    private CommonRenameArguments renameArguments;
    private boolean isUpdateReferences = true;
    private String newText = "";
    private IArtifactRefactoringService service;

    public CommonArtifactRefactoringProcessor(IFile file, IArtifact artifact, Range range) {
        String oldText;
        IArtifactRefactoringService refactoringService;
        this.file = file;
        this.artifact = artifact;
        this.range = range;
        Project project = (Project)file.getProject().getAdapter(Project.class);
        if (project != null && (refactoringService = project.getAppService(IArtifactRefactoringService.class)) != null) {
            this.service = refactoringService;
        }
        if ((oldText = RefactoringUtil.getRangeString(file, range)) != null) {
            this.setNewText(oldText);
        }
    }

    public Object[] getElements() {
        return new Object[]{this.artifact};
    }

    public String getIdentifier() {
        return "oracle.eclipse.tools.common.services.CommonArtifactProcessor";
    }

    public String getProcessorName() {
        return Messages.CommonArtifactRefactoringProcessor_processorName;
    }

    public boolean isApplicable() throws CoreException {
        return this.artifact != null;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IResource[] resources = this.artifact.getAffectedResources();
        return RefactoringStatus.create((IStatus)Resources.checkInSync((IResource[])resources));
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        pm.beginTask("", 1);
        try {
            this.renameArguments = new CommonRenameArguments(this.getNewText(), this.isUpdateReferences);
            this.renameArguments.put("range", this.range);
            this.renameArguments.put("file", this.file);
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
            checker.getDeltaFactory().change(this.file);
            RefactoringStatus refactoringStatus = checker.check(pm);
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(Messages.CommonArtifactRefactoringProcessor_changeName);
        TextFileChange fileChange = new TextFileChange(this.getFile().getName(), this.getFile());
        fileChange.setEdit((TextEdit)new ReplaceEdit((int)this.range.getOffset(), (int)this.range.getLength(), this.getArguments().getNewName()));
        change.add((Change)fileChange);
        return change;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        ArrayList<RenameParticipant> participants = new ArrayList<RenameParticipant>();
        participants.addAll(Arrays.asList(ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.getElements()[0], (RenameArguments)this.renameArguments, (String[])new String[]{"org.eclipse.wst.common.modulecore.ModuleCoreNature"}, (SharableParticipants)sharedParticipants)));
        if (this.getElements()[0] != this.artifact) {
            participants.addAll(Arrays.asList(ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.artifact, (RenameArguments)this.renameArguments, (String[])new String[]{"org.eclipse.wst.common.modulecore.ModuleCoreNature"}, (SharableParticipants)sharedParticipants)));
        }
        return participants.toArray(new RefactoringParticipant[participants.size()]);
    }

    public boolean isUpdateRefereces() {
        return this.isUpdateReferences;
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.isUpdateReferences = updateReferences;
    }

    public void setNewText(String text) {
        this.newText = text;
    }

    public String getNewText() {
        return this.newText;
    }

    public IFile getFile() {
        return this.file;
    }

    public RenameArguments getArguments() {
        return this.renameArguments;
    }

    public RefactoringStatus validateNewText(String text) {
        RefactoringStatus validateStatus = RefactoringStatus.create((IStatus)Status.OK_STATUS);
        if (this.service != null) {
            validateStatus.merge(this.service.validateArtifactRename(this.artifact, text));
        }
        return validateStatus;
    }
}

