/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.refactoring.internal;

import java.util.ArrayList;
import oracle.eclipse.tools.common.services.refactoring.internal.ArtifactReferenceFolderRenameParticipant;
import oracle.eclipse.tools.common.services.refactoring.internal.ArtifactReferenceMoveHelper;
import oracle.eclipse.tools.common.services.refactoring.internal.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class ArtifactReferencePackageRenameParticipant
extends RenameParticipant
implements ISharableParticipant {
    private String oldRootPackageName = null;
    private ArtifactReferenceMoveHelper artifactRefMoveHelper = new ArtifactReferenceMoveHelper();

    public void addElement(Object element, RefactoringArguments arguments) {
        if (element instanceof IPackageFragment) {
            IPackageFragment packageFragment = (IPackageFragment)element;
            String oldPkgName = packageFragment.getElementName();
            IJavaElement parent = packageFragment.getParent();
            if (this.oldRootPackageName == null) {
                return;
            }
            if (!oldPkgName.startsWith(this.oldRootPackageName)) {
                return;
            }
            String remainingPkgStr = oldPkgName.substring(this.oldRootPackageName.length());
            IResource resource = null;
            try {
                resource = packageFragment.getUnderlyingResource();
                if (!(resource instanceof IFolder) || !(parent instanceof IPackageFragmentRoot)) {
                    return;
                }
            }
            catch (JavaModelException javaModelException) {
                return;
            }
            IFolder folderToBeRenamed = (IFolder)resource;
            IFolder pkgFragmentRootFolder = (IFolder)parent.getResource();
            String newName = this.getArguments().getNewName();
            newName = String.valueOf(newName) + remainingPkgStr;
            String newPath = newName.replace('.', '/');
            ArrayList<IFile> files = new ArrayList<IFile>();
            ArtifactReferenceMoveHelper.FolderResourceProxyVisitor folderVisitor = new ArtifactReferenceMoveHelper.FolderResourceProxyVisitor(files);
            folderVisitor.setVisitSubfolders(false);
            folderVisitor.visitFolder(folderToBeRenamed);
            IFolder newContainer = pkgFragmentRootFolder.getFolder((IPath)new Path(newPath));
            ArtifactReferenceFolderRenameParticipant.determineReferencesToMovedArtifacts(files, folderToBeRenamed, (IContainer)newContainer, false, this.artifactRefMoveHelper);
        }
    }

    protected boolean initialize(Object element) {
        if (element instanceof IPackageFragment) {
            IPackageFragment packageFragment = (IPackageFragment)element;
            this.oldRootPackageName = packageFragment.getElementName();
            this.addElement(element, (RefactoringArguments)this.getArguments());
            return true;
        }
        return false;
    }

    public String getName() {
        return Messages.ArtifactReferencePackageRenameParticipant_name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return this.artifactRefMoveHelper.checkConditionsForMove(pm, context);
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.artifactRefMoveHelper.createChangeForMove(pm, this.getProcessor());
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }
}

