/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.refactoring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.operations.OperationUtil;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IVirtualArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RefactoringUtil {
    public static final String KEY_RANGE = "range";
    public static final String KEY_FILE = "file";

    public static IArtifact elementToArtifact(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof IArtifact) {
            return (IArtifact)element;
        }
        Object adaptedArtifact = AdapterManager.getDefault().loadAdapter(element, IArtifact.class.getName());
        if (adaptedArtifact instanceof IArtifact) {
            return (IArtifact)adaptedArtifact;
        }
        Object adaptedResource = AdapterManager.getDefault().loadAdapter(element, IResource.class.getName());
        if (adaptedResource instanceof IResource) {
            return RefactoringUtil.ensureResourceArtifact((IResource)adaptedResource);
        }
        return null;
    }

    public static IArtifact ensureResourceArtifact(IResource resource) {
        return DependencyModelManager.getInstance().getModel().ensureResourceArtifact(resource);
    }

    public static Range getReplaceRange(IFile file, Range oldRange, String oldtext) {
        Assert.isNotNull((Object)file);
        Assert.isNotNull((Object)oldRange);
        Assert.isTrue((boolean)file.exists());
        String string = RefactoringUtil.getRangeString(file, oldRange);
        if (oldtext != null && oldtext.equals("") && string.matches("\\s*<[a-zA-Z\\-]+>\\s*</[a-zA-Z\\-]+>\\s*")) {
            return new Range(oldRange.getOffset() + (long)string.indexOf(62) + 1L, 0L);
        }
        int oldTextIndx = string.indexOf(oldtext);
        if (oldTextIndx != -1 && oldtext != null) {
            return new Range(oldRange.getOffset() + (long)oldTextIndx, oldtext.length());
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getRangeString(IFile file, Range range) {
        Assert.isNotNull((Object)file);
        Assert.isNotNull((Object)range);
        Assert.isTrue((boolean)file.exists());
        InputStream is = null;
        is = file.getContents();
        BufferedReader in = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        in.skip(range.getOffset());
        CharBuffer buffer = CharBuffer.allocate((int)range.getLength());
        in.read(buffer);
        buffer.rewind();
        String string = buffer.toString();
        if (is == null) return string;
        try {
            is.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
        catch (CoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)e);
            if (is == null) return null;
            try {
                is.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
        catch (IOException e2) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e2);
            if (is == null) return null;
            {
                catch (Throwable throwable) {
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                is.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    public static void createChangesForArtifactReferences(RefactoringProcessor processor, CompositeChange change, Set<IArtifactReference> artifactReferences, String oldName, String newName, Map<IFile, TextChange> fileToTextChangeMap) {
        for (IArtifactReference reference : artifactReferences) {
            for (IArtifactReferenceLocation location : reference.getLocations()) {
                ResourceLocation resLocation = location.getResourceLocation();
                if (resLocation == null) continue;
                RefactoringUtil.createChangeForLocation(processor, oldName, newName, resLocation, change, fileToTextChangeMap);
            }
        }
    }

    public static void createChangeForLocation(RefactoringProcessor processor, String oldName, String newName, ResourceLocation resLocation, CompositeChange change, Map<IFile, TextChange> fileToTextChangeMap) {
        IResource resource = resLocation.getResource();
        if (resource instanceof IFile && resource.exists()) {
            Range editRange;
            IFile file = (IFile)resource;
            Range locationRange = resLocation.getRange();
            if (locationRange != null && (editRange = RefactoringUtil.getReplaceRange(file, resLocation.getRange(), oldName)) != null) {
                TextChange fileChange = fileToTextChangeMap.get(file);
                if (fileChange == null && (fileChange = processor.getRefactoring().getTextChange((Object)file)) == null) {
                    fileChange = new TextFileChange(file.getName(), file);
                    MultiTextEdit fileChangeRootEdit = new MultiTextEdit();
                    fileChange.setEdit((TextEdit)fileChangeRootEdit);
                    change.add((Change)fileChange);
                    fileToTextChangeMap.put(file, fileChange);
                }
                ReplaceEdit edit = new ReplaceEdit((int)editRange.getOffset(), (int)editRange.getLength(), newName);
                fileChange.addEdit((TextEdit)edit);
            }
        }
    }

    public static void createChangesForArtifact(RefactoringProcessor refactoringProcessor, CompositeChange change, Set<IArtifact> artifacts, String oldName, String newName) {
        HashMap<IFile, TextChange> fileToTextChangeMap = new HashMap<IFile, TextChange>();
        for (IArtifact artifact : artifacts) {
            ResourceLocation resLocation = null;
            if (artifact instanceof IVirtualArtifact && (resLocation = ((IVirtualArtifact)artifact).getBoundedLocation()) == null) {
                resLocation = artifact.getLocation();
            }
            if (resLocation == null) continue;
            RefactoringUtil.createChangeForLocation(refactoringProcessor, oldName, newName, resLocation, change, fileToTextChangeMap);
        }
    }

    public static IPath getNormailizeToContainerPath(IResource resource) {
        Assert.isNotNull((Object)resource);
        try {
            IContainer wc = OperationUtil.getWebContentFolderIResource((IProject)resource.getProject());
            IPath wcPath = wc.getFullPath();
            if (wcPath.isPrefixOf(resource.getFullPath())) {
                return resource.getFullPath().makeRelativeTo(wcPath);
            }
        }
        catch (CoreException coreException) {}
        IPath classpathPath = JavaUtil.getRelativeClasspathPath((IResource)resource);
        if (classpathPath != null) {
            return classpathPath;
        }
        return resource.getProjectRelativePath();
    }

    public static RefactoringStatus checkFileConditions(Set<IArtifactReference> artifactReferences, CheckConditionsContext context) {
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        for (IArtifactReference reference : artifactReferences) {
            for (IArtifactReferenceLocation location : reference.getLocations()) {
                IResource resource;
                ResourceLocation resLocation = location.getResourceLocation();
                if (resLocation == null || !((resource = resLocation.getResource()) instanceof IFile)) continue;
                deltaFactory.change((IFile)resource);
            }
        }
        return new RefactoringStatus();
    }
}

